#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <iostream>
#include "diskload.h"
using namespace std;

DiskloadMeter::DiskloadMeter()
{
  struct timezone timez;
  gettimeofday(&oldtime, &timez);
}


float DiskloadMeter::nlget_elapsed_time()
{
  struct timeval time;
  struct timezone timez;
  gettimeofday(&time, &timez);

  float elapsed_time = (time.tv_sec - oldtime.tv_sec)
                       + (float) (time.tv_usec - oldtime.tv_usec) / 1000000.0;
  oldtime.tv_sec = time.tv_sec;
  oldtime.tv_usec = time.tv_usec;
  return (elapsed_time);
}


#ifdef __linux__
/*
#define BUFSIZE 4096
bool DiskloadMeter::getDiskload(Diskload & diskload)
{
  FILE * f = fopen("/proc/stat", "r");
  if (f != 0)
  {
    char buf[BUFSIZE];
    // Read the file into a buffer.
    int num = fread(buf, 1, BUFSIZE - 1, f);
    fclose(f);

    if (num > 0)
    {
      buf[num] = 0;

      char *pch = strstr(buf, "page");
      if (pch != 0)
      {
        // Skip the interface name.
        pch += strlen("page");

        unsigned long readkbytes, writekbytes;

        if (2 == sscanf(pch, "%lu %lu",&readkbytes, &writekbytes))
        {
          float elapsed = nlget_elapsed_time();

          diskload.readkbytespersec = (readkbytes - lastreadkbytes) / elapsed;
          diskload.writekbytespersec = (writekbytes - lastwritekbytes) / elapsed;

          lastreadkbytes=readkbytes;
	  lastwritekbytes=writekbytes;

          return true;
        }
      }
    }
  }
  return false;
}
*/

bool DiskloadMeter::getDiskload(Diskload & diskload)
{
  FILE *fcinfo;
  if ( (fcinfo = fopen("/proc/vmstat", "r") ) != NULL)
  {
    int entriesFound=0;
    long readkbytes, writekbytes;
    while (true)
    {
      char entry[200];
      long value;

      // FIXME: limit the value of scanned chars to prevent buffer overruns
      int fsret = fscanf(fcinfo, "%[^\t ]%*[\t ]%ld\n", entry, &value);
      if (fsret == EOF)
        break;

      if (fsret == 2)
      {
        // interpret the fscanned data
        if (0 == strcmp(entry, "pgpgin"))
        {
          readkbytes=value;
          entriesFound++;
        }

        if (0 == strcmp(entry, "pgpgout"))
        {
          writekbytes=value;
          entriesFound++;
        }
      }
    }
    fclose(fcinfo);

    if (2==entriesFound)
    {
      float elapsed = nlget_elapsed_time();

      diskload.readkbytespersec = (readkbytes - lastreadkbytes) / elapsed;
      diskload.writekbytespersec = (writekbytes - lastwritekbytes) / elapsed;

      lastreadkbytes=readkbytes;
      lastwritekbytes=writekbytes;

      return true;
    }
  }
  return false;
}
#endif



#ifdef __sun__
bool DiskloadMeter::getDiskload(Diskload & diskload)
{
  diskload.readkbytespersec = -1.;
  diskload.writekbytespersec = -1.;
  return false;
}
#endif


#ifdef __FreeBSD__
bool DiskloadMeter::getDiskload(Diskload & diskload)
{
  diskload.readkbytespersec = -1.;
  diskload.writekbytespersec = -1.;
  return false;
}
#endif
