find_library(PATH_PCRE_LIB
  NAMES pcre
  HINTS
  $ENV{SIMGRID_PCRE_LIBRARY_PATH}
  $ENV{LD_LIBRARY_PATH}
  $ENV{PCRE_LIBRARY_PATH}
  PATH_SUFFIXES lib/ GnuWin32/lib
  PATHS
  /opt
  /opt/local
  /opt/csw
  /sw
  /usr)

find_path(PATH_PCRE_H "pcre.h"
  HINTS
  $ENV{SIMGRID_PCRE_LIBRARY_PATH}
  $ENV{LD_LIBRARY_PATH}
  $ENV{PCRE_LIBRARY_PATH}
  PATH_SUFFIXES include/ GnuWin32/include
  PATHS
  /opt
  /opt/local
  /opt/csw
  /sw
  /usr)

message(STATUS "Looking for pcre.h")
if(PATH_PCRE_H)
  message(STATUS "Looking for pcre.h - found")
else()
  message(STATUS "Looking for pcre.h - not found")
endif()

message(STATUS "Looking for lib pcre")
if(PATH_PCRE_LIB)
  message(STATUS "Looking for lib pcre - found")
else()
  message(STATUS "Looking for lib pcre - not found")
endif()

if(PATH_PCRE_LIB AND PATH_PCRE_H)
  string(REGEX REPLACE "/libpcre.*[.]${LIB_EXE}$" "" PATH_PCRE_LIB "${PATH_PCRE_LIB}")
  string(REGEX REPLACE "/pcre.h" "" PATH_PCRE_H "${PATH_PCRE_H}")
  include_directories(${PATH_PCRE_H})
  link_directories(${PATH_PCRE_LIB})
else()
  message(FATAL_ERROR "Please install the libpcre3-dev package or equivalent before using SimGrid.")
endif()

set(PCRE_LIBRARY_PATH $ENV{PCRE_LIBRARY_PATH})

mark_as_advanced(PATH_PCRE_H)
mark_as_advanced(PATH_PCRE_LIB)