//  libsigcperl -- a helper library for writing XSUB wrappers of libsigc++
//  Copyright (C) 2002 Ron Steinke
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the 
//  Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
//  Boston, MA  02111-1307  USA.

// This is a generated file, do not edit. Generated from signal_wrap.h.m4.

/* This is a generated file, do not edit.  Generated from template.macros.m4 */








#ifndef SIGC_PERL_SIGNAL_WRAP_H
#define SIGC_PERL_SIGNAL_WRAP_H

#include <sigcperl/signal_base.h>
#include <sigc++/adaptor.h>



namespace SigCPerl {
// ---------- Perl Signal 0 ----------

template <class R,class Marsh=SigC::Marshal<R> >
class SignalWrapper0 : public SignalBase
{
 public:
  typedef SigC::Signal0<R,Marsh> SignalType;
  typedef SigC::Slot0<R> SlotType;

  SignalWrapper0(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    

    // std::cerr << "Ready to emit\n";

    R val = m_signal.emit(
      );

    // std::cerr << "Did the emit\n";

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return value 
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalWrapper0(const SignalWrapper0&);
  SignalWrapper0& operator=(const SignalWrapper0&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class Marsh>
class SignalWrapper0<void,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal0<void,Marsh> SignalType;
  typedef SigC::Slot0<void> SlotType;

  SignalWrapper0(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    

    // std::cerr << "Ready to emit\n";

    m_signal.emit(
      );

    // std::cerr << "Did the emit\n";

    return Data();
  }

 private:
  static void conv_func(SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalWrapper0(const SignalWrapper0&);
  SignalWrapper0& operator=(const SignalWrapper0&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class Marsh>
SignalBase* WrapSignal(SigC::Signal0<R,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalWrapper0<R,Marsh>(signal, parent);
}

// ---------- Perl Signal 1 ----------

template <class R,class P1,class Marsh=SigC::Marshal<R> >
class SignalWrapper1 : public SignalBase
{
 public:
  typedef SigC::Signal1<R,P1,Marsh> SignalType;
  typedef SigC::Slot1<R,P1> SlotType;

  SignalWrapper1(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 1)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);

    // std::cerr << "Ready to emit\n";

    R val = m_signal.emit(
      p1.val());

    // std::cerr << "Did the emit\n";

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return value 
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalWrapper1(const SignalWrapper1&);
  SignalWrapper1& operator=(const SignalWrapper1&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class Marsh>
class SignalWrapper1<void,P1,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal1<void,P1,Marsh> SignalType;
  typedef SigC::Slot1<void,P1> SlotType;

  SignalWrapper1(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 1)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);

    // std::cerr << "Ready to emit\n";

    m_signal.emit(
      p1.val());

    // std::cerr << "Did the emit\n";

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalWrapper1(const SignalWrapper1&);
  SignalWrapper1& operator=(const SignalWrapper1&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class Marsh>
SignalBase* WrapSignal(SigC::Signal1<R,P1,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalWrapper1<R,P1,Marsh>(signal, parent);
}

// ---------- Perl Signal 2 ----------

template <class R,class P1,class P2,class Marsh=SigC::Marshal<R> >
class SignalWrapper2 : public SignalBase
{
 public:
  typedef SigC::Signal2<R,P1,P2,Marsh> SignalType;
  typedef SigC::Slot2<R,P1,P2> SlotType;

  SignalWrapper2(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 2)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);

    // std::cerr << "Ready to emit\n";

    R val = m_signal.emit(
      p1.val(), p2.val());

    // std::cerr << "Did the emit\n";

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return value 
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalWrapper2(const SignalWrapper2&);
  SignalWrapper2& operator=(const SignalWrapper2&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class Marsh>
class SignalWrapper2<void,P1,P2,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal2<void,P1,P2,Marsh> SignalType;
  typedef SigC::Slot2<void,P1,P2> SlotType;

  SignalWrapper2(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 2)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);

    // std::cerr << "Ready to emit\n";

    m_signal.emit(
      p1.val(), p2.val());

    // std::cerr << "Did the emit\n";

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalWrapper2(const SignalWrapper2&);
  SignalWrapper2& operator=(const SignalWrapper2&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class P2,class Marsh>
SignalBase* WrapSignal(SigC::Signal2<R,P1,P2,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalWrapper2<R,P1,P2,Marsh>(signal, parent);
}

// ---------- Perl Signal 3 ----------

template <class R,class P1,class P2,class P3,class Marsh=SigC::Marshal<R> >
class SignalWrapper3 : public SignalBase
{
 public:
  typedef SigC::Signal3<R,P1,P2,P3,Marsh> SignalType;
  typedef SigC::Slot3<R,P1,P2,P3> SlotType;

  SignalWrapper3(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 3)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);

    // std::cerr << "Ready to emit\n";

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val());

    // std::cerr << "Did the emit\n";

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return value 
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalWrapper3(const SignalWrapper3&);
  SignalWrapper3& operator=(const SignalWrapper3&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class Marsh>
class SignalWrapper3<void,P1,P2,P3,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal3<void,P1,P2,P3,Marsh> SignalType;
  typedef SigC::Slot3<void,P1,P2,P3> SlotType;

  SignalWrapper3(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 3)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);

    // std::cerr << "Ready to emit\n";

    m_signal.emit(
      p1.val(), p2.val(), p3.val());

    // std::cerr << "Did the emit\n";

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalWrapper3(const SignalWrapper3&);
  SignalWrapper3& operator=(const SignalWrapper3&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class P2,class P3,class Marsh>
SignalBase* WrapSignal(SigC::Signal3<R,P1,P2,P3,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalWrapper3<R,P1,P2,P3,Marsh>(signal, parent);
}

// ---------- Perl Signal 4 ----------

template <class R,class P1,class P2,class P3,class P4,class Marsh=SigC::Marshal<R> >
class SignalWrapper4 : public SignalBase
{
 public:
  typedef SigC::Signal4<R,P1,P2,P3,P4,Marsh> SignalType;
  typedef SigC::Slot4<R,P1,P2,P3,P4> SlotType;

  SignalWrapper4(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 4)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);

    // std::cerr << "Ready to emit\n";

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val());

    // std::cerr << "Did the emit\n";

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return value 
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalWrapper4(const SignalWrapper4&);
  SignalWrapper4& operator=(const SignalWrapper4&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class P4,class Marsh>
class SignalWrapper4<void,P1,P2,P3,P4,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal4<void,P1,P2,P3,P4,Marsh> SignalType;
  typedef SigC::Slot4<void,P1,P2,P3,P4> SlotType;

  SignalWrapper4(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 4)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);

    // std::cerr << "Ready to emit\n";

    m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val());

    // std::cerr << "Did the emit\n";

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalWrapper4(const SignalWrapper4&);
  SignalWrapper4& operator=(const SignalWrapper4&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class P2,class P3,class P4,class Marsh>
SignalBase* WrapSignal(SigC::Signal4<R,P1,P2,P3,P4,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalWrapper4<R,P1,P2,P3,P4,Marsh>(signal, parent);
}

// ---------- Perl Signal 5 ----------

template <class R,class P1,class P2,class P3,class P4,class P5,class Marsh=SigC::Marshal<R> >
class SignalWrapper5 : public SignalBase
{
 public:
  typedef SigC::Signal5<R,P1,P2,P3,P4,P5,Marsh> SignalType;
  typedef SigC::Slot5<R,P1,P2,P3,P4,P5> SlotType;

  SignalWrapper5(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 5)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);
    ArgBox<P5> p5(*itr++);

    // std::cerr << "Ready to emit\n";

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val(), p5.val());

    // std::cerr << "Did the emit\n";

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,typename SigC::Trait<P5>::ref p5,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);
    data.push_back(p5);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return value 
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalWrapper5(const SignalWrapper5&);
  SignalWrapper5& operator=(const SignalWrapper5&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class P4,class P5,class Marsh>
class SignalWrapper5<void,P1,P2,P3,P4,P5,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal5<void,P1,P2,P3,P4,P5,Marsh> SignalType;
  typedef SigC::Slot5<void,P1,P2,P3,P4,P5> SlotType;

  SignalWrapper5(SignalType &signal, SV *parent = 0) throw()
    : m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    // std::cerr << "Called emit\n";

    if(data.size() < 5)
      throw BadConvertVal();

    Data::Iter itr = data.begin();
    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);
    ArgBox<P5> p5(*itr++);

    // std::cerr << "Ready to emit\n";

    m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val(), p5.val());

    // std::cerr << "Did the emit\n";

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,typename SigC::Trait<P5>::ref p5,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);
    data.push_back(p5);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalWrapper5(const SignalWrapper5&);
  SignalWrapper5& operator=(const SignalWrapper5&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class P2,class P3,class P4,class P5,class Marsh>
SignalBase* WrapSignal(SigC::Signal5<R,P1,P2,P3,P4,P5,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalWrapper5<R,P1,P2,P3,P4,P5,Marsh>(signal, parent);
}

} // namespace SigCPerl

#endif // SIGC_PERL_SIGNAL_WRAP_H
