/* $Id: main.c,v 1.4 2003/05/30 00:42:40 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "port.h"
#include "arp.h"
#include "misc.h"
#include "mbuf.h"
#include "dhcp.h"
#include "packet.h"
#include "dns.h"
#include "tftp.h"
#include "global.h"

/* Global instantiations */
net_cfg_t net_cfg;

uint8_t big_buffer[5000000];

static void dump_ip(uint32_t ip) 
{
	lib_printf("%i.%i.%i.%i", ip>>24, (ip>>16) & 0xff, (ip>>8) & 0xff, ip & 0xff);
}


#include <stdio.h>
int main(void)
{
	int i;
	uint64_t foo_mac;
	uint32_t tmp;
	uint32_t baton_ip;
	dhcp_info_t info;
	net_cfg.mac_addr = 0x400000014A4C;
	lib_init();
	if (packet_open("eth0")) {
		lib_printf("backend_open failed\n");
		return -1;
	}
	if (!arp_resolve(0xa15409d, &foo_mac)) {
		lib_printf("Resolved carmel to ");
		dump_eth_addr(foo_mac);
		lib_printf("\n");
	} else {
		lib_printf("resolve failed\n");
	}
	if (!dhcp_get_boot_info(&info)) {
		lib_printf("My IP is ");
		dump_ip(info.client_ip);
		lib_printf("\n"
			   "Server name is %s\n"
			   "Boot filename is %s\n"
			   "Subnet mask is ", 
			   info.server_name,
			   info.boot_filename);
		dump_ip(info.subnet_mask);
		lib_printf("\n"
			   "Gateway is ");
		dump_ip(info.gateway);
		lib_printf("\n"
			   "Nameservers are: ");
		for (i = 0; i < DHCP_MAX_NAMESERVERS; i++) {
			dump_ip(info.nameservers[i]);
			lib_printf(" ");
		}
		lib_printf("\n"
			   "Server is ");
		dump_ip(info.server);
		lib_printf("\n");
		net_cfg.ip_addr = info.client_ip;
		net_cfg.ip_net_mask = info.subnet_mask;
		net_cfg.ip_gateway = info.gateway;
		net_cfg.ip_ns1 = 0x12345678;
		net_cfg.ip_ns2 = info.nameservers[0];
	} else {
		lib_printf("dhcp failed\n");
	}
	arp_add_response(net_cfg.ip_addr, net_cfg.mac_addr);
	baton_ip = dns_resolve_name("baton.sibyte.com");
	lib_printf("Resolved baton to ip ");
	dump_ip(baton_ip);
	lib_printf("\n");
	tmp = tftp_get_file(baton_ip, TFTP_PORT, "vmlinux", big_buffer, 5000000);
	lib_printf("Got %i bytes\n", tmp);
	return 0; 
	
}
