/*
 *  Part of the shrinkta program, a dvd copy tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#ifndef __PREFERENCES_DIALOG_H__
#define __PREFERENCES_DIALOG_H__

#define PREFERENCES_DIALOG_TYPE		(preferences_dialog_get_type())
#define PREFERENCES_DIALOG(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), PREFERENCES_DIALOG_TYPE, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST    ((k), PREFERENCES_DIALOG_TYPE, PreferencesDialogClass))
#define PREFERENCES_IS_DIALOG(o)	(G_TYPE_CHECK_INSTANCE_TYPE ((o), PREFERENCES_DIALOG_TYPE))
#define PREFERENCES_IS_DIALOG_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    ((k), PREFERENCES_DIALOG_TYPE))


typedef struct _PreferencesDialog	PreferencesDialog;
typedef struct _PreferencesDialogClass	PreferencesDialogClass;

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
	
};

typedef enum _PreferencesDialogTab {
	PREFERENCES_DIALOG_TAB_GENERAL,
	PREFERENCES_DIALOG_TAB_MEDIA,
	PREFERENCES_DIALOG_TAB_AUDIO,
	PREFERENCES_DIALOG_TAB_VIDEO
} PreferencesDialogTab;

GType			preferences_dialog_get_type	(void);
GtkWidget*		preferences_dialog_new		(Preferences	*prefs,
							 GtkWindow	*parent);
PreferencesDialogTab	preferences_dialog_get_tab	(PreferencesDialog	*preferences_dialog);

#endif /* __PREFERENCES_DIALOG_H__ */

