/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#include <config.h>
#include <inttypes.h>
#include <glib-object.h>
#include <glib/gi18n.h>
#include <dvdread/ifo_read.h>
#include <string.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "dvd.h"

static GObjectClass *dvd_audio_parent_class = NULL;

static void   dvd_audio_class_init	(DvdAudioClass	*class);
static void   dvd_audio_instance_init	(GTypeInstance	*instance,
					 gpointer	 g_class);
static void   dvd_audio_dispose		(GObject	*object);

static void
dvd_audio_class_init		(DvdAudioClass	*class)
{
	GObjectClass *object_class = (GObjectClass *) class;
	
	dvd_audio_parent_class = g_type_class_ref (G_TYPE_OBJECT);
	object_class->dispose = dvd_audio_dispose;
}

static void
dvd_audio_instance_init	(GTypeInstance	*instance,
			 gpointer	 g_class)
{
	DvdAudio *audio;
	
	audio = DVD_AUDIO (instance);
}

static void
dvd_audio_dispose		(GObject	*object)
{
	DvdAudio *audio;
	
	audio = DVD_AUDIO (object);
	G_OBJECT_CLASS (dvd_audio_parent_class)->dispose (object);
}

/**
 * dvd_audio_get_type:
 *
 * Returns the GType for the DvdAudio class.
 */

GType
dvd_audio_get_type		(void)
{
	static GType dvd_audio_type = 0;

	if (dvd_audio_type == 0) {
		GTypeInfo dvd_audio_info = {
			sizeof (DvdAudioClass),
			NULL,
			NULL,
			(GClassInitFunc) dvd_audio_class_init,
			NULL,
			NULL, /* class_data */
			sizeof (DvdAudio),
			0, /* n_preallocs */
			(GInstanceInitFunc) dvd_audio_instance_init
	    	};
		dvd_audio_type = g_type_register_static (G_TYPE_OBJECT,
							 "DvdAudio",
							 &dvd_audio_info, 0);
	}
	return dvd_audio_type;
}

DvdAudio
*dvd_audio_new			(void)
{
	DvdAudio *audio;
	
	audio = g_object_new (DVD_AUDIO_TYPE, NULL);
	return audio;
}

void
dvd_audio_set_number		(DvdAudio	*audio,
				 guint8		 number)
{
	g_assert (audio != NULL);
	
	audio->number = number;
}


guint8
dvd_audio_get_number		(DvdAudio	*audio)
{
	g_assert (audio != NULL);
	
	return audio->number;
}

void
dvd_audio_set_channels		(DvdAudio	*audio,
				 guint8		 channels)
{
	g_assert (audio != NULL);
	
	audio->channels = channels;
}

guint8
dvd_audio_get_channels		(DvdAudio	*audio)
{
	g_assert (audio != NULL);
	
	return audio->channels;
}

void
dvd_audio_set_lang		(DvdAudio	*audio,
				 DvdLanguage	 lang)
{
	g_assert (audio != NULL);
	
	audio->lang = lang;
}

DvdLanguage
dvd_audio_get_lang		(DvdAudio	*audio)
{
	g_assert (audio != NULL);
	
	return audio->lang;
}

void
dvd_audio_set_format		(DvdAudio	*audio,
				 DvdAudioFormat	 format)
{
	g_assert (audio != NULL);
	
	audio->format = format;
}

DvdAudioFormat
dvd_audio_get_format		(DvdAudio	*audio)
{
	g_assert (audio != NULL);
	
	return audio->format;
}

void
dvd_audio_set_purpose		(DvdAudio	*audio,
				 DvdAudioPurpose purpose)
{
	g_assert (audio != NULL);
	
	audio->purpose = purpose;
}

DvdAudioPurpose
dvd_audio_get_purpose		(DvdAudio	*audio)
{
	g_assert (audio != NULL);
	
	return audio->purpose;
}

void
dvd_audio_set_application	(DvdAudio	     *audio,
				 DvdAudioApplication  application)
{
	g_assert (audio != NULL);
	
	audio->application = application;
}

DvdAudioApplication
dvd_audio_get_application	(DvdAudio	     *audio)
{
	g_assert (audio != NULL);
	
	return audio->application;
}

void
dvd_audio_set_samplerate	(DvdAudio	*audio,
				 DvdAudioSamp	 samplerate)
{
	g_assert (audio != NULL);
	
	audio->samplerate = samplerate;
}

DvdAudioSamp
dvd_audio_get_samplerate	(DvdAudio	*audio)
{
	g_assert (audio != NULL);
	
	return audio->samplerate;
}

void
dvd_audio_set_quant		(DvdAudio	*audio,
				 DvdAudioQuant	 quant)
{
	g_assert (audio != NULL);
	
	audio->quant = quant;
}

DvdAudioQuant
dvd_audio_get_quant		(DvdAudio	*audio)
{
	g_assert (audio != NULL);
	
	return audio->quant;
}

