/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Written (W) 1999-2007 Soeren Sonnenburg
 * Written (W) 1999-2007 Gunnar Raetsch
 * Written (W) 2006-2007 Mikio L. Braun
 * Copyright (C) 1999-2007 Fraunhofer Institute FIRST and Max-Planck-Society
 */

#ifndef _LAPACK_H__
#define _LAPACK_H__

#include "lib/config.h"
#include "lib/common.h"

#ifdef HAVE_LAPACK

#ifdef DARWIN
#include <cblas.h>
int clapack_dpotrf(const enum CBLAS_ORDER Order, const enum CBLAS_UPLO Uplo,
			                   const int N, double *A, const int lda);
#endif //DARWIN

extern "C" {
int dsyev_(char*, char*, int*, double*, int*, double*, double*, int*, int*);
int dpotrf_(char* uplo, int* n, double* a, int* lda, int* info);
int dgesvd_(char* jobu, char* jobvt, int* m, int* n, double* a, int* lda, double* s, double* u, int* ldu, double* vt, int* ldvt, double* work, int* lwork, int* info);
int dtrmv_(char* uplo, char* trans, char* diag, int* n, double* a, int* lda, double* x, int* incx );
}

/*
 * Wrapper files for LAPACK
 *
 * automatically generated by fortranwrapper
 * hacked together by Mikio L. Braun on December 29, 2006
 */


#define FCHAR char *
#define FINT int *
#define FDOUBLE double *
#define FREAL float *

typedef struct { float r; float i; } lw_complex_t;
typedef struct { double r; double i; } lw_double_complex_t;

#define FCOMPLEX lw_complex_t *
#define FDOUBLECOMPLEX lw_double_complex_t *

typedef int lw_logical_t;

#define FLOGICAL lw_logical_t *

extern "C" { 
  
void dsymv_(FCHAR UPLO, FINT N, FDOUBLE ALPHA, FDOUBLE A, FINT LDA, FDOUBLE X, FINT INCX, FDOUBLE BETA, FDOUBLE Y, FINT INCY); 
void dgemv_(FCHAR TRANS, FINT M, FINT N, FDOUBLE ALPHA, FDOUBLE A, FINT LDA, FDOUBLE X, FINT INCX, FDOUBLE BETA, FDOUBLE Y, FINT INCY); 
int dposv_(FCHAR UPLO, FINT N, FINT NRHS, FDOUBLE A, FINT LDA, FDOUBLE B, FINT LDB, FINT INFO); 

}

void dsymv(char UPLO, int N, double ALPHA, double* A, int LDA, double* X, int INCX, double BETA, double* Y, int INCY);
void dgemv(char TRANS, int M, int N, double ALPHA, double* A, int LDA, double* X, int INCX, double BETA, double* Y, int INCY);
int dposv(char UPLO, int N, int NRHS, double* A, int LDA, double* B, int LDB);

/* end of automatically generated wrappers */


#endif //HAVE_LAPACK
#endif //_LAPACK_H__
