#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of the Shiboken Python Bindings Generator project.
#
# Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# Contact: PySide team <contact@pyside.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation. Please
# review the following information to ensure the GNU Lesser General
# Public License version 2.1 requirements will be met:
# http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
# #
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

'''Test cases for implicit conversion generated by conversion operator.'''

import unittest

from sample import Time, StrList

class ConversionOperatorTest(unittest.TestCase):
    '''Test cases for implicit conversion generated by conversion operator.'''

    def testConversionOperator(self):
        '''Time defined an conversion operator for Str, so passing a Time object to a method expecting a Str should work.'''
        t = Time(1, 2, 3)
        t_str = t.toString()
        sl = StrList()

        # StrList.append expects a Str object.
        sl.append(t)

        self.assertEqual(len(sl), 1)
        self.assertEqual(sl[0], t_str)

if __name__ == '__main__':
    unittest.main()

