/***************************************************************************
                          mutex_lock_win32.h  -  description
                             -------------------
    begin                : Sun Mar 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MUTEX_LOCK_WIN32_H
#define MUTEX_LOCK_WIN32_H

#ifdef WIN32_ENABLED

#include "mutex_lock.h"
#include <windows.h>


/**
  *@author Juan Linietsky
  */

/******************************
 mutex_lock_win32.h
 ------------------------

win32 version of mutex locking
********************************/

class Mutex_Lock_Win32 : public Mutex_Lock  {

	CRITICAL_SECTION internal_mutex;

public:

	void grab() {

		EnterCriticalSection(&internal_mutex);
	};

	void release() {

		LeaveCriticalSection(&internal_mutex);
	};

	Mutex_Lock* create_mutex_type() {

		Mutex_Lock* mutex_new = new Mutex_Lock_Win32;
		return mutex_new;
	}

	Mutex_Lock_Win32() {

		InitializeCriticalSection(&internal_mutex);
	}

	~Mutex_Lock_Win32() {

	DeleteCriticalSection(&internal_mutex);
}

};

#endif /* win32 enabled */
#endif