// I18N constants -- Japanese SHIFT JIS

// LANG: "ja-sjis", ENCODING: SHIFT_JIS
// Author: Mihai Bazon, http://dynarch.com/mishoo
// Translator:  
//   Manabu Onoue <tmocsys@tmocsys.com>, 2004.
//   Tadashi Jokagi <elf2000@users.sourceforge.net>, 2005.

HTMLArea.I18N = {

	// the following should be the filename without .js extension
	// it will be used for automatically load plugin language.
	lang: "ja-sjis",

	tooltips: {
		bold:           "",
		italic:         "Α",
		underline:      "",
		strikethrough:  "ł",
		subscript:      "tY",
		superscript:    "tY",
		justifyleft:    "",
		justifycenter:  "",
		justifyright:   "E",
		justifyfull:    "ϓt",
		orderedlist:    "ԍtӏ",
		unorderedlist:  "Ltӏ",
		outdent:        "Cfg",
		indent:         "Cfgݒ",
		forecolor:      "F",
		hilitecolor:      "wiF",
		horizontalrule: "",
		createlink:     "N쐬",
		insertimage:    "摜}",
		inserttable:    "e[u}",
		htmlmode:       "HTML\ؑ",
		popupeditor:    "GfB^g",
		about:          "o[W",
		showhelp:       "Help using editor",
		textindicator:  "݂̃X^C",
		undo:           "Ō̑",
		redo:           "Ō̓蒼",
		cut:            "I؂",
		copy:           "IRs[",
		paste:          "Nbv{[h\t",
		lefttoright:    "E̕",
		righttoleft:    "E獶̕",
		removeformat:   "菜",
		print:          "hLg",
		killword:       "MSOffice ^O菜"
	},

	buttons: {
		"ok":           "OK",
		"cancel":       ""
	},

	msg: {
		"Path":         "pX",
		"TEXT_MODE":    "eLXg[hłB[<>] {^g WYSIWYG ɖ߂܂B",

		"IE-sucks-full-screen" :
		// translate here
		"The full screen mode is known to cause problems with Internet Explorer, " +
		"due to browser bugs that we weren't able to workaround.  You might experience garbage " +
		"display, lack of editor functions and/or random browser crashes.  If your system is Windows 9x " +
		"it's very likely that you'll get a 'General Protection Fault' and need to reboot.\n\n" +
		"You have been warned.  Please press OK if you still want to try the full screen editor.",

		"Moz-Clipboard" :
		"Unprivileged scripts cannot access Cut/Copy/Paste programatically " +
		"for security reasons.  Click OK to see a technical note at mozilla.org " +
		"which shows you how to allow a script to access the clipboard."
	},

	dialogs: {
		// Common
		"OK"                                                : "OK",
		"Cancel"                                            : "",

		"Alignment:"                                        : "ʒu킹:",
		"Not set"                                           : "ݒ肵Ȃ",
		"Left"                                              : "",
		"Right"                                             : "E",
		"Texttop"                                           : "Texttop",
		"Absmiddle"                                         : "Absmiddle",
		"Baseline"                                          : "x[XC",
		"Absbottom"                                         : "Absbottom",
		"Bottom"                                            : "",
		"Middle"                                            : "",
		"Top"                                               : "",

		"Layout"                                            : "CAEg",
		"Spacing"                                           : "Ԋu",
		"Horizontal:"                                       : ":",
		"Horizontal padding"                                : "̌",
		"Vertical:"                                         : ":",
		"Vertical padding"                                  : "̌",
		"Border thickness:"                                 : "Ȇ:",
		"Leave empty for no border"                         : "EȂɂ͋ɂ܂",

		// Insert Link
		"Insert/Modify Link"                                : "Insert/Modify Link",
		"None (use implicit)"                               : "Ȃ (use implicit)",
		"New window (_blank)"                               : "VKEBhE (_blank)",
		"Same frame (_self)"                                : "t[ (_self)",
		"Top frame (_top)"                                  : "̃t[ (_top)",
		"Other"                                             : "̑",
		"Target:"                                           : "Ώ:",
		"Title (tooltip):"                                  : "薼 (c[`bv):",
		"URL:"                                              : "URL:",
		"You must enter the URL where this link points to"  : "You must enter the URL where this link points to",
		// Insert Table
		"Insert Table"                                      : "e[ȗ}",
		"Rows:"                                             : "s:",
		"Number of rows"                                    : "s",
		"Cols:"                                             : ":",
		"Number of columns"                                 : "",
		"Width:"                                            : ":",
		"Width of the table"                                : "e[u̕",
		"Percent"                                           : "p[Zg",
		"Pixels"                                            : "sNZ",
		"Em"                                                : "Em",
		"Width unit"                                        : "̒P",
		"Positioning of this table"                         : "̃e[üʒu",
		"Cell spacing:"                                     : "Z̊Ԋu:",
		"Space between adjacent cells"                      : "אڂZ̊Ԋu",
		"Cell padding:"                                     : "Ž:",
		"Space between content and border in cell"          : "Z̋EƓe̊Ԋu",
		// Insert Image
		"Insert Image"                                      : "摜̑}",
		"Image URL:"                                        : "摜 URL:",
		"Enter the image URL here"                          : "ɉ摜 URL ",
		"Preview"                                           : "vr[",
		"Preview the image in a new window"                 : "VKEBhEŉ摜vr[",
		"Alternate text:"                                   : "peLXg:",
		"For browsers that don't support images"            : "摜T|[gȂuEU[̂߂",
		"Positioning of this image"                         : "̉摜̈ʒu",
		"Image Preview:"                                    : "摜̃vr[:"
	}
};
