// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_REFINEMENT_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_REFINEMENT_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Alignment

template <typename TStringSet, typename TCargo , typename TSpec > struct Alignment;       	// "projects/library/seqan/refinement/graph_impl_align.h"(102)

//____________________________________________________________________________
// Annotation

template <typename TSequence, typename TValue, typename TSpec > class Annotation;       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(45)

//____________________________________________________________________________
// CgVizFormat_

struct CgVizFormat_;       	// "projects/library/seqan/refinement/graph_impl_align.h"(92)

//____________________________________________________________________________
// FastaFormat_

struct FastaFormat_;       	// "projects/library/seqan/refinement/graph_impl_align.h"(81)

//____________________________________________________________________________
// FragmentInfo

template <typename TId , typename TSize > class FragmentInfo;       	// "projects/library/seqan/refinement/graph_impl_align.h"(154)

//____________________________________________________________________________
// MsfFormat_

struct MsfFormat_;       	// "projects/library/seqan/refinement/graph_impl_align.h"(70)

//____________________________________________________________________________
// StringSetType

template <typename T> struct StringSetType;       	// "projects/library/seqan/refinement/graph_impl_align.h"(1158)

//____________________________________________________________________________
// TagExactRefinement_

struct TagExactRefinement_;       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(42)
struct TagExactRefinement_;       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(42)

//____________________________________________________________________________
// TagInexactRefinement_

struct TagInexactRefinement_;       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(43)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// CgVizFormat

typedef Tag<CgVizFormat_> const CgVizFormat;       	// "projects/library/seqan/refinement/graph_impl_align.h"(93)

//____________________________________________________________________________
// ExactRefinement

typedef Tag<TagExactRefinement_> const ExactRefinement;       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(43)
typedef Tag<TagExactRefinement_> const ExactRefinement;       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(43)

//____________________________________________________________________________
// FastaFormat

typedef Tag<FastaFormat_> const FastaFormat;       	// "projects/library/seqan/refinement/graph_impl_align.h"(82)

//____________________________________________________________________________
// InexactRefinement

typedef Tag<TagInexactRefinement_> const InexactRefinement;       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(44)

//____________________________________________________________________________
// MsfFormat

typedef Tag<MsfFormat_> const MsfFormat;       	// "projects/library/seqan/refinement/graph_impl_align.h"(71)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _addAnnotationCuts

template <typename TValue, typename TAliString, typename TGraph, typename TPropertyMap, typename TStringSet, typename TMap, typename TTagSpec> inline void _addAnnotationCuts(String<std::set<TValue> > &, TAliString &, String<TGraph> &, String<TPropertyMap> &, TStringSet &, TMap &, bool, TValue, Tag<TTagSpec>);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(145)
template <typename TValue, typename TAliString, typename TGraph, typename TPropertyMap, typename TStringSet, typename TMap, typename TAnnoString, typename TTagSpec> inline void _addAnnotationCuts(String<std::set<TValue> > & all_nodes, TAliString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, TStringSet & seq, TMap & seq_map, TAnnoString & annotation, TValue min_fragment_len, Tag<TTagSpec> tag);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(165)

//____________________________________________________________________________
// _addNodeAnnotation

template <typename TPropertyMap, typename TStringSet, typename TMap, typename TAnnoString, typename TAliGraph,typename TTagSpec> inline void _addNodeAnnotation(TStringSet &, TMap &, TAnnoString & annotation, TPropertyMap & pm, TAliGraph & ali_g, Tag<TTagSpec>);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(212)

//____________________________________________________________________________
// _buildIntervalsForAllSequences

template <typename TInterval, typename TStringSet, typename TAlignmentString, typename TSeqMap> void _buildIntervalsForAllSequences(TAlignmentString & alis, String<String<TInterval> > & intervals, TStringSet & seqs, TSeqMap & seq_map);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(153)
template <typename TInterval, typename TStringSet, typename TAlignmentString, typename TSeqMap> void _buildIntervalsForAllSequences(TAlignmentString & alis, String<String<TInterval> > & intervals, TStringSet & seqs, TSeqMap & seq_map);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(168)

//____________________________________________________________________________
// _copyGraph

template <typename TStringSet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest, bool);       	// "projects/library/seqan/refinement/graph_impl_align.h"(317)
template <typename TStringSet, typename TCargo, typename TSpec> inline void _copyGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/refinement/graph_impl_align.h"(332)

//____________________________________________________________________________
// _createEdgeAttributes

template <typename TStringSet, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Alignment<TStringSet, void, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(329)
template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeAttributes> inline void _createEdgeAttributes(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeAttributes& edgeMap);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(340)

//____________________________________________________________________________
// _createNodeAttributes

template <typename TStringSet, typename TCargo, typename TSpec, typename TNodeAttributes> inline void _createNodeAttributes(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNodeAttributes& nodeMap);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(300)

//____________________________________________________________________________
// _createTreesForAllSequences

template <typename TGraph, typename TPropertyMap, typename TAlignmentString, typename TSequence, typename TSetSpec, typename TValue, typename TSeqMap> void _createTreesForAllSequences(String<TGraph> & gs, String<TPropertyMap> & pms, TAlignmentString & alis, StringSet<TSequence,TSetSpec> & seqs, TSeqMap & seq_map, TValue numSequences);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(194)
template <typename TGraph, typename TPropertyMap, typename TAlignmentString, typename TSequence, typename TSetSpec, typename TValue, typename TSeqMap> void _createTreesForAllSequences(String<TGraph> & gs, String<TPropertyMap> & pms, TAlignmentString & alis, StringSet<TSequence,TSetSpec> & seqs, TSeqMap & seq_map, TValue numSequences);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(210)

//____________________________________________________________________________
// _cutIsValid

template <typename TValue> inline bool _cutIsValid(String<std::set<TValue> > & all_nodes, TValue seq_i_pos, TValue pos_i, typename std::set<TValue>::iterator iter, TValue min_len, Tag<TagInexactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(56)
template <typename TValue> inline bool _cutIsValid(String<std::set<TValue> > & all_nodes, TValue seq_i_pos, TValue, typename std::set<TValue>::iterator iter, TValue, Tag<TagExactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(54)
template <typename TValue> inline bool _cutIsValid(String<std::set<TValue> > & all_nodes, TValue seq_i_pos, TValue, typename std::set<TValue>::iterator iter, TValue, Tag<TagExactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(54)

//____________________________________________________________________________
// _getClosestRefinedNeighbor

template <typename TAliGraph, typename TVertexDescriptor,typename TValue> TValue _getClosestRefinedNeighbor(TAliGraph & ali_g, TVertexDescriptor & vd, TValue , TValue pos);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(89)

//____________________________________________________________________________
// _getCutBeginPos

template <typename TAliGraph,typename TValue> void _getCutBeginPos(TAliGraph & ali_g, typename VertexDescriptor<TAliGraph>::Type & act_knot, TValue seq, TValue act_pos, TValue & cut_act_pos);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(128)

//____________________________________________________________________________
// _getCutEndPos

template <typename TAliGraph,typename TValue> void _getCutEndPos(TAliGraph & ali_g, typename VertexDescriptor<TAliGraph>::Type & end_knot, TValue seq, TValue end_pos, TValue & cut_end_pos);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(106)

//____________________________________________________________________________
// _getEdgeIdManager

template <typename TStringSet, typename TCargo, typename TSpec> inline typename EdgeIdHandler<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& _getEdgeIdManager(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(303)

//____________________________________________________________________________
// _getOtherSequenceAndProject

template <typename TFragSize, typename TFragSpec,typename TValue, typename TMap> void _getOtherSequenceAndProject(Fragment<TFragSize,TFragSpec> & segment, TValue seg_num, TMap &, TValue seq_i_id, TValue pos_i, TValue & seq_j_id, TValue & pos_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_fragment.h"(56)
template <typename TSource,typename TSpec,typename TValue,typename TMap> void _getOtherSequenceAndProject(Align<TSource,TSpec> & segment, TValue seg_num, TMap & seq_map, TValue , TValue node_i, TValue & seq_j_id, TValue & node_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_align.h"(54)
template <typename TAlignment,typename TValue, typename TMap> void _getOtherSequenceAndProject(Graph<TAlignment> & segment, TValue seg_num, TMap &, TValue seq_i_id, TValue pos_i, TValue & seq_j_id, TValue & pos_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_aligngraph.h"(56)

//____________________________________________________________________________
// _getRefinedAnnoScore

template <typename TAliGraph,typename TScore, typename TPropertyMap> typename Value<TScore>::Type _getRefinedAnnoScore(TAliGraph &, TPropertyMap & pm, typename VertexDescriptor<TAliGraph>::Type vd1, typename VertexDescriptor<TAliGraph>::Type vd2, TScore &);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(264)
template <typename TAliGraph,typename TScore> typename Value<TScore>::Type _getRefinedAnnoScore(TAliGraph &, bool, typename VertexDescriptor<TAliGraph>::Type, typename VertexDescriptor<TAliGraph>::Type, TScore &);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(296)

//____________________________________________________________________________
// _getRefinedMatchScore

template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TFragment,typename TFragPos,typename TFragSize> TScoreValue _getRefinedMatchScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet & seqs, TFragment& segment, TFragPos pos_i, TFragPos pos_j, TFragSize len, TFragSize);       	// "projects/library/seqan/refinement/graph_algorithm_refine_fragment.h"(170)
template <typename TScoreValue,typename TStringSet,typename TFragPos,typename TFragSize, typename TSpec> TScoreValue _getRefinedMatchScore(Score<TScoreValue, Simple> & score_type, TStringSet &, Fragment<TFragSize,ExactFragment<TSpec> > &, TFragPos, TFragPos, TFragSize len, TFragSize);       	// "projects/library/seqan/refinement/graph_algorithm_refine_fragment.h"(201)
template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TAliSource,typename TAliSpec,typename TValue> TScoreValue _getRefinedMatchScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet &, Align<TAliSource,TAliSpec> & segment, TValue pos_i, TValue pos_j, TValue len, TValue);       	// "projects/library/seqan/refinement/graph_algorithm_refine_align.h"(116)
template <typename TScoreValue,typename TStringSet,typename TAlign,typename TValue, typename TSize> TScoreValue _getRefinedMatchScore(TScoreValue &, TStringSet &, TAlign &, TValue, TValue, TSize, TSize);       	// "projects/library/seqan/refinement/graph_algorithm_refine_scoring.h"(54)
template <typename TScoreValue,typename TScoreSpec,typename TStringSet,typename TAlignment,typename TValue> TScoreValue _getRefinedMatchScore(Score<TScoreValue,TScoreSpec> & score_type, TStringSet & seqs, Graph<TAlignment> & segment, TValue pos_i, TValue pos_j, TValue len, TValue len_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_aligngraph.h"(189)

//____________________________________________________________________________
// _getSeqBeginAndEnd

template <typename TFragSize, typename TFragSpec, typename TValue> void _getSeqBeginAndEnd(Fragment<TFragSize,TFragSpec> & segment, std::map<const void * ,int> &, TValue & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/refinement/graph_algorithm_refine_fragment.h"(78)
template <typename TAliSource,typename TAliSpec, typename TValue> void _getSeqBeginAndEnd(Align<TAliSource,TAliSpec> & segment, std::map<const void * ,int> & seq_map, TValue & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/refinement/graph_algorithm_refine_align.h"(92)
template <typename TValue,typename TAlign,typename TId> void _getSeqBeginAndEnd(Graph<TAlign> & segment, std::map<const void * ,int> &, TId & seq_i_id, TValue & begin_i, TValue & end_i, TValue seq);       	// "projects/library/seqan/refinement/graph_algorithm_refine_aligngraph.h"(75)

//____________________________________________________________________________
// _getVertexIdManager

template <typename TStringSet, typename TCargo, typename TSpec> inline typename VertexIdHandler<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& _getVertexIdManager(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(292)

//____________________________________________________________________________
// _getVertexString

template <typename TStringSet, typename TCargo, typename TSpec> inline String<typename EdgeType<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type*>& _getVertexString(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(281)

//____________________________________________________________________________
// _heaviestCommonSubsequence

template <typename TStringSet, typename TCargo, typename TSpec, typename TSize2, typename TSpec2, typename TPositions, typename TSize, typename TVertexDescriptor, typename TString> inline void _heaviestCommonSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const&, String<TSize2, TSpec2> const& , TPositions const&, TSize const, TSize const, TVertexDescriptor const, TString const&, TString const&, Nothing&);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1815)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSize2, typename TSpec2, typename TPositions, typename TSize, typename TString, typename TOutString> inline void _heaviestCommonSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, String<TSize2, TSpec2> const& slotToPos, TPositions const& positions, TSize const m, TSize const n, TString const& str1, TString const& str2, TOutString& align);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1831)

//____________________________________________________________________________
// _makeAlignmentGraphFromRefinedSegments

template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TAliGraph,typename TSeqMap,typename TTagSpec> void _makeAlignmentGraphFromRefinedSegments(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, TAliGraph & ali_g, Tag<TTagSpec> const tag, bool);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(365)
template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TAliGraph,typename TSeqMap,typename TAnnoString,typename TTagSpec> void _makeAlignmentGraphFromRefinedSegments(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, TAliGraph & ali_g, Tag<TTagSpec> const tag, TAnnoString & annotation);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(397)
template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TAliGraph,typename TSeqMap,typename TTagSpec> void _makeAlignmentGraphFromRefinedSegments(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, TAliGraph & ali_g, Tag<TTagSpec> const tag, bool);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(381)
template <typename TValue,typename TAlignmentString,typename TScore,typename TSequence, typename TSetSpec,typename TAliGraph,typename TSeqMap,typename TAnnoString,typename TTagSpec> void _makeAlignmentGraphFromRefinedSegments(String<std::set<TValue> > & all_nodes, TAlignmentString & alis, TScore & score_type, StringSet<TSequence, TSetSpec> & seqs, TSeqMap & seq_map, TAliGraph & ali_g, Tag<TTagSpec> const tag, TAnnoString & annotation);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(413)

//____________________________________________________________________________
// _makeRefinedGraphEdges

template <typename TAlignmentString,typename TPropertyMap,typename TStringSet,typename TSeqMap, typename TScore,typename TAliGraph> void _makeRefinedGraphEdges(TAlignmentString & alis, TPropertyMap & , TStringSet & seqs, TSeqMap & seq_map, TScore & score_type, TAliGraph & ali_g, Tag<TagInexactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(155)
template <typename TAlignmentString,typename TStringSet,typename TSeqMap, typename TPropertyMap,typename TScore,typename TAliGraph> void _makeRefinedGraphEdges(TAlignmentString & alis, TPropertyMap & pm, TStringSet & seqs, TSeqMap & seq_map, TScore & score_type, TAliGraph & ali_g, Tag<TagExactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(288)
template <typename TAlignmentString,typename TStringSet,typename TSeqMap, typename TPropertyMap,typename TScore,typename TAliGraph> void _makeRefinedGraphEdges(TAlignmentString & alis, TPropertyMap & pm, TStringSet & seqs, TSeqMap & seq_map, TScore & score_type, TAliGraph & ali_g, Tag<TagExactRefinement_> const);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(304)

//____________________________________________________________________________
// _makeRefinedGraphNodes

template <typename TStringSet,typename TValue,typename TAliGraph> void _makeRefinedGraphNodes(String<std::set<TValue> > & all_nodes, TStringSet & seqs, TAliGraph & ali_g);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(243)
template <typename TStringSet,typename TValue,typename TAliGraph> void _makeRefinedGraphNodes(String<std::set<TValue> > & all_nodes, TStringSet & seqs, TAliGraph & ali_g);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(259)

//____________________________________________________________________________
// _refine

template <typename TValue, typename TAlignmentString, typename TStringSet,typename TGraph, typename TPropertyMap,typename TSeqMap, typename TTagSpec> inline void _refine(TValue node_i, TValue seq_i_id, TStringSet & seqs, TSeqMap & seq_map, TAlignmentString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, String<std::set<TValue> > & all_nodes, TValue min_len, Tag<TTagSpec> tag);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(101)
template <typename TValue, typename TAlignmentString, typename TStringSet,typename TGraph, typename TPropertyMap,typename TSeqMap, typename TTagSpec> inline void _refine(TValue node_i, TValue seq_i_id, TStringSet & seqs, TSeqMap & seq_map, TAlignmentString & alis, String<TGraph> & gs, String<TPropertyMap> & pms, String<std::set<TValue> > & all_nodes, TValue min_len, Tag<TTagSpec> tag);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(101)

//____________________________________________________________________________
// _updateCutPosition

template <typename TSize, typename TSpec,typename TPos> inline void _updateCutPosition(Fragment<TSize, ExactReversableFragment<TSpec> > & f, TPos & pos_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(66)
template <typename TFrag,typename TPos> inline void _updateCutPosition(TFrag &, TPos &);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(82)
template <typename TSize, typename TSpec,typename TPos> inline void _updateCutPosition(Fragment<TSize, ExactReversableFragment<TSpec> > & f, TPos & pos_j);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(66)
template <typename TFrag,typename TPos> inline void _updateCutPosition(TFrag &, TPos &);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(82)

//____________________________________________________________________________
// _writeCargo

template <typename TFile, typename TStringSet, typename TSpec, typename TEdge> inline void _writeCargo(TFile & file, Graph<Alignment<TStringSet, void, TSpec> > const&, TEdge const&);       	// "projects/library/seqan/refinement/graph_impl_align.h"(937)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TEdge> inline void _writeCargo(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, TEdge const& edge);       	// "projects/library/seqan/refinement/graph_impl_align.h"(947)

//____________________________________________________________________________
// _writeEdgeType

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeEdgeType(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(418)

//____________________________________________________________________________
// _writeGraphFooter

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeGraphFooter(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, DotDrawing);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(364)

//____________________________________________________________________________
// _writeGraphType

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec> inline void _writeGraphType(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const&, DotDrawing);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(406)

//____________________________________________________________________________
// addEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/refinement/graph_impl_align.h"(592)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor, typename TCargo2> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target, TCargo2 const cargo);       	// "projects/library/seqan/refinement/graph_impl_align.h"(605)

//____________________________________________________________________________
// addVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TId, typename TPos, typename TLength> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type addVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TId id, TPos begin, TLength len);       	// "projects/library/seqan/refinement/graph_impl_align.h"(483)

//____________________________________________________________________________
// assignStringSet

template <typename TString, typename TDefault, typename TCargo, typename TSpec, typename TDefault2> inline void assignStringSet(Graph<Alignment<StringSet<TString, Dependent<TDefault> >, TCargo, TSpec> >& g, StringSet<TString, Dependent<TDefault2> > const& sStr);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1091)
template <typename TString, typename TDefault, typename TCargo, typename TSpec, typename TDefault2> inline void assignStringSet(Graph<Alignment<StringSet<TString, Dependent<TDefault> >, TCargo, TSpec> >& g, StringSet<TString, Owner<TDefault2> > const& sStr);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1112)

//____________________________________________________________________________
// atBegin

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atBegin(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(151)

//____________________________________________________________________________
// atEnd

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool atEnd(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(171)

//____________________________________________________________________________
// clear

template <typename TStringSet, typename TCargo, typename TSpec> inline void clear(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(435)

//____________________________________________________________________________
// clearEdges

template <typename TStringSet, typename TCargo, typename TSpec> inline void clearEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(399)

//____________________________________________________________________________
// clearVertices

template <typename TStringSet, typename TCargo, typename TSpec> inline void clearVertices(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(409)

//____________________________________________________________________________
// convertAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TComponentMap, typename TOrderMap, typename TComponentLength> inline bool convertAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TComponentMap& component, TOrderMap& order, TComponentLength& compLength);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1498)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline bool convertAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1610)
template <typename TValue, typename TSpec1, typename TStringSet, typename TCargo, typename TSpec2> inline bool convertAlignment(String<TValue, TSpec1> const& mat, Graph<Alignment<TStringSet, TCargo, TSpec2> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1678)

//____________________________________________________________________________
// degree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type degree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/refinement/graph_impl_align.h"(470)

//____________________________________________________________________________
// empty

template <typename TStringSet, typename TCargo, typename TSpec> inline bool empty(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(389)

//____________________________________________________________________________
// findEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename EdgeDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type findEdge(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v, TVertexDescriptor const w);       	// "projects/library/seqan/refinement/graph_impl_align.h"(695)

//____________________________________________________________________________
// findVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId, typename TPos> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type findVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId id, TPos pos);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1297)

//____________________________________________________________________________
// fragmentBegin

template <typename TSequence,typename TValue,typename TSpec> typename Position<TSequence>::Type& fragmentBegin(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(105)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& fragmentBegin(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1250)

//____________________________________________________________________________
// fragmentLength

template <typename TSequence,typename TValue,typename TSpec> typename Size<TSequence>::Type& fragmentLength(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(113)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& fragmentLength(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1273)

//____________________________________________________________________________
// getAdjacencyMatrix

template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getAdjacencyMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TMatrix& mat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(683)

//____________________________________________________________________________
// getFirstCoveredPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type getFirstCoveredPosition(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSeqId const id);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1419)

//____________________________________________________________________________
// getLastCoveredPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId> inline typename Position<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type getLastCoveredPosition(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId id);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1463)

//____________________________________________________________________________
// getProjectedPosition

template <typename TStringSet, typename TCargo, typename TSpec, typename TSeqId, typename TPosition, typename TSeqId2, typename TPosition2> inline void getProjectedPosition(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TSeqId const id1, TPosition const pos1, TSeqId2& id2, TPosition2& pos2);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1317)
template <typename TStringSet, typename TValue, typename TCargo, typename TSpec, typename TSeqId, typename TPosition, typename TSeqId2, typename TPosition2> inline void getProjectedPosition(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TValue seg_num, TSeqId const id1, TPosition const pos1, TSeqId2& id2, TPosition2& pos2);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1364)

//____________________________________________________________________________
// getStringSet

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Host<Graph<Alignment<TStringSet, TCargo, TSpec> > const>::Type& getStringSet(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1136)

//____________________________________________________________________________
// getValue

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename GetValue<Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type getValue(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(131)

//____________________________________________________________________________
// goBegin

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goBegin(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(161)

//____________________________________________________________________________
// goEnd

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goEnd(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(182)

//____________________________________________________________________________
// goNext

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(192)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goNext(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(273)

//____________________________________________________________________________
// goPrevious

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline void goPrevious(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(206)

//____________________________________________________________________________
// heaviestCommonSubsequence

template <typename TStringSet, typename TCargo, typename TSpec, typename TString, typename TOutString> inline TCargo heaviestCommonSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2, TOutString& align);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1948)
template <typename TStringSet, typename TCargo, typename TSpec, typename TString> inline TCargo heaviestCommonSubsequence(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2);       	// "projects/library/seqan/refinement/graph_impl_align.h"(2071)

//____________________________________________________________________________
// inDegree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type inDegree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/refinement/graph_impl_align.h"(459)

//____________________________________________________________________________
// label

template <typename TSequence,typename TValue,typename TSpec> TValue label(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(121)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Infix<typename Value<TStringSet>::Type>::Type label(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1193)

//____________________________________________________________________________
// matchRefinement

template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(266)
template <typename TAlignmentString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/refinement/graph_algorithm_refine_inexact.h"(288)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TAnnoString,typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(320)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TAnnoString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(341)
template <typename TAlignmentString, typename TOutGraph, typename TAnnoString, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph, unsigned int min_frag_len);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(364)
template <typename TAlignmentString,typename TAnnoString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, TAnnoString & anno, StringSet<TSequence, TSetSpec> & seq, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(388)
template <typename TAlignmentString, typename TAnnotation, typename TOutGraph, typename TSequence, typename TSetSpec, typename TScore,typename TTagSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TScore & score_type, TOutGraph & ali_graph, typename Size<typename Value<TAlignmentString>::Type>::Type min_fragment_len, TAnnotation & annotation, Tag<TTagSpec> const tag);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(440)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(544)
template <typename TFragmentString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TFragmentString & matches, StringSet<TSequence, TSetSpec> & strSet, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact.h"(558)
template <typename TAlignmentString, typename TAnnotation, typename TOutGraph, typename TSequence, typename TSetSpec, typename TScore,typename TTagSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, TScore & score_type, TOutGraph & ali_graph, typename Size<typename Value<TAlignmentString>::Type>::Type min_fragment_len, TAnnotation & annotation, Tag<TTagSpec> const tag);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(456)
template <typename TAlignmentString, typename TScoreValue,typename TScoreSpec,typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TAlignmentString & alis, StringSet<TSequence, TSetSpec> & seq, Score<TScoreValue,TScoreSpec> & score_type, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(629)
template <typename TFragmentString, typename TOutGraph, typename TSequence, typename TSetSpec> void matchRefinement(TFragmentString & matches, StringSet<TSequence, TSetSpec> & strSet, TOutGraph & ali_graph);       	// "projects/library/seqan/refinement/graph_algorithm_refine_exact_iterative.h"(657)

//____________________________________________________________________________
// numEdges

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type numEdges(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(369)

//____________________________________________________________________________
// numVertices

template <typename TStringSet, typename TCargo, typename TSpec> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type numVertices(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(379)

//____________________________________________________________________________
// operator!=

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator!=(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(242)

//____________________________________________________________________________
// operator==

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline bool operator==(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it1, Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it2);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(230)

//____________________________________________________________________________
// outDegree

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Size<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type outDegree(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const vertex);       	// "projects/library/seqan/refinement/graph_impl_align.h"(448)

//____________________________________________________________________________
// rebuildGraph

template <typename TStringSet, typename TCargo, typename TSpec> inline void rebuildGraph(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1726)

//____________________________________________________________________________
// removeEdge

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const source, TVertexDescriptor const target);       	// "projects/library/seqan/refinement/graph_impl_align.h"(617)
template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline void removeEdge(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/refinement/graph_impl_align.h"(628)

//____________________________________________________________________________
// removeInEdges

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeInEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(650)

//____________________________________________________________________________
// removeOutEdges

template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline void removeOutEdges(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(639)

//____________________________________________________________________________
// removeVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TVD> inline void removeVertex(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TVD const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(553)

//____________________________________________________________________________
// sequenceId

template <typename TSequence,typename TValue,typename TSpec> typename Id<TSequence>::Type& sequenceId(Annotation<TSequence,TValue,TSpec> & me);       	// "projects/library/seqan/refinement/graph_algorithm_refine_annotation.h"(97)
template <typename TStringSet, typename TCargo, typename TSpec, typename TVertexDescriptor> inline typename Id<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type& sequenceId(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TVertexDescriptor const v);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1226)

//____________________________________________________________________________
// sourceVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type sourceVertex(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/refinement/graph_impl_align.h"(672)

//____________________________________________________________________________
// stringSet

template <typename TStringSet, typename TCargo, typename TSpec> inline typename StringSetType<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type stringSet(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g);       	// "projects/library/seqan/refinement/graph_impl_align.h"(1170)

//____________________________________________________________________________
// targetVertex

template <typename TStringSet, typename TCargo, typename TSpec, typename TEdgeDescriptor> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TSpec> > >::Type targetVertex(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TEdgeDescriptor const edge);       	// "projects/library/seqan/refinement/graph_impl_align.h"(661)
template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename VertexDescriptor<Graph<Alignment<TStringSet, TCargo, TGraphSpec> > >::Type targetVertex(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(253)

//____________________________________________________________________________
// transpose

template <typename TStringSet, typename TCargo, typename TSpec> inline void transpose(Graph<Alignment<TStringSet, TCargo, TSpec> > const& source, Graph<Alignment<TStringSet, TCargo, TSpec> >& dest);       	// "projects/library/seqan/refinement/graph_impl_align.h"(348)
template <typename TStringSet, typename TCargo, typename TSpec> inline void transpose(Graph<Alignment<TStringSet, TCargo, TSpec> >&);       	// "projects/library/seqan/refinement/graph_impl_align.h"(359)

//____________________________________________________________________________
// value

template <typename TStringSet, typename TCargo, typename TGraphSpec, typename TSpec> inline typename Reference<Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > > >::Type value(Iter<Graph<Alignment<TStringSet, TCargo, TGraphSpec> >, GraphIterator<InternalOutEdgeIterator<TSpec> > >& it);       	// "projects/library/seqan/refinement/graph_impl_align_adapt.h"(141)

//____________________________________________________________________________
// write

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TIDString> inline void write(TFile & target, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TIDString const &, Raw);       	// "projects/library/seqan/refinement/graph_impl_align.h"(708)
template <typename TFile, typename TSpec, typename TNames> inline void write(TFile & file, Graph<TSpec> const& g, TNames const& names, FastaFormat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(837)
template <typename TFile, typename TSpec, typename TNames> inline void write(TFile & file, Graph<TSpec> const& g, TNames const& names, MsfFormat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(873)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> inline void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames const& names, CgVizFormat);       	// "projects/library/seqan/refinement/graph_impl_align.h"(960)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

