// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_BLAST_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_BLAST_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BasicInfo

struct BasicInfo;       	// "projects/library/seqan/blast/blast_base.h"(48)

//____________________________________________________________________________
// BlastHit

template <typename TBlastHsp, typename TStoreSpec> class BlastHit;       	// "projects/library/seqan/blast/blast_hit.h"(41)

//____________________________________________________________________________
// BlastHsp

template <typename TBlastSpec , typename TInfoSpec > class BlastHsp;       	// "projects/library/seqan/blast/blast_hsp.h"(47)

//____________________________________________________________________________
// BlastReport

template <typename TBlastHsp , typename TStoreSpec > class BlastReport;       	// "projects/library/seqan/blast/blast_report.h"(44)

//____________________________________________________________________________
// FullInfo

struct FullInfo;       	// "projects/library/seqan/blast/blast_base.h"(45)

//____________________________________________________________________________
// Hit

template <typename T> struct Hit;       	// "projects/library/seqan/blast/blast_base.h"(108)

//____________________________________________________________________________
// HitIterator

struct HitIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(52)

//____________________________________________________________________________
// Hsp

template <typename T> struct Hsp;       	// "projects/library/seqan/blast/blast_base.h"(121)

//____________________________________________________________________________
// HspIterator

struct HspIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(55)

//____________________________________________________________________________
// NucleotideBlast

template <typename TSpec > class NucleotideBlast;       	// "projects/library/seqan/blast/blast_base.h"(172)

//____________________________________________________________________________
// ProteinBlast

template <typename TSpec > class ProteinBlast;       	// "projects/library/seqan/blast/blast_base.h"(179)

//____________________________________________________________________________
// SimpleBlastIterator

template <typename TSpec> struct SimpleBlastIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(48)

//____________________________________________________________________________
// StoreReport

template <typename TInfoSpec > struct StoreReport;       	// "projects/library/seqan/blast/blast_base.h"(72)

//____________________________________________________________________________
// StreamBlastIterator

template <typename TSpec> struct StreamBlastIterator;       	// "projects/library/seqan/blast/blast_iterator.h"(63)

//____________________________________________________________________________
// StreamReport

template <typename TFile > struct StreamReport;       	// "projects/library/seqan/blast/blast_base.h"(89)

//____________________________________________________________________________
// TagBlastN_

struct TagBlastN_;       	// "projects/library/seqan/blast/blast_base.h"(164)

//____________________________________________________________________________
// TagBlastP_

struct TagBlastP_;       	// "projects/library/seqan/blast/blast_base.h"(166)

//____________________________________________________________________________
// TagBlastX_

struct TagBlastX_;       	// "projects/library/seqan/blast/blast_base.h"(167)

//____________________________________________________________________________
// TagBlast_

struct TagBlast_;       	// "projects/library/seqan/blast/blast_base.h"(127)

//____________________________________________________________________________
// TagKnownSource_

struct TagKnownSource_;       	// "projects/library/seqan/blast/blast_hsp.h"(857)

//____________________________________________________________________________
// TagMegaBlast_

struct TagMegaBlast_;       	// "projects/library/seqan/blast/blast_base.h"(165)

//____________________________________________________________________________
// TagRunBlastN_

struct TagRunBlastN_;       	// "projects/library/seqan/blast/blast_run.h"(48)

//____________________________________________________________________________
// TagRunBlastP_

struct TagRunBlastP_;       	// "projects/library/seqan/blast/blast_run.h"(59)

//____________________________________________________________________________
// TagRunBlastX_

struct TagRunBlastX_;       	// "projects/library/seqan/blast/blast_run.h"(62)

//____________________________________________________________________________
// TagRunBlat_

struct TagRunBlat_;       	// "projects/library/seqan/blast/blast_run.h"(54)

//____________________________________________________________________________
// TagRunMegaBlast_

struct TagRunMegaBlast_;       	// "projects/library/seqan/blast/blast_run.h"(51)

//____________________________________________________________________________
// TagRunTBlastN_

struct TagRunTBlastN_;       	// "projects/library/seqan/blast/blast_run.h"(65)

//____________________________________________________________________________
// TagRunTBlastX_

struct TagRunTBlastX_;       	// "projects/library/seqan/blast/blast_run.h"(68)

//____________________________________________________________________________
// TagTBlastN_

struct TagTBlastN_;       	// "projects/library/seqan/blast/blast_base.h"(168)

//____________________________________________________________________________
// TagTBlastX_

struct TagTBlastX_;       	// "projects/library/seqan/blast/blast_base.h"(169)

//____________________________________________________________________________
// TagUnknownSource_

struct TagUnknownSource_;       	// "projects/library/seqan/blast/blast_hsp.h"(854)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Blast

typedef Tag<TagBlast_> const Blast;       	// "projects/library/seqan/blast/blast_base.h"(128)

//____________________________________________________________________________
// BlastN

typedef NucleotideBlast<TagBlastN_> BlastN;       	// "projects/library/seqan/blast/blast_base.h"(185)

//____________________________________________________________________________
// BlastP

typedef ProteinBlast<TagBlastP_> BlastP;       	// "projects/library/seqan/blast/blast_base.h"(188)

//____________________________________________________________________________
// BlastX

typedef ProteinBlast<TagBlastX_> BlastX;       	// "projects/library/seqan/blast/blast_base.h"(189)

//____________________________________________________________________________
// KnownSource

typedef Tag<TagKnownSource_> const KnownSource;       	// "projects/library/seqan/blast/blast_hsp.h"(858)

//____________________________________________________________________________
// MegaBlast

typedef NucleotideBlast<TagMegaBlast_> MegaBlast;       	// "projects/library/seqan/blast/blast_base.h"(186)

//____________________________________________________________________________
// RunBlastN

typedef Tag<TagRunBlastN_> const RunBlastN;       	// "projects/library/seqan/blast/blast_run.h"(49)

//____________________________________________________________________________
// RunBlastP

typedef Tag<TagRunBlastP_> const RunBlastP;       	// "projects/library/seqan/blast/blast_run.h"(60)

//____________________________________________________________________________
// RunBlastX

typedef Tag<TagRunBlastX_> const RunBlastX;       	// "projects/library/seqan/blast/blast_run.h"(63)

//____________________________________________________________________________
// RunBlat

typedef Tag<TagRunBlat_> const RunBlat;       	// "projects/library/seqan/blast/blast_run.h"(55)

//____________________________________________________________________________
// RunMegaBlast

typedef Tag<TagRunMegaBlast_> const RunMegaBlast;       	// "projects/library/seqan/blast/blast_run.h"(52)

//____________________________________________________________________________
// RunTBlastN

typedef Tag<TagRunTBlastN_> const RunTBlastN;       	// "projects/library/seqan/blast/blast_run.h"(66)

//____________________________________________________________________________
// RunTBlastX

typedef Tag<TagRunTBlastX_> const RunTBlastX;       	// "projects/library/seqan/blast/blast_run.h"(69)

//____________________________________________________________________________
// TBlastN

typedef ProteinBlast<TagTBlastN_> TBlastN;       	// "projects/library/seqan/blast/blast_base.h"(190)

//____________________________________________________________________________
// TBlastX

typedef ProteinBlast<TagTBlastX_> TBlastX;       	// "projects/library/seqan/blast/blast_base.h"(191)

//____________________________________________________________________________
// UnknownSource

typedef Tag<TagUnknownSource_> const UnknownSource;       	// "projects/library/seqan/blast/blast_hsp.h"(855)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _getNextHitFilePos

template <typename TBlastHsp, typename TFile> inline void _getNextHitFilePos(TFile & file, Iter<BlastReport<TBlastHsp, StreamReport<TFile> >, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(424)

//____________________________________________________________________________
// _getNextHspFilePos

template <typename TBlastHsp, typename TFile> inline void _getNextHspFilePos(TFile & file, Iter<BlastHit<TBlastHsp, StreamReport<TFile> >, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(395)

//____________________________________________________________________________
// _parseBlastHit

template <typename TFile, typename TChar, typename TBlastHit> inline typename Position<TFile>::Type _parseBlastHit(TFile & file, TChar & c, TBlastHit & hit);       	// "projects/library/seqan/blast/blast_hit.h"(165)
template <typename TFile, typename TChar, typename TBlastSpec> inline typename Position<TFile>::Type _parseBlastHit(TFile & file, TChar & c, BlastHit<TBlastSpec,StreamReport<TFile> > & hit);       	// "projects/library/seqan/blast/blast_stream_hit.h"(78)

//____________________________________________________________________________
// _parseBlastHsp

template <typename TFile, typename TChar, typename TSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<NucleotideBlast<TSpec>,FullInfo > & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(184)
template <typename TFile, typename TChar, typename TSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<ProteinBlast<TSpec>,FullInfo> & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(475)
template <typename TFile, typename TChar, typename TBlastSpec, typename TInfoSpec> inline typename Position<TFile>::Type _parseBlastHsp(TFile & file, TChar & c, BlastHsp<TBlastSpec,TInfoSpec> & hsp);       	// "projects/library/seqan/blast/blast_hsp.h"(756)

//____________________________________________________________________________
// _parseReadAlignmentString

template <typename TFile, typename TChar> inline String<char> _parseReadAlignmentString(TFile & file, TChar& c);       	// "projects/library/seqan/blast/blast_parsing.h"(53)

//____________________________________________________________________________
// _parseReadQueryAndDBName

template <typename TFile, typename TChar> typename Position<TFile>::Type _parseReadQueryAndDBName(TFile & file, TChar & c, String<char> & query_name, String<char> & db_name);       	// "projects/library/seqan/blast/blast_parsing.h"(77)

//____________________________________________________________________________
// _readParameters

template <typename TFile, typename TChar, typename TBlastHsp> void _readParameters(TFile & file, TChar & c, BlastReport<TBlastHsp, StoreReport<FullInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(399)
template <typename TFile, typename TChar, typename TBlastHsp> void _readParameters(TFile & , TChar & , BlastReport<TBlastHsp, StoreReport<BasicInfo> >& );       	// "projects/library/seqan/blast/blast_report.h"(491)

//____________________________________________________________________________
// _runBlast

template <typename TString, typename TPath1, typename TPath, typename TParamString> void _runBlast(TPath1 blast_path, TPath db_path, TString db_name, TPath query_path, TString query_name, TPath out_path, TString outfile_name, Tag<TagRunBlastN_>, TParamString params);       	// "projects/library/seqan/blast/blast_run.h"(94)

//____________________________________________________________________________
// atBegin

template <typename TBlastHsp, typename TStoreSpec> inline bool atBegin(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(195)
template <typename TBlastReport, typename TFile> inline bool atBegin(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(212)
template <typename TBlastHit, typename TFile> inline bool atBegin(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(222)
template <typename TBlastObject, typename TIteratorSpec> inline bool atBegin(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(214)

//____________________________________________________________________________
// atEnd

template <typename TBlastHsp, typename TStoreSpec> inline bool atEnd(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(216)
template <typename TBlastReport, typename TFile> inline bool atEnd(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(402)
template <typename TBlastHsp, typename TSpec, typename TFile> inline bool atEnd(TFile & file, BlastReport<TBlastHsp,TSpec> & blast);       	// "projects/library/seqan/blast/blast_report.h"(1134)
template <typename TBlastHit, typename TFile> inline bool atEnd(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(373)
template <typename TBlastReport> inline bool atEnd(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(410)

//____________________________________________________________________________
// bitScore

template <typename TBlastSpec> inline float & bitScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1499)

//____________________________________________________________________________
// clear

template <typename TSpec> inline void clear(BlastHsp<NucleotideBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(349)
template <typename TSpec> inline void clear(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(648)
template <typename TBlastSpec> inline void clear(BlastHsp<TBlastSpec, BasicInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(736)
template <typename TBlastHsp, typename TSpec> inline void clear(BlastHit<TBlastHsp, StoreReport<TSpec> >& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(105)
template <typename TBlastHsp> inline void clear(BlastReport<TBlastHsp, StoreReport<FullInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(207)
template <typename TBlastHsp> inline void clear(BlastReport<TBlastHsp, StoreReport<BasicInfo> >& blastObj);       	// "projects/library/seqan/blast/blast_report.h"(379)

//____________________________________________________________________________
// databaseAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> & databaseAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1425)

//____________________________________________________________________________
// databaseBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & databaseBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1320)

//____________________________________________________________________________
// databaseEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & databaseEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1389)

//____________________________________________________________________________
// databaseFrame

template <typename TSpec> inline int & databaseFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1651)

//____________________________________________________________________________
// databaseName

template <typename TBlastHsp, typename TSpec> inline String<char> & databaseName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(776)

//____________________________________________________________________________
// databaseOrientationPlus

template <typename TBlastSpec> inline bool databaseOrientationPlus(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1623)

//____________________________________________________________________________
// eValue

template <typename TBlastSpec, typename TInfoSpec> inline double & eValue(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1442)

//____________________________________________________________________________
// eValueCutoff

template <typename TBlastHsp> inline double & eValueCutoff(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(863)

//____________________________________________________________________________
// entropy

template <typename TBlastHsp> inline float & entropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1086)

//____________________________________________________________________________
// gapExtension

template <typename TBlastHsp> inline float & gapExtension(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(934)

//____________________________________________________________________________
// gapOpen

template <typename TBlastHsp> inline float & gapOpen(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(907)

//____________________________________________________________________________
// gappedEntropy

template <typename TBlastHsp> inline float & gappedEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1103)

//____________________________________________________________________________
// gappedKappa

template <typename TBlastHsp> inline float & gappedKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1058)

//____________________________________________________________________________
// gappedLambda

template <typename TBlastHsp> inline float & gappedLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1000)

//____________________________________________________________________________
// gapsAllowed

template <typename TBlastHsp> inline bool gapsAllowed(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(963)

//____________________________________________________________________________
// getAlignment

template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali, UnknownSource);       	// "projects/library/seqan/blast/blast_hsp.h"(867)
template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali);       	// "projects/library/seqan/blast/blast_hsp.h"(977)
template <typename TBlastHsp, typename TSpec, typename TSource> inline unsigned int getAlignment(TBlastHsp & hsp, Align<TSource,TSpec> & ali, KnownSource);       	// "projects/library/seqan/blast/blast_hsp.h"(997)
template <typename TBlastHsp, typename TAlign, typename TId> inline unsigned int getAlignment(TBlastHsp & hsp, Graph<TAlign> & ali, TId id0, TId id1);       	// "projects/library/seqan/blast/blast_hsp.h"(1070)
template <typename TBlastHsp, typename TStringSet, typename TCargo, typename TSpec> inline unsigned int getAlignment(TBlastHsp & hsp, Graph<Alignment<TStringSet,TCargo,TSpec> > & ali);       	// "projects/library/seqan/blast/blast_hsp.h"(1158)

//____________________________________________________________________________
// getBitScore

template <typename TBlastSpec> inline float getBitScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1519)

//____________________________________________________________________________
// getBlastMatchScore

template <typename TBlastSpec> inline float getBlastMatchScore(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1491)

//____________________________________________________________________________
// getDatabaseAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> getDatabaseAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1433)

//____________________________________________________________________________
// getDatabaseBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getDatabaseBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1339)

//____________________________________________________________________________
// getDatabaseEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getDatabaseEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1397)

//____________________________________________________________________________
// getDatabaseFrame

template <typename TSpec> inline int getDatabaseFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1659)

//____________________________________________________________________________
// getDatabaseName

template <typename TBlastHsp, typename TSpec> inline String<char> getDatabaseName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(797)

//____________________________________________________________________________
// getEValue

template <typename TBlastSpec, typename TInfoSpec> inline double getEValue(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1461)

//____________________________________________________________________________
// getEValueCutoff

template <typename TBlastHsp> inline double getEValueCutoff(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(883)

//____________________________________________________________________________
// getEntropy

template <typename TBlastHsp> inline float getEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1094)

//____________________________________________________________________________
// getGapExtension

template <typename TBlastHsp> inline float getGapExtension(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(954)

//____________________________________________________________________________
// getGapOpen

template <typename TBlastHsp> inline float getGapOpen(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(926)

//____________________________________________________________________________
// getGappedEntropy

template <typename TBlastHsp> inline float getGappedEntropy(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1111)

//____________________________________________________________________________
// getGappedKappa

template <typename TBlastHsp> inline float getGappedKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1077)

//____________________________________________________________________________
// getGappedLambda

template <typename TBlastHsp> inline float getGappedLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1019)

//____________________________________________________________________________
// getKappa

template <typename TBlastHsp> inline float getKappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1049)

//____________________________________________________________________________
// getLambda

template <typename TBlastHsp> inline float getLambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(991)

//____________________________________________________________________________
// getLength

template <typename TBlastHsp, typename TStoreSpec> inline unsigned int getLength(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(142)

//____________________________________________________________________________
// getMatrixName

template <typename TBlastHsp> inline String<char> getMatrixName(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(899)

//____________________________________________________________________________
// getName

template <typename TBlastHsp, typename TStoreSpec> inline String<char> getName(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(126)

//____________________________________________________________________________
// getNext

template <typename TBlastHsp, typename TSpec, typename TFile> inline void getNext(TFile & file, BlastReport<TBlastHsp,TSpec> & blast);       	// "projects/library/seqan/blast/blast_report.h"(1157)

//____________________________________________________________________________
// getNumGaps

template <typename TBlastSpec> inline unsigned int getNumGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1583)

//____________________________________________________________________________
// getPercentGaps

template <typename TBlastSpec> inline unsigned int getPercentGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1554)

//____________________________________________________________________________
// getPercentIdentity

template <typename TBlastSpec> inline unsigned int getPercentIdentity(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1538)

//____________________________________________________________________________
// getPercentPositives

template <typename TSpec> inline unsigned int getPercentPositives(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1675)

//____________________________________________________________________________
// getQueryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> getQueryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1415)

//____________________________________________________________________________
// getQueryBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getQueryBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1310)

//____________________________________________________________________________
// getQueryEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int getQueryEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1368)

//____________________________________________________________________________
// getQueryFrame

template <typename TSpec> inline int getQueryFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1642)

//____________________________________________________________________________
// getQueryName

template <typename TBlastHsp, typename TSpec> inline String<char> getQueryName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(755)

//____________________________________________________________________________
// getValue

template <typename TBlastHsp, typename TStoreSpec> inline typename GetValue<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type getValue(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(146)
template <typename TBlastReport, typename TFile> inline typename GetValue<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type getValue(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(337)
template <typename TBlastHit, typename TFile> inline typename GetValue<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type getValue(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(303)
template <typename TBlastReport> inline typename GetValue<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type getValue(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(353)

//____________________________________________________________________________
// goBegin

template <typename TBlastHsp, typename TStoreSpec> inline void goBegin(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(205)
template <typename TBlastReport, typename TFile> inline void goBegin(TFile &, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(235)
template <typename TBlastHit, typename TFile> inline void goBegin(TFile &, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(235)
template <typename TBlastObject, typename TIteratorSpec> inline void goBegin(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(234)

//____________________________________________________________________________
// goEnd

template <typename TBlastHsp, typename TStoreSpec> inline void goEnd(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(226)
template <typename TBlastReport> inline void goEnd(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(428)

//____________________________________________________________________________
// goNext

template <typename TBlastHsp, typename TStoreSpec> inline void goNext(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(236)
template <typename TBlastReport, typename TFile> inline void goNext(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(263)
template <typename TBlastHit, typename TFile> inline void goNext(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(250)
template <typename TBlastObject, typename TIteratorSpec> inline void goNext(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(254)

//____________________________________________________________________________
// goPrevious

template <typename TBlastHsp, typename TStoreSpec> inline void goPrevious(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(259)
template <typename TBlastObject, typename TIteratorSpec> inline void goPrevious(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(286)

//____________________________________________________________________________
// hostHit

template <typename TBlastHit> inline typename Host<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type const& hostHit(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(361)

//____________________________________________________________________________
// hostReport

template <typename TBlastReport> inline typename Host<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type & hostReport(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(379)
template <typename TBlastReport> inline typename Host<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type & hostReport(Iter<TBlastReport, SimpleBlastIterator<HitIterator> > & it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(391)

//____________________________________________________________________________
// kappa

template <typename TBlastHsp> inline float & kappa(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(1029)

//____________________________________________________________________________
// lambda

template <typename TBlastHsp> inline float & lambda(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(972)

//____________________________________________________________________________
// length

template <typename TBlast, typename TSpec> inline unsigned int length(BlastHsp<TBlast,TSpec >& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1690)
template <typename TBlastHsp, typename TStoreSpec> inline unsigned int & length(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(134)

//____________________________________________________________________________
// matrixName

template <typename TBlastHsp> inline String<char> & matrixName(BlastReport<TBlastHsp,StoreReport<FullInfo> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(891)

//____________________________________________________________________________
// name

template <typename TBlastHsp, typename TStoreSpec> inline String<char> & name(BlastHit<TBlastHsp, TStoreSpec>& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(118)

//____________________________________________________________________________
// numGaps

template <typename TBlastSpec> inline unsigned int & numGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1562)

//____________________________________________________________________________
// numHits

template <typename TBlastHsp, typename TInfoSpec> inline unsigned int numHits(BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(818)

//____________________________________________________________________________
// numHsps

template <typename TBlastHsp, typename TSpec> inline unsigned int numHsps(BlastHit<TBlastHsp, StoreReport<TSpec> >& blastHit);       	// "projects/library/seqan/blast/blast_hit.h"(151)
template <typename TBlastHsp, typename TInfoSpec> inline unsigned int numHsps(BlastReport<TBlastHsp,StoreReport<TInfoSpec> > & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(838)

//____________________________________________________________________________
// operator!=

template <typename TBlastHsp, typename TStoreSpec> inline bool operator!=(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it1, Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(303)
template <typename TBlastReport> inline bool operator!=(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it1, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(315)
template <typename TBlastHit> inline bool operator!=(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it1, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(291)
template <typename TBlastObject, typename TIteratorSpec> inline bool operator!=(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it1, Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it2);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(330)

//____________________________________________________________________________
// operator*

template <typename TBlastHsp, typename TStoreSpec> inline typename Reference<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type operator* (Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(167)
template <typename TBlastObject, typename TIteratorSpec> inline typename Reference<Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> > >::Type operator* (Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(195)

//____________________________________________________________________________
// operator++

template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& operator++(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(246)
template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& operator++(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(264)

//____________________________________________________________________________
// operator--

template <typename TBlastHsp, typename TStoreSpec> inline Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& operator--(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(269)
template <typename TBlastObject, typename TIteratorSpec> inline Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& operator--(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(296)

//____________________________________________________________________________
// operator==

template <typename TBlastHsp, typename TStoreSpec> inline bool operator==(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it1, Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(292)
template <typename TBlastReport> inline bool operator==(Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it1, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(304)
template <typename TBlastHit> inline bool operator==(Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it1, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it2);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(280)
template <typename TBlastObject, typename TIteratorSpec> inline bool operator==(Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it1, Iter<TBlastObject, SimpleBlastIterator<TIteratorSpec> >& it2);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(319)

//____________________________________________________________________________
// percentGaps

template <typename TBlastSpec> inline unsigned int & percentGaps(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1546)

//____________________________________________________________________________
// percentIdentity

template <typename TBlastSpec> inline unsigned int & percentIdentity(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1528)

//____________________________________________________________________________
// percentPositives

template <typename TSpec> inline unsigned int & percentPositives(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1667)

//____________________________________________________________________________
// queryAlignmentString

template <typename TBlastSpec, typename TInfoSpec> inline String<char> & queryAlignmentString(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1406)

//____________________________________________________________________________
// queryBegin

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & queryBegin(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1288)

//____________________________________________________________________________
// queryEnd

template <typename TBlastSpec, typename TInfoSpec> inline unsigned int & queryEnd(BlastHsp<TBlastSpec, TInfoSpec>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1349)

//____________________________________________________________________________
// queryFrame

template <typename TSpec> inline int & queryFrame(BlastHsp<ProteinBlast<TSpec>, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1634)

//____________________________________________________________________________
// queryName

template <typename TBlastHsp, typename TSpec> inline String<char> & queryName(BlastReport<TBlastHsp,TSpec> & blastObj);       	// "projects/library/seqan/blast/blast_report.h"(734)

//____________________________________________________________________________
// queryOrientationPlus

template <typename TBlastSpec> inline bool queryOrientationPlus(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1604)

//____________________________________________________________________________
// read

template <typename TBlastHsp, typename TFile> void read(TFile & file, BlastReport<TBlastHsp, StreamReport<TFile> >& blastObj, Tag<TagBlast_>);       	// "projects/library/seqan/blast/blast_stream_report.h"(104)
template <typename TFile, typename TBlastHsp, typename TInfoSpec> void read(TFile & file, BlastReport<TBlastHsp, StoreReport<TInfoSpec> >& blastObj, Tag<TagBlast_>);       	// "projects/library/seqan/blast/blast_report.h"(508)

//____________________________________________________________________________
// run

template <typename TBlast, typename TBlastReport, typename TString, typename TParamString> void run(Tag<TBlast> tag, TString blast_path, TString db_path, TString db_name, TString query_path, TString query_name, TBlastReport & blastObj, TParamString params);       	// "projects/library/seqan/blast/blast_run.h"(124)

//____________________________________________________________________________
// score

template <typename TBlastSpec> inline float & score(BlastHsp<TBlastSpec, FullInfo>& blastHsp);       	// "projects/library/seqan/blast/blast_hsp.h"(1472)

//____________________________________________________________________________
// value

template <typename TBlastHsp, typename TStoreSpec> inline typename Reference<Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> > >::Type value(Iter<BlastHit<TBlastHsp, TStoreSpec> , SimpleBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_hsp_iterator.h"(157)
template <typename TBlastReport, typename TFile> inline typename Reference<Iter<TBlastReport, StreamBlastIterator<HitIterator> > >::Type value(TFile & file, Iter<TBlastReport, StreamBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hit_iterator.h"(366)
template <typename TBlastHit, typename TFile> inline typename Reference<Iter<TBlastHit, StreamBlastIterator<HspIterator> > >::Type value(TFile & file, Iter<TBlastHit, StreamBlastIterator<HspIterator> >& it);       	// "projects/library/seqan/blast/blast_stream_hsp_iterator.h"(326)
template <typename TBlastReport> inline typename Reference<Iter<TBlastReport, SimpleBlastIterator<HitIterator> > >::Type value(Iter<TBlastReport, SimpleBlastIterator<HitIterator> >& it);       	// "projects/library/seqan/blast/blast_hit_iterator.h"(371)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

