// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_CONSENSUS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_CONSENSUS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Bayesian_

struct Bayesian_;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(83)

//____________________________________________________________________________
// ConsensusOptions

struct ConsensusOptions;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(95)

//____________________________________________________________________________
// ConsensusScore_

struct ConsensusScore_;       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(52)

//____________________________________________________________________________
// FastaReadFormat_

struct FastaReadFormat_;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(1102)

//____________________________________________________________________________
// FractionalScore_

struct FractionalScore_;       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(57)

//____________________________________________________________________________
// LessPair_

template <typename TSize> struct LessPair_;       	// "seqan-1.3.1/seqan/consensus/consensus_library.h"(92)

//____________________________________________________________________________
// MajorityVote_

struct MajorityVote_;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(74)

//____________________________________________________________________________
// OverlapLibrary_

struct OverlapLibrary_;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(52)

//____________________________________________________________________________
// WeightedConsensusScore

template <typename TScore1, typename TScore2> struct WeightedConsensusScore;       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(63)

//____________________________________________________________________________
// _LessTripel

template <typename TSize> struct _LessTripel;       	// "seqan-1.3.1/seqan/consensus/consensus_library.h"(103)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Bayesian

typedef Tag<Bayesian_> const Bayesian;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(84)

//____________________________________________________________________________
// ConsensusScore

typedef Tag<ConsensusScore_> const ConsensusScore;       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(53)

//____________________________________________________________________________
// FastaReadFormat

typedef Tag<FastaReadFormat_> const FastaReadFormat;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(1103)

//____________________________________________________________________________
// FractionalScore

typedef Tag<FractionalScore_> const FractionalScore;       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(58)

//____________________________________________________________________________
// MajorityVote

typedef Tag<MajorityVote_> const MajorityVote;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(75)

//____________________________________________________________________________
// OverlapLibrary

typedef Tag<OverlapLibrary_> const OverlapLibrary;       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(53)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _convertSimpleReadFile

template <typename TFile, typename TSpec, typename TConfig, typename TFilePath> inline bool _convertSimpleReadFile(TFile& file, FragmentStore<TSpec, TConfig>& fragStore, TFilePath& filePath, bool moveToFront);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(1290)

//____________________________________________________________________________
// _countLetters

template <typename TValue, typename TSpec, typename TCounters, typename TSize, typename TAlphabet> inline void _countLetters(String<TValue, TSpec> const& mat, TCounters& counterValues, TSize alignDepth, TAlphabet);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(742)

//____________________________________________________________________________
// _getAlignmentStatistics

template <typename TSize, typename TCargo1, typename TCargo2> inline void _getAlignmentStatistics(Nothing&, TSize, TSize, TSize, TCargo1, TCargo2);       	// "seqan-1.3.1/seqan/consensus/consensus_library.h"(51)
template <typename TValue, typename TSpec, typename TSize, typename TCargo1, typename TCargo2> inline void _getAlignmentStatistics(String<TValue, TSpec>& dist, TSize i, TSize j, TSize nseq, TCargo1, TCargo2 quality);       	// "seqan-1.3.1/seqan/consensus/consensus_library.h"(65)
template <typename TCargo, typename TSpec, typename TSize, typename TCargo1, typename TCargo2> inline void _getAlignmentStatistics(Graph<Undirected<TCargo, TSpec> >& dist, TSize i, TSize j, TSize, TCargo1, TCargo2 quality);       	// "seqan-1.3.1/seqan/consensus/consensus_library.h"(80)

//____________________________________________________________________________
// _loadContigReads

template <typename TValue, typename TStrSpec, typename TPosPair, typename TStringSpec, typename TSpec, typename TConfig, typename TId> inline void _loadContigReads(StringSet<TValue, Owner<TStrSpec> >& strSet, String<TPosPair, TStringSpec>& startEndPos, FragmentStore<TSpec, TConfig> const& fragStore, TId const contigId);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(166)

//____________________________________________________________________________
// _writeCeleraCgb

template <typename TFile, typename TSpec, typename TConfig> inline void _writeCeleraCgb(TFile& target, FragmentStore<TSpec, TConfig>& fragStore);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(1749)

//____________________________________________________________________________
// _writeCeleraFrg

template <typename TFile, typename TSpec, typename TConfig> inline void _writeCeleraFrg(TFile& target, FragmentStore<TSpec, TConfig>& fragStore);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(1667)

//____________________________________________________________________________
// appendSegmentMatches

template <typename TString, typename TSpec, typename TId, typename TDiagList, typename TBegEndPos, typename TScore, typename TSize, typename TSegmentMatches, typename TScoreValues, typename TDistance> inline void appendSegmentMatches(StringSet<TString, TSpec> const& str, String<Pair<TId, TId> > const& pList, TDiagList const& dList, TBegEndPos const& begEndPos, TScore const& score_type, TSize thresholdMatchlength, TSize thresholdQuality, TSize maxOvl, TSegmentMatches& matches, TScoreValues& scores, TDistance& dist, OverlapLibrary);       	// "seqan-1.3.1/seqan/consensus/consensus_library.h"(385)

//____________________________________________________________________________
// assignGappedConsensus

template <typename TSpec, typename TConfig, typename TGappedConsensus, typename TSize> inline void assignGappedConsensus(FragmentStore<TSpec, TConfig>& fragStore, TGappedConsensus& gappedCons, TSize contigId);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(389)

//____________________________________________________________________________
// assignProfile

template <typename TValue, typename TString> inline void assignProfile(Score<TValue, ConsensusScore>& me, TString const& profile);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(99)
template <typename TValue, typename TString> inline void assignProfile(Score<TValue, FractionalScore>& me, TString const& profile);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(211)
template <typename TValue, typename TScore1, typename TScore2, typename TString> inline void assignProfile(Score<TValue, WeightedConsensusScore<TScore1, TScore2> >& me, TString const& profile);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(317)

//____________________________________________________________________________
// consensusAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TSize, typename TConfigOptions> inline void consensusAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& gOut, String<Pair<TSize, TSize> >& begEndPos, TConfigOptions const& consOpt);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(436)
template <typename TStringSet, typename TCargo, typename TSpec, typename TSize> inline void consensusAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& gOut, String<Pair<TSize, TSize> >& begEndPos);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(494)

//____________________________________________________________________________
// consensusCalling

template <typename TValue, typename TSpec, typename TGappedCons, typename TAlignDepth, typename TAlphabet> inline void consensusCalling(String<TValue, TSpec> const& mat, TGappedCons& gappedConsensus, TAlignDepth maxCoverage, TAlphabet, Bayesian);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(787)
template <typename TFragSpec, typename TConfig, typename TContigId> inline void consensusCalling(FragmentStore<TFragSpec, TConfig>& fragStore, TContigId contigId, Bayesian);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(989)
template <typename TValue, typename TSpec, typename TGappedCons, typename TAlignDepth, typename TAlphabet> inline void consensusCalling(String<TValue, TSpec> const& mat, TGappedCons& gappedConsensus, TAlignDepth maxCoverage, TAlphabet, MajorityVote);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(1021)
template <typename TFragSpec, typename TConfig, typename TContigId> inline void consensusCalling(FragmentStore<TFragSpec, TConfig>& fragStore, TContigId contigId, MajorityVote);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(1065)

//____________________________________________________________________________
// convertAlignment

template <typename TSpec, typename TConfig, typename TMatrix, typename TSize2, typename TSize, typename TReadSlot> inline bool convertAlignment(FragmentStore<TSpec, TConfig>& fragStore, TMatrix& mat, TSize2 contigId, TSize& coverage, TReadSlot& slot);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(215)
template <typename TSpec, typename TConfig, typename TMatrix, typename TSize2, typename TSize> inline bool convertAlignment(FragmentStore<TSpec, TConfig>& fragStore, TMatrix& mat, TSize2 contigId, TSize& coverage);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(329)
template <typename TSpec, typename TConfig, typename TMatrix> inline bool convertAlignment(FragmentStore<TSpec, TConfig>& fragStore, TMatrix& mat);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(341)

//____________________________________________________________________________
// getGappedConsensus

template <typename TSpec, typename TConfig, typename TGappedConsensus, typename TSize> inline void getGappedConsensus(FragmentStore<TSpec, TConfig>& fragStore, TGappedConsensus& gappedConsensus, TSize contigId);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(355)

//____________________________________________________________________________
// insertGap

template <typename TPos, typename TGapAnchor, typename TSpec, typename TGapPos> inline int insertGap(AlignedReadStoreElement<TPos, TGapAnchor, TSpec>& alignedRead, TGapPos const gapPos);       	// "seqan-1.3.1/seqan/consensus/consensus_realign.h"(84)
template <typename TAlignedReads, typename TSpec, typename TGapPos> inline int insertGap(String<TAlignedReads, TSpec>& alignedReadStore, TGapPos const gapPos);       	// "seqan-1.3.1/seqan/consensus/consensus_realign.h"(144)

//____________________________________________________________________________
// reAlign

template <typename TFragSpec, typename TConfig, typename TAlignedRead, typename TSpec, typename TConsensus, typename TScore, typename TMethod, typename TBandwidth> void reAlign(FragmentStore<TFragSpec, TConfig>& fragStore, String<TAlignedRead, TSpec>& contigReads, TConsensus& consensus, TScore& consScore, TMethod const rmethod, TBandwidth const bandwidth, bool includeReference, double & timeBeforeAlign, double & timeAlign, double & timeAfterAlign );       	// "seqan-1.3.1/seqan/consensus/consensus_realign.h"(201)
template <typename TSpec, typename TConfig, typename TScore, typename TId, typename TMethod, typename TBandwidth> void reAlign(FragmentStore<TSpec, TConfig>& fragStore, TScore& consScore, TId const contigId, TMethod const rmethod, TBandwidth const bandwidth, bool includeReference);       	// "seqan-1.3.1/seqan/consensus/consensus_realign.h"(523)
template <typename TSpec, typename TConfig, typename TScore, typename TId, typename TBandwidth> inline void reAlign(FragmentStore<TSpec, TConfig>& fragStore, TScore& consScore, TId const contigId, TBandwidth const bandwidth, bool includeReference);       	// "seqan-1.3.1/seqan/consensus/consensus_realign.h"(757)

//____________________________________________________________________________
// removeGap

template <typename TPos, typename TGapAnchor, typename TSpec, typename TGapPos> inline void removeGap(AlignedReadStoreElement<TPos, TGapAnchor, TSpec>& alignedRead, TGapPos const gapPos);       	// "seqan-1.3.1/seqan/consensus/consensus_realign.h"(47)
template <typename TAlignedReads, typename TSpec, typename TGapPos> inline void removeGap(String<TAlignedReads, TSpec>& alignedReadStore, TGapPos const gapPos);       	// "seqan-1.3.1/seqan/consensus/consensus_realign.h"(68)

//____________________________________________________________________________
// score

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, ConsensusScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &, TSeq2 const &seq2);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(177)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, FractionalScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(282)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(381)

//____________________________________________________________________________
// scoreConsensus

template <typename TConsensus> inline int scoreConsensus(TConsensus& consensus);       	// "seqan-1.3.1/seqan/consensus/consensus_realign.h"(161)

//____________________________________________________________________________
// scoreGapExtendHorizontal

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, ConsensusScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &, TSeq2 const &);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(128)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, FractionalScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(235)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(332)

//____________________________________________________________________________
// scoreGapExtendVertical

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, ConsensusScore> const &, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(153)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, FractionalScore> const &, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(259)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const & seq1, TSeq2 const & seq2);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(357)

//____________________________________________________________________________
// scoreGapOpenHorizontal

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, ConsensusScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &, TSeq2 const &);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(140)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, FractionalScore> const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(247)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(344)

//____________________________________________________________________________
// scoreGapOpenVertical

template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, ConsensusScore> const &, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(165)
template <typename TValue, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, FractionalScore> const &, TPos1, TPos2, TSeq1 const &, TSeq2 const &);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(271)
template <typename TValue, typename TScore1, typename TScore2, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, WeightedConsensusScore<TScore1, TScore2> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const & seq1, TSeq2 const & seq2);       	// "seqan-1.3.1/seqan/consensus/consensus_score.h"(369)

//____________________________________________________________________________
// selectPairs

template <typename TString, typename TSpec, typename TBegEndPos, typename TSize, typename TPairList, typename TPos, typename TSpec2> inline void selectPairs(StringSet<TString, TSpec> const& str, TBegEndPos const& begEndPos, TSize bandwidth, TPairList& pList, String<Pair<TPos, TPos>, TSpec2>& dList);       	// "seqan-1.3.1/seqan/consensus/consensus_library.h"(120)

//____________________________________________________________________________
// selectPairsIndel

template <typename TString, typename TSpec, typename TBegEndPos, typename TSize, typename TPairList, typename TPos, typename TSpec2> inline void selectPairsIndel(StringSet<TString, TSpec> const& str, TBegEndPos const& begEndPos, TSize lookAround, TPairList& pList, String<Pair<TPos, TPos>, TSpec2>& dList);       	// "seqan-1.3.1/seqan/consensus/consensus_library.h"(340)

//____________________________________________________________________________
// updateContig

template <typename TFragSpec, typename TConfig, typename TStringSet, typename TCargo, typename TSpec, typename TContigId> inline void updateContig(FragmentStore<TFragSpec, TConfig>& fragStore, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TContigId contigId);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(507)

//____________________________________________________________________________
// write

template <typename TFile, typename TSpec, typename TConfig> inline void write(TFile & file, FragmentStore<TSpec, TConfig>& fragStore, FastaReadFormat);       	// "seqan-1.3.1/seqan/consensus/consensus_base.h"(1112)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

