/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "Memory.h"

Memory::Memory(const int secondsLimit, const short resolution, const uint64_t amountLimit,
		const bool bigger) :
	AbstractLoopCondition(secondsLimit, resolution), amountLimit(amountLimit), bigger(bigger) {

}

void Memory::open() {
#ifdef SA_OPEN_MEMORY
	error = sa_open_memory();
#endif
}

bool Memory::evaluate() {
	if ((error = sa_get_memory(&memory)) != 0)
		return 0;

	return (bigger ? memory.total - memory.free > amountLimit : memory.total - memory.free
			< amountLimit);
}

void Memory::close() {
#ifdef SA_CLOSE_MEMORY
	sa_close_memory();
#endif
}
