/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef PLAYALARM_H_
#define PLAYALARM_H_

#include "AbstractAction.h"
#include <QObject>
#include <Phonon/AudioOutput>
#include <Phonon/MediaObject>

class PlayAlarm : public QObject, public AbstractAction {
Q_OBJECT

public:
	PlayAlarm(const QString& url);
	~PlayAlarm();
	void execute();
	void stop();

protected:
	QString url;
	Phonon::MediaObject media;
	Phonon::AudioOutput* output;

protected slots:
	void enqueue();

};

#endif /* PLAYALARM_H_ */
