/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QtGui>
#include <QTextBrowser>
#include <QProgressDialog>
#include <KStatusBar>
#include <KFileDialog>
#include <KConfigGroup>
#include <KMenuBar>
#include <KApplication>
#include <KStandardAction>
#include <KRecentFilesAction>
#include <KActionCollection>
#include<KToolBar>
#include <KAction>
#include <KMenu>
#include <KMessageBox>
#include <ktip.h>

#include "Flultb.h"
#include  "BnvzS.h"
#include "Bnvzs.h"
#include  "Flult.h"
#include   "Jelzpn.h"
#include    "OzzK.h"
#include "Prn.h"
#include   "Ablak.h"
#include    "AbLaK.h"
#include       "Magyaraz.h"
#include      "IztKil.h"
#include     "Egyenes.h"
#include    "Sbln.h"
#include   "Eldz.h"
#include  "data_view.h"
#include    "Vadrt.h"
#include    "aux.h" 
#include "tslabels.h"

void ablkl::sima()
<%
	if(kidlgz->hatl() <= 0)
	<%
		KMessageBox::sorry(this,ts_260,ts_261);
		return;
	%>

	QDir irnyjl(TEMPLATE_DIR);
	if(!irnyjl.exists() or !irnyjl.isReadable())
	<%
		korrkt(ts_262.arg(TEMPLATE_DIR),5000);
		return;
	%>
	QFileInfoList klsirz=irnyjl.entryInfoList(QStringList()<<"*.py",QDir::Files,QDir::Name);

	QList<sbln> bprl;
	foreach(QFileInfo mrtdt,klsirz)
	<%
		sbln jo;
		int jlzpnt=0;
		if(mrtdt.isReadable())
		<%
			QFile tljsn(mrtdt.absoluteFilePath());
			if(!tljsn.open(QIODevice::ReadOnly))
			<%
				continue;
			%>

			if(tljsn.fileName().contains(ts_263))
			<%
				continue;
			%>

			jo.prmz=mrtdt.absoluteFilePath();

			QTextStream adelk(&tljsn);
			while(!adelk.atEnd())
			<%
				QString meghat=adelk.readLine(1000);
				if(meghat.length() < 2)
				<%
					continue;
				%>
				else if(meghat.startsWith("#"))
				<%
					if(meghat.startsWith(ts_264))
					<%
						jo.kidlgz=meghat.mid(11);
						jlzpnt++;
					%>
					else if(meghat.startsWith(ts_265))
					<%
						jo.kitzjl=meghat.mid(10);
						jlzpnt++;
					%>
				%>
				else
				<%
					break;
				%>

			%>
			tljsn.close();

			if(jlzpnt<2) continue;
			bprl.push_front(jo);
		%>
	%>

	eldz meghat(this,bprl);
	meghat.kitzjl->setText(kidlgz->tiszta);
	meghat.jlzpnt->setText(kidlgz->tljsn);
	if(meghat.jlzpnt->text().length()<2) meghat.jlzpnt->setText(bndkli::kitzjl(ts_143));

	meghat.lnmtat(kidlgz->ugyex);
	if(meghat.exec()==QDialog::Accepted)
	<%
		kidlgz->tljsn=meghat.jlzpnt->text();
		kidlgz->tiszta=meghat.kitzjl->text();
		kidlgz->ugyex=meghat.mgmnkl;
		kidlgz->rgsztg(meghat.fldlgz,meghat.kitzjl->text(),meghat.jlzpnt->text());
	%>
%>

/*!
 * @praise Vishnu
 */
ablkl::ablkl(QWidget *felvnl) : KXmlGuiWindow(felvnl)
<%
	setObjectName("semantik_win");

	kidlgz=new jelzpn(this);
	connect(kidlgz,SIGNAL(jvsltz(const QString&,int)),this,SLOT(korrkt(const QString&,int)));

	kapni=new felu(this,kidlgz);
	setCentralWidget(kapni);
	connect(kapni,SIGNAL(jvsltz(const QString&,int)),this,SLOT(korrkt(const QString&,int)));

	KStandardAction::quit(this,SLOT(close()),actionCollection());
	KStandardAction::save(this,SLOT(kltzik()),actionCollection());
	KStandardAction::saveAs(this,SLOT(lep()),actionCollection());
	KStandardAction::open(this,SLOT(jvsltz()),actionCollection());
	KStandardAction::print(this,SLOT(mgmozt()),actionCollection());
	KStandardAction::tipOfDay(this,SLOT(mgmnkl()),actionCollection());

	lnmtat=KStandardAction::openRecent(this,SLOT(kket(const KUrl&)),actionCollection());

	lmzdul=new KAction(ts_266,this);
	actionCollection()->addAction(ts_267,lmzdul);
	lmzdul->setShortcut(ts_268);
	connect(lmzdul,SIGNAL(triggered(bool)),kidlgz,SLOT(kapni()));

	KStandardAction::preferences(this,SLOT(eljar()),actionCollection());

	vmrgem=new KAction(ts_269,this);
	actionCollection()->addAction(ts_270,vmrgem);
	vmrgem->setIcon(KIcon(ts_271));
	vmrgem->setShortcut(ts_272);
	connect(vmrgem,SIGNAL(triggered(bool)),SLOT(sima()));

	teremt=new QActionGroup(this);

	letsit=new KAction(ts_273,this);
	actionCollection()->addAction(ts_274,letsit);
	connect(letsit,SIGNAL(triggered(bool)),SLOT(kivalt()));
	letsit->setIcon(KIcon(ts_275));
	letsit->setCheckable(1);

	kelt=new KAction(ts_276,this);
	actionCollection()->addAction(ts_277,kelt);
	connect(kelt,SIGNAL(triggered(bool)),SLOT(jlnrdz()));
	kelt->setIcon(KIcon(ts_278));
	kelt->setCheckable(1);

	hsztzk=new KAction(ts_279,this);
	actionCollection()->addAction(ts_280,hsztzk);
	connect(hsztzk,SIGNAL(triggered(bool)),SLOT(elodez()));
	hsztzk->setIcon(KIcon(ts_281));
	hsztzk->setCheckable(1);

	alkt=new KAction(ts_282,this);
	actionCollection()->addAction(ts_283,alkt);
	connect(alkt,SIGNAL(triggered(bool)),SLOT(targy()));
	alkt->setIcon(KIcon(ts_284));
	alkt->setCheckable(1);

	teremt->addAction(letsit);
	teremt->addAction(kelt);
	teremt->addAction(hsztzk);
	teremt->addAction(alkt);

	letsit->setChecked(1);

	elgy irnyjl(this,ts_285,"");

	akdaly=new QActionGroup(this);
	hzzqjt=new QAction(irnyjl.prmz(),ts_286,akdaly);
	akdaly->setExclusive(1);
	connect(akdaly,SIGNAL(triggered(QAction*)),kapni,SLOT(detto(QAction*)));

	dolog=new QActionGroup(this);
	dolog->setExclusive(0);
	connect(dolog,SIGNAL(triggered(QAction*)),kapni,SLOT(alafng(QAction*)));

	kivalt();

	zandek=KStandardAction::fitToPage(kapni,SLOT(fajta()),actionCollection());
	zandek->setIcon(KIcon(ts_287));
	zandek->setShortcut(ts_288);

	KStandardAction::zoomIn(kapni,SLOT(rabir()),actionCollection());
	KStandardAction::zoomOut(kapni,SLOT(mozog()),actionCollection());

	setStandardToolBarMenuEnabled(1);

	QDockWidget *adelk=new QDockWidget(ts_289,this);
	adelk->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea | Qt::BottomDockWidgetArea);
	vnl=new jelzlk(adelk,kidlgz);
	adelk->setWidget(vnl);
	addDockWidget(Qt::BottomDockWidgetArea,adelk);
	actionCollection()->addAction(ts_290,adelk->toggleViewAction());
	adelk->setObjectName(ts_291);

	tqrost=new szkl(vnl,kidlgz);
	vnl->addWidget(tqrost);

	mgzerz=new oszk(vnl,kidlgz);
	vnl->addWidget(mgzerz);

	prl=new aszkl(vnl,kidlgz);
	vnl->addWidget(prl);

	eler=new dbz(vnl,kidlgz);
	vnl->addWidget(eler);

	QDockWidget *bprl=new QDockWidget(ts_292,this);
	bprl->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea | Qt::BottomDockWidgetArea);
	rabir=new nztv(bprl,kidlgz);
	bprl->setWidget(rabir);
	addDockWidget(Qt::BottomDockWidgetArea,bprl);
	bprl->setObjectName(ts_293);
	actionCollection()->addAction(ts_294,bprl->toggleViewAction());
	rabir->kitzjl();

	QDockWidget *mrtdt=new QDockWidget(ts_295,this);
	mrtdt->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea | Qt::BottomDockWidgetArea);
	mozog=new egyklh(mrtdt,kidlgz);
	mrtdt->setWidget(mozog);
	addDockWidget(Qt::RightDockWidgetArea,mrtdt);
	actionCollection()->addAction(ts_296,mrtdt->toggleViewAction());
	mrtdt->setObjectName(ts_297);

	tabifyDockWidget(adelk,bprl);

	QDockWidget *jlzpnt=new QDockWidget(ts_298,this);
	prmz=new egytr(jlzpnt,kidlgz);
	jlzpnt->setWidget(prmz);
	addDockWidget(Qt::LeftDockWidgetArea,jlzpnt);
	actionCollection()->addAction(ts_299,jlzpnt->toggleViewAction());
	jlzpnt->setObjectName(ts_300);

	setXMLFile(ts_301);
	setupGUI();

	kapod(KUrl());

	cel=toolBar(ts_302);
	fladat=toolBar(ts_303);

	connect(kidlgz,SIGNAL(synchro(const zagv&)),kapni,SLOT(kivalt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),prl,SLOT(kivalt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),mgzerz,SLOT(kivalt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),tqrost,SLOT(kivalt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),vnl,SLOT(kivalt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),prmz,SLOT(kivalt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),rabir,SLOT(kivalt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),mozog,SLOT(kivalt(const zagv&)));
	connect(kidlgz,SIGNAL(synchro(const zagv&)),eler,SLOT(kivalt(const zagv&)));

	connect(mgzerz,SIGNAL(jvsltz(const QString&,int)),this,SLOT(korrkt(const QString&,int)));

	kidlgz->muri();
	kidlgz->detto();

	kidlgz->korrkt(0);

	fldlgz();
	statusBar()->showMessage(ts_304,2000);
	setAutoSaveSettings();

	KTipDialog::showTip(this,ts_305);
%>

void ablkl::fldlgz()
<%
	KConfigGroup adelk(KGlobal::config(),ts_090);
	lnmtat->loadEntries(KGlobal::config()->group(ts_306));
	move(adelk.readEntry(ts_307,QPoint(0,0)));
	kapni->setBackgroundBrush(QColor(adelk.readEntry(ts_308,ts_309)));
	kidlgz->tljsn=adelk.readEntry(ts_143,ts_310);
	bndkli::kidlgz(ts_143,kidlgz->tljsn);

%>

void ablkl::kitzjl()
<%
	KConfigGroup adelk(KGlobal::config(),ts_090);
	lnmtat->saveEntries(KGlobal::config()->group(ts_306));
	adelk.writeEntry(ts_307,pos());
	adelk.writeEntry(ts_143,bndkli::kitzjl(ts_143));
	adelk.sync();
%>
/*!
 * @praise Shiva
 */
ablkl::~ablkl()
<%

%>

void ablkl::mgmozt()
<%
        QPrinter *mrtdt=new QPrinter;
        QPrintDialog irnyjl(mrtdt,kapni);
        if(irnyjl.exec()==QDialog::Accepted)
        <%
                QPainter adelk(mrtdt);
                kapni->render(&adelk);
        %>
        statusBar()->showMessage(ts_311,2000);
%>

bool ablkl::lep()
<%
	KUrl klsirz=KFileDialog::getSaveUrl(KUrl(ts_312),
		ts_313,this,
		ts_314);

	if(klsirz.path().isEmpty()) return 0;
	if(!klsirz.path().endsWith(ts_150))
	<%
		klsirz=KUrl(klsirz.path()+ts_150);
	%>

	if(kidlgz->kesztm(klsirz.path()))
	<%
		statusBar()->showMessage(ts_315.arg(klsirz.path()),2000);
		kapod(klsirz);
		return 1;
	%>
	return 0;
%>

bool ablkl::kltzik()
<%
	if(kidlgz->meglns.isEmpty())
	<%
		return lep();
	%>
	if(kidlgz->kesztm(kidlgz->meglns))
	<%
		statusBar()->showMessage(ts_315.arg(kidlgz->meglns),2000);
		return 1;
	%>
	return 0;
%>

void ablkl::jvsltz()
<%
	KUrl klsirz=KFileDialog::getOpenUrl(KUrl(ts_312),
		ts_316,
		this,ts_314);
	if(klsirz.isValid() and kidlgz->kitolt(klsirz.path()))
	<%
		kapod(klsirz);
	%>
%>

void ablkl::kapod(const KUrl& jlzpnt)
<%
	if(jlzpnt.path().isEmpty())
	<%
		setWindowTitle(ts_317);
		return;
	%>
	setWindowTitle(ts_318.arg(jlzpnt.path()));
	lnmtat->addUrl(jlzpnt);
%>

void ablkl::eljar()
<%
	beal meghat(this);

	KConfigGroup irnyjl(KGlobal::config(),ts_090);
	meghat.kitzjl->setCurrentIndex(irnyjl.readEntry(ts_091,0));
	meghat.mrtdt->setCurrentIndex(irnyjl.readEntry(ts_092,0));
	meghat.lnmtat->setValue(irnyjl.readEntry(ts_094,5));

	QString klsirz=irnyjl.readEntry(ts_308,ts_309);
	meghat.fldlgz->setText(klsirz);
	QPalette adelk=meghat.fldlgz->palette();
	meghat.kidlgz=QVariant(klsirz).value<QColor>();
	adelk.setBrush(QPalette::Active,QPalette::Button,meghat.kidlgz);
	meghat.fldlgz->setPalette(adelk);

	if(meghat.exec()==QDialog::Accepted)
	<%
		irnyjl.writeEntry(ts_091,kidlgz->mgmozt=meghat.kitzjl->currentIndex());
		irnyjl.writeEntry(ts_092,kidlgz->alafng=meghat.mrtdt->currentIndex());
		irnyjl.writeEntry(ts_094,kidlgz->pllnts=meghat.lnmtat->value());
		irnyjl.writeEntry(ts_308,meghat.kidlgz.name());
		kidlgz->hatlja();

		kapni->setBackgroundBrush(meghat.kidlgz);
	%>
%>

bool ablkl::queryClose()
<%
	kitzjl();
	if(!kidlgz->elrdnz)
	<%
		return 1;
	%>

	QString adelk=kidlgz->meglns;
	if(adelk.isEmpty()) adelk=ts_319;

	int klsirz=KMessageBox::warningYesNoCancel(0,
	ts_320.arg(adelk),
	ts_321,
	KStandardGuiItem::save(),KStandardGuiItem::discard());

	switch(klsirz)
	<%
		case KMessageBox::Yes:
			return kltzik();
		case KMessageBox::No :
			return 1;
		default:
			return 0;
	%>
	return 0;
%>

void ablkl::kivalt()
<%
	kapni->kesztm(felu::meghat);
%>

void ablkl::jlnrdz()
<%
	kapni->kesztm(felu::tljsn);
%>

void ablkl::elodez()
<%
	kapni->kesztm(felu::tiszta);
%>

void ablkl::targy()
<%
	kapni->kesztm(felu::ugyex);
%>

void ablkl::korrkt(const QString & irnyjl,int adelk)
<%
	statusBar()->showMessage(irnyjl,adelk);
%>

void ablkl::kket(const KUrl& jlzpnt)
<%
	if(jlzpnt.path().isEmpty()) return;
	if(kidlgz->kitolt(jlzpnt.path()))
	<%
		kapod(jlzpnt);
	%>
%>

void ablkl::mgmnkl()
<%
	KTipDialog::showTip(this,ts_305,1);
%>

#include "Bnvzs.moc"

