/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.3:
 *   smidump -f scli UDP-MIB
 *
 * Derived from UDP-MIB:
 *   The MIB module for managing UDP implementations.
 *   Copyright (C) The Internet Society (2005).  This
 *   version of this MIB module is part of RFC 4113;
 *   see the RFC itself for full legal notices.
 *
 * Revision 2005-05-20 00:00:
 *   IP version neutral revision, incorporating the
 *   following revisions:
 *   
 *   - Added udpHCInDatagrams and udpHCOutDatagrams in order
 *     to provide high-capacity counters for fast networks.
 *   - Added text to the descriptions of all counter objects
 *     to indicate how discontinuities are detected.
 *   - Deprecated the IPv4-specific udpTable and replaced it
 *     with the version neutral udpEndpointTable.  This
 *     table includes support for connected UDP endpoints
 *     and support for identification of the operating
 *     system process associated with a UDP endpoint.
 *   - Deprecated the udpGroup and replaced it with object
 *     groups representing the current set of objects.
 *   - Deprecated udpMIBCompliance and replaced it with
 *     udpMIBCompliance2, which includes the compliance
 *     information for the new object groups.
 *   
 *   This version published as RFC 4113.
 *
 * Revision 1994-11-01 00:00:
 *   Initial SMIv2 version, published as RFC 2013.
 *
 * Revision 1991-03-31 00:00:
 *   The initial revision of this MIB module was part of
 *   MIB-II, published as RFC 1213.
 *
 * $Id: udp-mib.h 1787 2006-02-21 20:45:55Z schoenw $
 */

#ifndef _UDP_MIB_H_
#define _UDP_MIB_H_

#include "gsnmp.h"

G_BEGIN_DECLS

/*
 * C type definitions for UDP-MIB::udp.
 */

#define UDP_MIB_UDPINDATAGRAMS    (1 << 0) 
#define UDP_MIB_UDPNOPORTS        (1 << 1) 
#define UDP_MIB_UDPINERRORS       (1 << 2) 
#define UDP_MIB_UDPOUTDATAGRAMS   (1 << 3) 
#define UDP_MIB_UDPHCINDATAGRAMS  (1 << 4) 
#define UDP_MIB_UDPHCOUTDATAGRAMS (1 << 5) 

typedef struct {
    guint32  *udpInDatagrams;        /* ro SNMPv2-SMI::Counter32 */
    guint32  *udpNoPorts;            /* ro SNMPv2-SMI::Counter32 */
    guint32  *udpInErrors;           /* ro SNMPv2-SMI::Counter32 */
    guint32  *udpOutDatagrams;       /* ro SNMPv2-SMI::Counter32 */
    guint64  *udpHCInDatagrams;      /* ro SNMPv2-SMI::Counter64 */
    guint64  *udpHCOutDatagrams;     /* ro SNMPv2-SMI::Counter64 */
} udp_mib_udp_t;

extern udp_mib_udp_t *
udp_mib_new_udp(void);

extern void
udp_mib_get_udp(GNetSnmp *s, udp_mib_udp_t **udp, gint64 mask);

extern void
udp_mib_free_udp(udp_mib_udp_t *udp);

/*
 * C type definitions for UDP-MIB::udpEntry.
 */

#define UDP_MIB_UDPLOCALADDRESS (1 << 0) 
#define UDP_MIB_UDPLOCALPORT    (1 << 1) 

typedef struct {
    guchar   udpLocalAddress[4];  /* ro SNMPv2-SMI::IpAddress */
#define UDP_MIB_UDPLOCALADDRESSLENGTH 4
    gint32   udpLocalPort;         /* ro */
} udp_mib_udpEntry_t;

extern void
udp_mib_get_udpTable(GNetSnmp *s, udp_mib_udpEntry_t ***udpEntry, gint64 mask);

extern void
udp_mib_free_udpTable(udp_mib_udpEntry_t **udpEntry);

extern udp_mib_udpEntry_t *
udp_mib_new_udpEntry(void);

extern void
udp_mib_get_udpEntry(GNetSnmp *s, udp_mib_udpEntry_t **udpEntry, guchar *udpLocalAddress, gint32 udpLocalPort, gint64 mask);

extern void
udp_mib_free_udpEntry(udp_mib_udpEntry_t *udpEntry);

/*
 * C type definitions for UDP-MIB::udpEndpointEntry.
 */

#define UDP_MIB_UDPENDPOINTPROCESS (1 << 0) 

typedef struct {
    gint32   udpEndpointLocalAddressType;   /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   udpEndpointLocalAddress[118];   /* na INET-ADDRESS-MIB::InetAddress */
#define UDP_MIB_UDPENDPOINTLOCALADDRESSMINLENGTH 0
#define UDP_MIB_UDPENDPOINTLOCALADDRESSMAXLENGTH 118
    guint16  _udpEndpointLocalAddressLength;
    guint32  udpEndpointLocalPort;    /* na INET-ADDRESS-MIB::InetPortNumber */
    gint32   udpEndpointRemoteAddressType;    /* na INET-ADDRESS-MIB::InetAddressType */
    guchar   udpEndpointRemoteAddress[118];    /* na INET-ADDRESS-MIB::InetAddress */
#define UDP_MIB_UDPENDPOINTREMOTEADDRESSMINLENGTH 0
#define UDP_MIB_UDPENDPOINTREMOTEADDRESSMAXLENGTH 118
    guint16  _udpEndpointRemoteAddressLength;
    guint32  udpEndpointRemotePort;   /* na INET-ADDRESS-MIB::InetPortNumber */
    guint32  udpEndpointInstance;     /* na */
    guint32  *udpEndpointProcess;     /* ro Unsigned32 */
} udp_mib_udpEndpointEntry_t;

extern void
udp_mib_get_udpEndpointTable(GNetSnmp *s, udp_mib_udpEndpointEntry_t ***udpEndpointEntry, gint64 mask);

extern void
udp_mib_free_udpEndpointTable(udp_mib_udpEndpointEntry_t **udpEndpointEntry);

extern udp_mib_udpEndpointEntry_t *
udp_mib_new_udpEndpointEntry(void);

extern void
udp_mib_get_udpEndpointEntry(GNetSnmp *s, udp_mib_udpEndpointEntry_t **udpEndpointEntry, gint32 udpEndpointLocalAddressType, guchar *udpEndpointLocalAddress, guint16 _udpEndpointLocalAddressLength, guint32 udpEndpointLocalPort, gint32 udpEndpointRemoteAddressType, guchar *udpEndpointRemoteAddress, guint16 _udpEndpointRemoteAddressLength, guint32 udpEndpointRemotePort, guint32 udpEndpointInstance, gint64 mask);

extern void
udp_mib_free_udpEndpointEntry(udp_mib_udpEndpointEntry_t *udpEndpointEntry);


G_END_DECLS

#endif /* _UDP_MIB_H_ */
