// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - DIGITEO - Clément DAVID
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- NO CHECK REF -->
// <-- TEST WITH XCOS -->
//
// <-- Non-regression test for bug 6776 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=6776
//
// <-- Short Description -->
// the non-empty block.doc field was not cleared on loading.
//

loadXcosLibs();

// Check that importScicosDiagram perform block.doc clearing
scs_m = importScicosDiagram(SCI + "/modules/xcos/tests/nonreg_tests/Antrieb3.cos");
obj = scs_m.objs(1);
if size(obj.doc) <> 0 then pause, end

// check that the export will not fail
tempFile = TMPDIR + "/6776temp.sod";
ierr = export_to_hdf5(tempFile, "scs_m");
if ierr <> %t then pause, end

deletefile(tempFile);

