// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2008 - INRIA
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
warning("off");

function r=testresult(eps)
  if argn(2)<=0 then eps=1d-10;end
  if or(isnan(real(y))<>isnan(real(yref)))  then r=%t,return,end;
  if or(isnan(imag(y))<>isnan(imag(yref)))  then r=%t,return,end;
  if or(size(y)<>size(yref)) then r=%t,return,end;
  if yref==[] then r=%f,return,end;
  k=find(abs(yref)==0);
  r=or(abs(y(k)-yref(k))>eps);
  k=find(abs(yref)<>0);
  r=r|or(max(abs(y(k)-yref(k))./abs(yref(k)))>eps);
endfunction
ieee(1)

// ------------------------------ besselk(alpha,x)------------------------------
//test of numerical precision reference computed by maple
exec(SCI+'/modules/special_functions/tests/unit_tests/besselk_ref.sce',-1)
besselK=besselk(alpha',x);
if norm((besselK-besselK_ref)./abs(besselK_ref),1)>1d6*%eps then pause,end

alpha=[];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[16.234027166616773];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[16.2340287900195683];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[0.421024438240708343];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.14446307980689488];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[0.0347395043862792421 0.0111596760858530247 0.00369109833404259336];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697761598043851849 0.609297669256695262 0.547807564313518958];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.000308362213060931921-699.503249938174008*%i 9.58800138559534094e-05+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.08310631727244942e-07-0.472541568707347648*%i 0.426384821387811808+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[ 0.0347395043862792421
 0.0111596760858530247
0.00369109833404259336];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697761598043851849
0.609297669256695262
0.547807564313518958];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.000308362213060931921-699.503249938174008*%i 
9.58800138559534094e-05+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.08310631727244942e-07-0.472541568707347648*%i 
 0.426384821387811808+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-12.9920245983972951-699.381145156678599*%i 9.58584235807003572e-05-2.02853533143100052e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000673690591289388989-0.472540114151826285*%i 0.426383961685526058-0.000494020086533254049*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[9999999.99999916367];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[10000000.999999214];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[0.601907230197234577];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.63615348626325807];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[0.0401564311281941769 0.0124834988872684315 0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.80656348012878698 0.681575945185670995 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[ 0.0401564311281941769
 0.0124834988872684315
0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 0.80656348012878698
0.681575945185670995
 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 
0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 
 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-12.2097820412575189-649.539559081750667*%i 0.000101411337448143222-2.15894410503202928e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000528666498849810103-0.438866355902376937*%i 0.451084799584356266-0.000579989976442809359*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[%inf %inf %inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf %inf %inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[9999999.99999916367 199999999999999.5 7.99999999999999056e+21];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[10000000.999999214 200000020000000.5 8.00000080000003028e+21];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[0.601907230197234577 1.62483889863517739 7.1012628247379439];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.63615348626325807 4.41677005233341102 19.3032336955969015];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[0.0401564311281941769 0.0174014255294872404 0.00829176841523093094];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.80656348012878698 0.950085641849530704 1.23060754505138759];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[ 0.0401564311281941769 0.0615104584717420244 0.122170375757183536
 0.0124834988872684315 0.0174014255294872404 0.0298849244167556718
0.00404461344545216286 0.00530894371222345902 0.00829176841523093094];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 0.80656348012878698 1.2354705847963765 2.45385759319062213
0.681575945185670995 0.950085641849530704 1.63166158703520159
 0.60027385878831252 0.787917107828843943 1.23060754505138759];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 0.000398455910810062441-521.515526255766758*%i -0.000547174002707648331-363.893259245845741*%i 
0.000101434481315590741+0*%i 0.00012003108083585597+0*%i 0.000158592138856474539+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 2.69172417957376988e-07-0.352303959851393844*%i -3.69637255607037082e-07-0.245824006652234722*%i 
 0.451085908928745838+0*%i 0.533786228275608399+0*%i 0.705269827155226015+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[%inf %inf %inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf %inf %inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[264928391.653412461 6358281399681985 2.79764381586007616e+23];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[264928418.14625293 6358282035510156 2.79764409562447141e+23];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[0.701079899557892183 2.10981175407567978 9.98425161749088552];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.90573275126611086 5.73506295257322485 27.1400097425883011];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[0.0427806945540970956 0.0190770205606465293 0.00924863337892758985];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.859273220065930987 1.04157003075555643 1.37261889714818142];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[ 0.0427806945540970956 0.0691669834332842848 0.144225603589580725
 0.0131117281572085929 0.0190770205606465293 0.0340964507739197759
0.00421016327579257221 0.0057255342081079727 0.00924863337892758985];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.859273220065930987 1.38925599961474155 2.89684868616755242
 0.71587610112107658 1.04157003075555643 1.86160313495218865
 0.62484363209802829 0.849744619375173871 1.37261889714818142];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.000273660347284653514-628.934159858371345*%i 0.000340084002811415643-490.660014148178334*%i -0.000478642485965506594-333.193877358099428*%i 
 0.000103975939764321327+0*%i 0.000125803839478814657+0*%i 0.000169873189015129033+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-1.84868175823797018e-07-0.424869412028293647*%i 2.2973993072224382e-07-0.331459864994254838*%i -3.23341558724874884e-07-0.225085383812578588*%i 
 0.462387944286756558+0*%i 0.559458071279206992+0*%i 0.755437410194912728+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[ 16.234027166616773
9999999.99999916367
 199999999999999.5];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[16.2340287900195683
 10000000.999999214
 200000020000000.5];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[0.421024438240708343
0.601907230197234577
 1.62483889863517739];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.14446307980689488
1.63615348626325807
4.41677005233341102];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[ 0.0347395043862792421 0.0401564311281941769 0.0615104584717420244
 0.0111596760858530247 0.0124834988872684315 0.0174014255294872404
0.00369109833404259336 0.00404461344545216286 0.00530894371222345902];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697761598043851849 0.80656348012878698 1.2354705847963765
0.609297669256695262 0.681575945185670995 0.950085641849530704
0.547807564313518958 0.60027385878831252 0.787917107828843943];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.000308362213060931921-699.503249938174008*%i -0.00032884199678432643-649.655191440786325*%i 0.000398455910810062441-521.515526255766758*%i 
9.58800138559534094e-05+0*%i 0.000101434481315590741+0*%i 0.00012003108083585597+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.08310631727244942e-07-0.472541568707347648*%i -2.22145519739981785e-07-0.438867272324231283*%i 2.69172417957376988e-07-0.352303959851393844*%i 
 0.426384821387811808+0*%i 0.451085908928745838+0*%i 0.533786228275608399+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[ 0.0347395043862792421
 0.0124834988872684315
0.00530894371222345902];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697761598043851849
0.681575945185670995
0.787917107828843943];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -12.9920245983972951-699.381145156678599*%i -12.2097820412575189-649.539559081750667*%i -10.1344510872378937-521.417272604113464*%i 
9.58584235807003572e-05-2.02853533143100052e-06*%i 0.000101411337448143222-2.15894410503202928e-06*%i 0.000120002619352898429-2.60005582256290754e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000673690591289388989-0.472540114151826285*%i 0.000528666498849810103-0.438866355902376937*%i 0.000199436595836125874-0.352304055696368024*%i 
 0.426383961685526058-0.000494020086533254049*%i 0.451084799584356266-0.000579989976442809359*%i 0.533784166806502203-0.000887827712164818541*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[16.5260271367940526
13840394.5854787864
 282344049543783.75];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[16.5260287893968467
13840395.9695183132
282344077778190.062];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[0.421086004368149025
0.610465096726545031
 1.666434801690301];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.14463043389236563
1.65941617934026064
4.52983943974649783];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[ 0.0347415281841635393 0.0403909795851394096 0.0622073943020583359
 0.011160178106655122 0.0125399754302181927 0.0175555655760664016
0.00369123367515400772 0.00405955167518800598 0.00534753075863071432];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697802247110982043 0.81127451182103727 1.24946891514928726
0.609325078663767949 0.684659459950995308 0.958501403238775529
0.547827650715420389 0.602490888654808932 0.793643933286582448];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.000307761655715720745-699.482513886584456*%i -0.000329045760543045782-647.722648212824652*%i 0.00039971416962090062-518.475088906562405*%i 
9.58821756624346456e-05+0*%i 0.000101665303700313836+0*%i 0.000120572320846796583+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.07904931953827651e-07-0.472527560700454485*%i -2.22283170059975929e-07-0.437561764439004852*%i 2.70022420573327402e-07-0.350250026528458713*%i 
 0.426394435085529488+0*%i 0.452112391480472775+0*%i 0.536193158730787101+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[ 0.0347415281841635393
 0.0125399754302181927
0.00534753075863071432];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697802247110982043
0.684659459950995308
0.793643933286582448];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -12.9917021581712788-699.360411772403722*%i -12.1791719472128612-647.607269472064104*%i -10.0840517737974746-518.377263453129899*%i 
9.58605847858665479e-05-2.0285859563972354e-06*%i 0.000101642094906378831-2.16437759701476455e-06*%i 0.000120543702111019878-2.6129898426369006e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000673628263176204037-0.47252610639182796*%i 0.000523235678055050842-0.437560866866200215*%i 0.00019240633416578646-0.350250141464640508*%i 
 0.426393575289366777-0.000494052966454036624*%i 0.452111271401550496-0.000583625737348904641*%i 0.536191067010032829-0.000897213244859404024*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[9999999.99999916367];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[10000000.999999214];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[0.601907230197234577];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.63615348626325807];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[0.0401564311281941769 0.0124834988872684315 0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.80656348012878698 0.681575945185670995 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[ 0.0401564311281941769
 0.0124834988872684315
0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 0.80656348012878698
0.681575945185670995
 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 
0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 
 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-12.2097820412575189-649.539559081750667*%i 0.000101411337448143222-2.15894410503202928e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000528666498849810103-0.438866355902376937*%i 0.451084799584356266-0.000579989976442809359*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[9999999.99999916367
39633272976.0599136];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[10000000.999999214
39633276939.387413];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[0.601907230197234577
0.922137008895789201];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.63615348626325807
2.50662827463100069];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[ 0.0401564311281941769 0.048034646842352785
 0.0124834988872684315 0.0143470307207600699
0.00404461344545216286 0.00453193604957145835];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 0.80656348012878698 0.964801672744356908
0.681575945185670995 0.78332133582218777
 0.60027385878831252 0.672598945967751494];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i -2.18157694632340212e-20-592.605824499197752*%i 
0.000101434481315590741+0*%i 0.000108816615756422952+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i -1.47373981831043786e-23-0.400328212854926313*%i 
 0.451085908928745838+0*%i 0.4839147535276207+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 
0.000108816615756422952+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 
 0.4839147535276207+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -12.2097820412575189-649.539559081750667*%i -11.2973471089096531-592.497779249315954*%i 
0.000101411337448143222-2.15894410503202928e-06*%i 0.000108791381564593244-2.33325451860173617e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000528666498849810103-0.438866355902376937*%i 0.000374301098459614058-0.400327801467721511*%i 
 0.451084799584356266-0.000579989976442809359*%i 0.483913287047555762-0.000698657774352147171*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[0];
yref=[%inf
%inf
%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[7.99999999999999056e+21
 199999999999999.5
 9999999.99999916367
 16.234027166616773
 9999999.99999916367];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[8.00000080000003028e+21
 200000020000000.5
 10000000.999999214
 16.2340287900195683
 10000000.999999214];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[1];
yref=[ 7.1012628247379439
 1.62483889863517739
0.601907230197234577
0.421024438240708343
0.601907230197234577];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[19.3032336955969015
4.41677005233341102
1.63615348626325807
1.14446307980689488
1.63615348626325807];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[3 4 5];
yref=[ 0.122170375757183536 0.0615104584717420244 0.0401564311281941769 0.0347395043862792421 0.0401564311281941769
 0.0298849244167556718 0.0174014255294872404 0.0124834988872684315 0.0111596760858530247 0.0124834988872684315
0.00829176841523093094 0.00530894371222345902 0.00404461344545216286 0.00369109833404259336 0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.45385759319062213 1.2354705847963765 0.80656348012878698 0.697761598043851849 0.80656348012878698
1.63166158703520159 0.950085641849530704 0.681575945185670995 0.609297669256695262 0.681575945185670995
1.23060754505138759 0.787917107828843943 0.60027385878831252 0.547807564313518958 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.000547174002707648331-363.893259245845741*%i 0.000398455910810062441-521.515526255766758*%i -0.00032884199678432643-649.655191440786325*%i 0.000308362213060931921-699.503249938174008*%i -0.00032884199678432643-649.655191440786325*%i 
 0.000158592138856474539+0*%i 0.00012003108083585597+0*%i 0.000101434481315590741+0*%i 9.58800138559534094e-05+0*%i 0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-3.69637255607037082e-07-0.245824006652234722*%i 2.69172417957376988e-07-0.352303959851393844*%i -2.22145519739981785e-07-0.438867272324231283*%i 2.08310631727244942e-07-0.472541568707347648*%i -2.22145519739981785e-07-0.438867272324231283*%i 
 0.705269827155226015+0*%i 0.533786228275608399+0*%i 0.451085908928745838+0*%i 0.426384821387811808+0*%i 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -7.4394558673309259-363.818395117376156*%i -10.1344510872378937-521.417272604113464*%i -12.2097820412575189-649.539559081750667*%i -12.9920245983972951-699.381145156678599*%i -12.2097820412575189-649.539559081750667*%i 
0.000158552170065185956-3.53311552676922989e-06*%i 0.000120002619352898429-2.60005582256290754e-06*%i 0.000101411337448143222-2.15894410503202928e-06*%i 9.58584235807003572e-05-2.02853533143100052e-06*%i 0.000101411337448143222-2.15894410503202928e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-0.000109494840793429989-0.24582478609981806*%i 0.000199436595836125874-0.352304055696368024*%i 0.000528666498849810103-0.438866355902376937*%i 0.000673690591289388989-0.472540114151826285*%i 0.000528666498849810103-0.438866355902376937*%i 
 0.705265288619020159-0.00160795671803239896*%i 0.533784166806502203-0.000887827712164818541*%i 0.451084799584356266-0.000579989976442809359*%i 0.426383961685526058-0.000494020086533254049*%i 0.451084799584356266-0.000579989976442809359*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[%inf
%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[1391006872.97331595
231.820520515120165
83749.8825951008039
1172498356563.23169];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1391007012.07401013
231.820543697173349
83749.8909700894728
1172498473813.07324];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[0.763646889504661752
 0.43507602420880509
0.502601274979380563
 1.13871780917993615];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.07580746309979425
1.18265925060500243
1.36621191273679798
3.09535592843651486];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[ 0.0443421088885961254 0.0351976322831403024 0.0373025824319680663 0.0526055040847253977
 0.0134818491452645944 0.0112731687602682217 0.0117908738312243588 0.0153999746011967472
0.00430707882416860813 0.00372166932887342495 0.00386047850470379794 0.00480260331019048865];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.890635065333905684 0.706963342831796848 0.749242396767546337 1.05660979465665172
0.736084022357373691 0.61549415932207896 0.643759898459061786 0.840810123782750551
0.639227174798674413 0.552344702233271256 0.572945810530681943 0.712769529181862205];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.000202039933371823646-617.4753218485356*%i 0.000182303857757894639-694.85412883218396*%i -0.000187056054651996666-674.586620108726265*%i 0.00021817762166375702-565.48135237298743*%i 
 0.000105447291803287651+0*%i 9.63676106687086419e-05+0*%i 9.85638910412370219e-05+0*%i 0.000112794925842248141+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-1.36485809130247718e-07-0.417128522633984811*%i 1.23153324782880659e-07-0.469400907129679523*%i -1.26363618052202399e-07-0.45570941911040358*%i 1.47387443313440241e-07-0.382004580177006337*%i 
 0.468931145013404105+0*%i 0.42855319696010008+0*%i 0.438320202373396861+0*%i 0.501606564022332835+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -11.6973470619133586-617.363942587298084*%i -12.9196695714012666-694.732622548455197*%i -12.6027889661243577-674.467734692398381*%i -10.8570953242124073-565.376995143766976*%i 
0.000105423015175112696-2.25356064547544274e-06*%i 9.63458846993802559e-05-2.03995644112665241e-06*%i 9.85415522099426799e-05-2.09146503547789611e-06*%i 0.000112768553688897494-2.42763553987181895e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000440078414964279569-0.417127903442599313*%i 0.000659758483747528994-0.46939950740576919*%i 0.000600004710276078089-0.455708246718983245*%i 0.000305250372583931013-0.382004376550384939*%i 
 0.468929845046064608-0.000643891710835903762*%i 0.428552316018253054-0.000501447813605265108*%i 0.438319224140312547-0.000535191579136117934*%i 0.501604893533769691-0.000764581118498229096*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[%inf
%inf
%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 36166178697306312
1391006872.97331595
231.820520515120165
83749.8825951008039
1172498356563.23169];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 36166182313924360
1391007012.07401013
231.820543697173349
83749.8909700894728
1172498473813.07324];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 2.42055793692092536
0.763646889504661752
 0.43507602420880509
0.502601274979380563
 1.13871780917993615];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[6.57975865466446574
2.07580746309979425
1.18265925060500243
1.36621191273679798
3.09535592843651486];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[ 0.0736274599865902601 0.0443421088885961254 0.0351976322831403024 0.0373025824319680663 0.0526055040847253977
 0.0200363707046902068 0.0134818491452645944 0.0112731687602682217 0.0117908738312243588 0.0153999746011967472
0.00596135031744110186 0.00430707882416860813 0.00372166932887342495 0.00386047850470379794 0.00480260331019048865];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 1.47884706612118144 0.890635065333905684 0.706963342831796848 0.749242396767546337 1.05660979465665172
 1.09394877385437184 0.736084022357373691 0.61549415932207896 0.643759898459061786 0.840810123782750551
0.884742833128581818 0.639227174798674413 0.552344702233271256 0.572945810530681943 0.712769529181862205];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.000254263286082106045-474.93141146147201*%i -0.000202039933371823646-617.4753218485356*%i 0.000182303857757894639-694.85412883218396*%i -0.000187056054651996666-674.586620108726265*%i 0.00021817762166375702-565.48135237298743*%i 
0.000129006058131630997+0*%i 0.000105447291803287651+0*%i 9.63676106687086419e-05+0*%i 9.85638910412370219e-05+0*%i 0.000112794925842248141+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.71764708856667764e-07-0.320834583999766498*%i -1.36485809130247718e-07-0.417128522633984811*%i 1.23153324782880659e-07-0.469400907129679523*%i -1.26363618052202399e-07-0.45570941911040358*%i 1.47387443313440241e-07-0.382004580177006337*%i 
 0.573698551369010823+0*%i 0.468931145013404105+0*%i 0.42855319696010008+0*%i 0.438320202373396861+0*%i 0.501606564022332835+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -9.35593722522677851-474.839810853399911*%i -11.6973470619133586-617.363942587298084*%i -12.9196695714012666-694.732622548455197*%i -12.6027889661243577-674.467734692398381*%i -10.8570953242124073-565.376995143766976*%i 
0.000128974972208392366-2.81517542070003286e-06*%i 0.000105423015175112696-2.25356064547544274e-06*%i 9.63458846993802559e-05-2.03995644112665241e-06*%i 9.85415522099426799e-05-2.09146503547789611e-06*%i 0.000112768553688897494-2.42763553987181895e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[9.59920399783527394e-05-0.320834949375373546*%i 0.000440078414964279569-0.417127903442599313*%i 0.000659758483747528994-0.46939950740576919*%i 0.000600004710276078089-0.455708246718983245*%i 0.000305250372583931013-0.382004376550384939*%i 
 0.573695970723117288-0.00104632775911367567*%i 0.468929845046064608-0.000643891710835903762*%i 0.428552316018253054-0.000501447813605265108*%i 0.438319224140312547-0.000535191579136117934*%i 0.501604893533769691-0.000764581118498229096*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
