/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2004-2006 - INRIA - Fabrice Leray
 * Copyright (C) 2006 - INRIA - Allan Cornet
 * Copyright (C) 2006 - INRIA - Jean-Baptiste Silvy
 * Copyright (C) 2010 - DIGITEO - Manuel Juliachs
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

/*------------------------------------------------------------------------*/
/* file: set_z_shift_property.c                                           */
/* desc : function to modify in Scilab the z_shift field of               */
/*        a handle                                                        */
/*------------------------------------------------------------------------*/

#include "setHandleProperty.h"
#include "SetProperty.h"
#include "getPropertyAssignedValue.h"
#include "Scierror.h"
#include "localization.h"
#include "GetProperty.h"
#include "MALLOC.h"
#include "SetPropertyStatus.h"

#include "getGraphicObjectProperty.h"
#include "setGraphicObjectProperty.h"
#include "graphicObjectProperties.h"

/*------------------------------------------------------------------------*/
int set_z_shift_property(void* _pvCtx, char * pobjUID, size_t stackPointer, int valueType, int nbRow, int nbCol )
{
    BOOL result = FALSE;
    double* shiftCoordinates = NULL;
    int nbElement = nbRow * nbCol;
    int iNumElements = 0;
    int* piNumElements = &iNumElements;

    if ( !( valueType == sci_matrix ) )
    {
        Scierror(999, _("Wrong type for '%s' property: Real matrix expected.\n"), "z_shift");
        return SET_PROPERTY_ERROR;
    }

    if ( nbRow > 1 && nbCol > 1 )
    {
        Scierror(999, _("Wrong size for '%s' property: Must be in the set {%s}.\n"), "z_shift", "0x0, 1xn, nx1");
        return SET_PROPERTY_ERROR;
    }

    getGraphicObjectProperty(pobjUID, __GO_DATA_MODEL_NUM_ELEMENTS__, jni_int, (void**)&piNumElements);

    if (piNumElements == NULL)
    {
        Scierror(999, _("'%s' property does not exist for this handle.\n"), "z_shift");
        return SET_PROPERTY_ERROR;
    }

    if ( nbElement != 0 && nbElement != iNumElements) /* we can specify [] (null vector) to reset to default */
    {
        Scierror(999, _("Wrong size for '%s' property: %d or %d elements expected.\n"), "z_shift", 0, iNumElements);
        return SET_PROPERTY_ERROR;
    }

    if ( nbElement != 0 )
    {
        shiftCoordinates = (double*) stk(stackPointer);

        result = setGraphicObjectProperty(pobjUID, __GO_DATA_MODEL_Z_COORDINATES_SHIFT__, shiftCoordinates, jni_double_vector, iNumElements);

        /* The FALSE value is used for now to identify a failed memory allocation */
        if (result == FALSE)
        {
            Scierror(999, _("%s: No more memory.\n"), "set_z_shift_property");
            return SET_PROPERTY_ERROR;
        }
    }
    else
    {
        /*
         * Setting the shift flag to 0 directly in the model
         * when filling the shift coordinates array (0-element case)
         * would probably be better.
         */
        int shiftSet = 0;
        setGraphicObjectProperty(pobjUID, __GO_DATA_MODEL_Z_COORDINATES_SHIFT_SET__, &shiftSet, jni_double_vector, 1);
    }

    return SET_PROPERTY_SUCCEED;
}
/*------------------------------------------------------------------------*/
