// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - INRIA - Serge Steer
// Copyright (C) 2012 - Scilab Enterprises - Cedric Delamarre
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

//cumprod
//Empty matrices
T=list(list(),list('native'),list('double'));
for typ=T
  assert_checkequal(cumprod([],typ(:)), []);
  assert_checkequal(cumprod([],'*',typ(:)), []);
  assert_checkequal(cumprod([],1,typ(:)), []);
  assert_checkequal(cumprod([],2,typ(:)), []);
  assert_checkequal(cumprod([],3,typ(:)), []);
end

//=======================================================================
//float matrices
d=[1 10;254 9];
T=list(list(),list('native'),list('double'));
for typ=T
  assert_checkequal(cumprod(d,typ(:)), [1,2540;254,22860]);
  assert_checkequal(cumprod(d,'*',typ(:)), [1,2540;254,22860]);
  assert_checkequal(cumprod(d,1,typ(:)), [1,10;254,90]);
  assert_checkequal(cumprod(d,2,typ(:)), [1,10;254,2286]);
  assert_checkequal(cumprod(d,3,typ(:)), d);
end

//hypermatrices of floats
d=[1 10;254 9];d(1,1,2)=1;
T=list(list(),list('native'),list('double'));
for typ=T
  assert_checkequal(cumprod(d,typ(:)), hypermat([2,2,2],[1;254;2540;22860;22860;0;0;0]));
  assert_checkequal(cumprod(d,'*',typ(:)), hypermat([2,2,2],[1;254;2540;22860;22860;0;0;0]));
  assert_checkequal(cumprod(d,1,typ(:)), hypermat([2,2,2],[1;254;10;90;1;0;0;0]));
  assert_checkequal(cumprod(d,2,typ(:)), hypermat([2,2,2],[1;254;10;2286;1;0;0;0]));
  assert_checkequal(cumprod(d,3,typ(:)), hypermat([2,2,2],[1;254;10;9;1;0;0;0]));
  assert_checkequal(cumprod(d,5,typ(:)), d);
end

//=======================================================================
//Integers
i=uint8([1 10;254 9]);
for typ=list(list(),list('native'));
  assert_checkequal(cumprod(i,typ(:)), uint8([1,236;254,76]));
  assert_checkequal(cumprod(i,'*',typ(:)), uint8([1,236;254,76]));
  assert_checkequal(cumprod(i,1,typ(:)), uint8([1,10;254,90]));
  assert_checkequal(cumprod(i,2,typ(:)), uint8([1,10;254,238]));
  assert_checkequal(cumprod(i,3,typ(:)), double(i));
end

assert_checkequal(cumprod(i,'double'), [1,2540;254,22860]);
assert_checkequal(cumprod(i,'*','double'), [1,2540;254,22860]);
assert_checkequal(cumprod(i,1,'double'), [1,10;254,90]);
assert_checkequal(cumprod(i,2,'double'), [1,10;254,2286]);
assert_checkequal(cumprod(i,3,'double'), double(i));

//with hypermatrices
i=uint8([1 10;254 9]);i(1,1,2)=uint8(1);
for typ=list(list(),list('native'));
  assert_checkequal(cumprod(i,typ(:)), hypermat([2,2,2],uint8([1;254;236;76;76;0;0;0])));
  assert_checkequal(cumprod(i,'*',typ(:)), hypermat([2,2,2],uint8([1;254;236;76;76;0;0;0])));
  assert_checkequal(cumprod(i,1,typ(:)), hypermat([2,2,2],uint8([1;254;10;90;1;0;0;0])));
  assert_checkequal(cumprod(i,2,typ(:)), hypermat([2,2,2],uint8([1;254;10;238;1;0;0;0])));
  assert_checkequal(cumprod(i,3,typ(:)), hypermat([2,2,2],uint8([1;254;10;9;1;0;0;0])));
  assert_checkequal(cumprod(i,5,typ(:)), double(i));
end


assert_checkequal(cumprod(i,'double'), hypermat([2,2,2],[1;254;2540;22860;22860;0;0;0]));
assert_checkequal(cumprod(i,'*','double'), hypermat([2,2,2],[1;254;2540;22860;22860;0;0;0]));
assert_checkequal(cumprod(i,1,'double'), hypermat([2,2,2],[1;254;10;90;1;0;0;0]));
assert_checkequal(cumprod(i,2,'double'), hypermat([2,2,2],[1;254;10;2286;1;0;0;0]));
assert_checkequal(cumprod(i,3,'double'), hypermat([2,2,2],[1;254;10;9;1;0;0;0]));
assert_checkequal(cumprod(i,5,'double'), double(i));

//=======================================================================
//Matrices of Polynomials
s=%s;p=[s s+1;s^2 0];
T=list(list(),list('native'),list('double'));
for typ=T
  assert_checkequal(cumprod(p,typ(:)), [s,s^3+s^4;s^3,0*s]);
  assert_checkequal(cumprod(p,'*',typ(:)), [s,s^3+s^4;s^3,0*s]);
  assert_checkequal(cumprod(p,1,typ(:)), [s,1+s;s^3,0*s]);
  assert_checkequal(cumprod(p,2,typ(:)), [s,s+s^2;s^2,0*s]);
  assert_checkequal(cumprod(p,3,typ(:)), p);
end

//with hypermatrices
s=%s;p=[s s+1;s^2 0];p(1,1,2)=-1;
T=list(list(),list('native'),list('double'));
for typ=T
  assert_checkequal(cumprod(p,typ(:)), hypermat([2,2,2],[s;s^3;s^3+s^4;0*s;0*s;0*s;0*s;0*s]));
  assert_checkequal(cumprod(p,'*',typ(:)), hypermat([2,2,2],[s;s^3;s^3+s^4;0*s;0*s;0*s;0*s;0*s]));
  assert_checkequal(cumprod(p,1,typ(:)), hypermat([2,2,2],[s;s^3;1+s;0*s;-1;0*s;0*s;0*s]));
  assert_checkequal(cumprod(p,2,typ(:)), hypermat([2,2,2],[s;s^2;s+s^2;0*s;-1;0*s;0*s;0*s]));
  assert_checkequal(cumprod(p,3,typ(:)), hypermat([2,2,2],[s;s^2;1+s;0*s;-s;0*s;0*s;0*s]));
  assert_checkequal(cumprod(p,5,typ(:)), p);
end
//=======================================================================
//Matrices of rationals
s=%s;r=1.0 ./[s s+1;s^2 1];
T=list(list(),list('native'),list('double'));
for typ=T
  assert_checkequal(cumprod(r,typ(:)), [1,1;1,1]./[s,s^3+s^4;s^3,s^3+s^4]);
  assert_checkequal(cumprod(r,'*',typ(:)), [1,1;1,1]./[s,s^3+s^4;s^3,s^3+s^4]);
  assert_checkequal(cumprod(r,1,typ(:)), [1,1;1,1]./[s,1+s;s^3,1+s]);
  assert_checkequal(cumprod(r,2,typ(:)), [1,1;1,1]./[s,s+s^2;s^2,s^2]);
  assert_checkequal(cumprod(r,3,typ(:)), r);
end

//=======================================================================
///Matrices of boolean

b=[%t %t;%f %t];
for typ=list(list(),list('double'));
  assert_checkequal(cumprod(b,typ(:)), [1,0;0,0]);
  assert_checkequal(cumprod(b,'*',typ(:)), [1,0;0,0]);
  assert_checkequal(cumprod(b,1,typ(:)), [1,1;0,1]);
  assert_checkequal(cumprod(b,2,typ(:)), [1,1;0,0]);
  assert_checkequal(cumprod(b,3,typ(:)), double(b));
end
assert_checkequal(cumprod(b,'native'), [%t,%f;%f,%f]);
assert_checkequal(cumprod(b,'*','native'), [%t,%f;%f,%f]);
assert_checkequal(cumprod(b,1,'native'), [%t,%t;%f,%t]);
assert_checkequal(cumprod(b,2,'native'), [%t,%t;%f,%f]);
assert_checkequal(cumprod(b,3,'native'), b);

//with hypermatrices
b=[%t %t;%f %t];b(1,1,2)=%f;
for typ=list(list(),list('double'));
  assert_checkequal(cumprod(b,typ(:)), hypermat([2,2,2],[1;0;0;0;0;0;0;0]));
  assert_checkequal(cumprod(b,'*',typ(:)), hypermat([2,2,2],[1;0;0;0;0;0;0;0]));
  assert_checkequal(cumprod(b,1,typ(:)), hypermat([2,2,2],[1;0;1;1;0;0;0;0]));
  assert_checkequal(cumprod(b,2,typ(:)), hypermat([2,2,2],[1;0;1;0;0;0;0;0]));
  assert_checkequal(cumprod(b,3,typ(:)), hypermat([2,2,2],[1;0;1;1;0;0;0;0]));
  assert_checkequal(cumprod(b,5,typ(:)), double(b));
end

assert_checkequal(cumprod(b,'native'), hypermat([2,2,2],[%t;%f;%f;%f;%f;%f;%f;%f]));
assert_checkequal(cumprod(b,'*','native'), hypermat([2,2,2],[%t;%f;%f;%f;%f;%f;%f;%f]));
assert_checkequal(cumprod(b,1,'native'), hypermat([2,2,2],[%t;%f;%t;%t;%f;%f;%f;%f]));
assert_checkequal(cumprod(b,2,'native'), hypermat([2,2,2],[%t;%f;%t;%f;%f;%f;%f;%f]));
assert_checkequal(cumprod(b,3,'native'), hypermat([2,2,2],[%t;%f;%t;%t;%f;%f;%f;%f]));
assert_checkequal(cumprod(b,5,'native'), b);

//=======================================================================
//sparse matrices of floats
s=sparse([1 10 0;-1 0 9]);
T=list(list(),list('native'),list('double'));
for typ=T
  assert_checkequal(cumprod(s,typ(:)), sparse([1,1;1,2;2,1],[1;-10;-1],[2,3]));
  assert_checkequal(cumprod(s,'*',typ(:)), sparse([1,1;1,2;2,1],[1;-10;-1],[2,3]));
  assert_checkequal(cumprod(s,1,typ(:)), sparse([1,1;1,2;2,1],[1;10;-1],[2,3]));
  assert_checkequal(cumprod(s,2,typ(:)), sparse([1,1;1,2;2,1],[1;10;-1],[2,3]));
  assert_checkequal(cumprod(s,3,typ(:)), s);
end

//=======================================================================
//sparse  matrices of boolean
bs=sparse([%t %t %f;%t %t %t]);
for typ=list(list(),list('double'));
  assert_checkequal(cumprod(bs,typ(:)), sparse([1,1;1,2;2,1;2,2],[1;1;1;1],[2,3]));
  assert_checkequal(cumprod(bs,'*',typ(:)), sparse([1,1;1,2;2,1;2,2],[1;1;1;1],[2,3]));
  assert_checkequal(cumprod(bs,1,typ(:)), sparse([1,1;1,2;2,1;2,2],[1;1;1;1],[2,3]));
  assert_checkequal(cumprod(bs,2,typ(:)), sparse([1,1;1,2;2,1;2,2;2,3],[1;1;1;1;1],[2,3]));
  assert_checkequal(cumprod(bs,3,typ(:)), bool2s(bs));
end

assert_checkequal(cumprod(bs,'native'), sparse([1,1;1,2;2,1;2,2],[%t;%t;%t;%t],[2,3]));
assert_checkequal(cumprod(bs,'*','native'), sparse([1,1;1,2;2,1;2,2],[%t;%t;%t;%t],[2,3]));

assert_checkequal(cumprod(bs,1,'native'), sparse([1,1;1,2;2,1;2,2],[%t;%t;%t;%t],[2,3]));
assert_checkequal(cumprod(bs,2,'native'), sparse([1,1;1,2;2,1;2,2;2,3],[%t;%t;%t;%t;%t],[2,3]));
assert_checkequal(cumprod(bs,3,'native'), bs);

// TODO : test the "m" option
