/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_fetch_lengths(char * fname)
{
  int * sql_res_pointer_in = NULL;
  int m_lengths_out, n_lengths_out;
  MYSQL_RES   * mysql_res_ptr   = NULL;
  unsigned long * lengths = NULL;
  double * dlengths = NULL;
  unsigned int num_fields = 0;
  int i;
  void * ptr_in = NULL;
  SciErr _SciErr;

  CheckRhs(1,1);
  CheckLhs(1,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_res_pointer_in);
  getPointer(pvApiCtx, sql_res_pointer_in, &ptr_in);
  mysql_res_ptr = (MYSQL_RES *)ptr_in;

  if (mysql_res_ptr==NULL)
    {
      Scierror(999,"%s: problem with the mysql_res pointer\n", fname);
      return 0;
    }

  lengths = mysql_fetch_lengths(mysql_res_ptr);
  if (lengths)
    {
      num_fields = mysql_num_fields(mysql_res_ptr);
      
      m_lengths_out = num_fields;
      n_lengths_out = 1;

      dlengths = (double *)MALLOC(num_fields*sizeof(double));
      for(i=0;i<(int)num_fields;i++)
	dlengths[i] = (double)lengths[i];

      _SciErr = createMatrixOfDouble(pvApiCtx,Rhs+1, m_lengths_out, n_lengths_out, dlengths);

      FREE(dlengths);
    }
  else
    {
      createEmptyMatrix(pvApiCtx, Rhs+1);
    }

  LhsVar(1) = Rhs+1;
      
  return 0;
}
