// ==========================================================
// Definition of CelestLab Physical data.  
// 
// Syntax: 
// data.name = value
// (scilab syntax)
// 
// Warning: 
// Most names are used in CelestLab, and consequently
// should not be changed. 
// ==========================================================

// ----------------------------------------------------------
// Default values for some quantities (Earth)
// ----------------------------------------------------------

// Equatorial radius - Earth - JGM3 Potential [m]
data.eqRad = 6378136.3 
data.earthRadius = data.eqRad  // for compatibility

// Oblateness - Earth - JGM3 Potential
data.obla = 1/298.25781000000 

// Gravitational constant (m^3/s^2) - Earth - JGM3 Potential
data.mu = 3.986004415e14 

// Potential harmonics - J1 to J70 (Earth - JGM3 Potential) 
data.j1jn = [ 0.
          0.00108262669059782
          -2.53243547943241e-06
          -1.61933127174051e-06
          -2.27716112895682e-07
          5.39648498594285e-07
          -3.51368443669702e-07
          -2.02518718143151e-07
          -1.19368714898869e-07
          -2.48056865754093e-07
          2.40565216215095e-07
          -1.81911694596695e-07
          -2.07567730643349e-07
          1.17417389371202e-07
          -1.76272694689137e-08
          3.11943094249257e-08
          -1.07130592684284e-07
          -4.42167249859155e-08
          2.19733398304135e-08
          -1.20314617695259e-07
          -4.92459305790164e-08
          7.55354073197852e-08
          1.57100136082411e-07
          4.26855017998661e-09
          -3.45975500825326e-08
          -5.79992158190519e-08
          -2.49739104998735e-08
          6.15584743530392e-08
          1.5116059801076e-08
          -1.03392057692495e-07
          -4.4735692916947e-08
          2.07584858547697e-08
          6.6397264033699e-09
          6.88679451544847e-08
          -5.77565952474551e-08
          4.31634924417224e-08
          5.95461741021507e-08
          8.22864852043474e-08
          -9.01023120106021e-09
          3.43879724695743e-08
          8.68557607744411e-09
          -2.24712519709114e-09
          -5.98908001617914e-08
          -3.20822040439335e-08
          4.40317791662939e-08
          -2.17993398739857e-08
          1.7212653356465e-09
          -8.68697322129902e-08
          9.90633841472856e-09
          1.30428365947208e-08
          7.33807737493882e-08
          -3.11627077052876e-08
          -5.17067907327928e-08
          -1.8361593860458e-08
          -2.41368628455192e-08
          3.15082802134974e-08
          2.22744022003168e-08
          4.92129929178496e-08
          -2.39564694291193e-09
          4.61046978372794e-08
          -9.41548851112535e-09
          -7.93909519203522e-09
          2.73656964065564e-08
          3.36767136008911e-08
          1.78321140940191e-10
          1.28436129062281e-08
          2.66227214973719e-10
          -5.38782109805533e-09
          -1.63849001673196e-08
          1.29765521503902e-08 ]

// Potential harmonics 1 to 6
data.j2 = data.j1jn(2)     // 2nd zonal harmonic 
data.j3 = data.j1jn(3)     // 3rd zonal harmonic 
data.j4 = data.j1jn(4)     // 4th zonal harmonic
data.j5 = data.j1jn(5)     // 5th zonal harmonic 
data.j6 = data.j1jn(6)     // 6th zonal harmonic 


// ----------------------------------------------------------
// Other data
// ----------------------------------------------------------

// Speed of light - UAI 1976 [m/s]
data.lightSpeed = 299792458  

// astronomical unit DE 200 [m]
data.au = 1.4959787066E+11 

// Universal gravitational constant [m^3.s^-2.kg^-1]
data.gravCst = 6672e-14 

// Sun geocentric gravitational constant DE 200 [m^3/s^2]
data.muSun = 1.32712440e20 

// Equatorial Sun radius UAI 1976, DE 200 [m]
data.radiusSun = 696000000 

// Moon geocentric gravitational constant [m^3/s^2]
data.muMoon = 49027989e5  

// Moon Equatorial radius UAI 1976, DE 200 [m]
data.radiusMoon = 1737400 

// Earth mean pole obliquity at J2000 epoch 
// (23deg, 26', 21.41119'') IERS1992 [rad]
data.obliquity2000 = 0.40909262920459006 

// Angular rotation rate of the Earth [rad/s]
data.rotrEarth = 0.729211514670520957673456605920873977E-4 

// Earth-Sun inertial rotation period, consistent with %CL_rotrEarth [rad/s]  
// 86400 = 2*%pi / (rotrEarth - rotrEarthSun)
data.rotrEarthSun = 0.1990993006216967288585452383952014E-6 


