//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function W=CL_mod_polarMotionMatrix(xp,yp)
// Polar motion matrix
//
// Calling Sequence
// W=CL_mod_polarMotionMatrix(xp,yp)
//
// Description
// <itemizedlist><listitem>
// Builds polar motion matrix from polar coordinates <emphasis role="bold">xp</emphasis>, <emphasis role="bold">yp</emphasis>
// </listitem>
// </itemizedlist>
// <para><emphasis role="bold">( Last updated: 2010-06-03 )</emphasis></para>
//
// Parameters
// xp : x polar coordinate [rad] (1xN)
// yp : y polar coordinate [rad] (1xN)
// W: polar motion matrix (3x3xN)
//
// Authors
// CNES - DCT/SB
//
// See also
// CL_mod_precessionMatrix
// CL_mod_nutationMatrix
//

// Declarations:


// Code:

[lhs,rhs]=argn(0);
if rhs~=2 CL__error("check number of input arguments"); end,

W=CL_rot_angles2matrix(1,yp)*CL_rot_angles2matrix(2,xp);

endfunction
