#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2008 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Upgrade scholtool.intervention to generation 5.

Evolution script to create schooltool intervention catalog.
"""
from zope.app.generations.utility import findObjectsProviding
from zope.app.generations.utility import getRootFolder
from zope.component.hooks import getSite, setSite
from zope.component import getUtility
from zope.catalog.interfaces import ICatalog

from schooltool.app.interfaces import ISchoolToolApplication
from schooltool.app.interfaces import CatalogSetUpEvent
from schooltool.intervention.catalog import catalogSetUpSubscriber
from schooltool.intervention.catalog import INTERVENTION_CATALOG_KEY


def evolve(context):
    root = getRootFolder(context)

    old_site = getSite()
    apps = findObjectsProviding(root, ISchoolToolApplication)
    for app in apps:
        setSite(app)
        # register schooltool intervention catalog
        catalogSetUpSubscriber(CatalogSetUpEvent(app))
        util = getUtility(ICatalog, INTERVENTION_CATALOG_KEY)
        util.updateIndexes()

    setSite(old_site)

