module Schleuder
  # Parent-class for plugins. Sets up stub and helper methods.
  class Plugin
    # Define whether this plugin should be used for emails sent to the
    # list-address or the request-address.
    attr_reader :plugin_type

    def Plugin.signing_key(mail)
      @@key ||= mail.crypt.get_key(mail.in_signed.fpr).first
    end
  
    # Helper: creates a reply to the sender of the incoming message. The
    # destination address is detemined by finding the list-member connected to
    # the key that signed the incoming message. +msg+ is used as body for the
    # outgoing mail.
    def Plugin.reply(mail, msg, keywords)
      Schleuder.log.info "Building reply mail"
      out = Mail.new

      out.subject = "Re: #{mail.subject}"
      key = Plugin.signing_key(mail)
      Schleuder.log.debug "Looking up member by key: #{key.inspect}"
      member = Schleuder.list.find_member_by_key(key) || Schleuder.list.find_admin_by_key(key)
      Schleuder.log.debug { "Result: #{member.inspect}" }
      if member
        Schleuder.log.info { "Found member for key: %s" % member.inspect }
      else
        Schleuder.log.error "No member or admin found for signing key, aborting reply."
        return false
      end

      imail = out.individualize(member)
      imail.in_reply_to = mail.message_id
      imail.body = msg

      unless imail.encrypt!(member)
        Schleuder.log.debug 'encrypting failed, replacing body with please-fix-message'
        imail.body = "Encrypting to #{imail.to} failed. Please fix."
      end

      Schleuder.log.info "Sending to #{imail.to}"
      Mailer.send(imail)

      unless (Schleuder.list.config.keywords_admin_notify & keywords).empty?
        Schleuder.log.info "Sending notification to admins"
        msg = "Hello list-admin,\n\nmember #{member.email} sent the keyword(s) '#{keywords.join("','")}' and received the following reply-message:\n\n\n".fmt << msg
        Schleuder.log.notify_admin 'Notice', msg
      end

      Schleuder.log.info "Exiting"
      exit 0
    end
  end
end
