module Schleuder
  class ManageMembersPlugin < Plugin
    def match(mail)
      mail.keywords.keys.include?('X-GET-MEMBERS') || mail.keywords.keys.include?('X-SAVE-MEMBERS')
    end
    
    def _get_membersfile
        File.read("#{Schleuder.config.lists_dir}/#{Schleuder.list.listname}/#{Schleuder.config.lists_memberfile}")
    end

    def process(mail)
      if mail.keywords.keys.include?('X-GET-MEMBERS')
        Schleuder.log.debug 'GET-MEMBERS requested'
        msg = _get_membersfile
      elsif mail.keywords.keys.include?('X-SAVE-MEMBERS')
        Schleuder.log.debug 'SAVE-MEMBERS requested'
        if mail.body.strip.empty?
          msg = "Error, empty input. You need to write the members list yaml-formatted into the body."
        else
          Schleuder.list.members = YAML.load(mail.body)
          msg = "Saving was successful.\n\nCurrent members.conf:\n\n#{_get_membersfile}\n"
        end
      end
      reply(mail, msg)
    end
  end
end

