# the list config class - a simple container

module Schleuder
  class ListConfig < Storage
    # Emailaddress of the list
    attr_accessor :myaddr
    # Realname of this list address (mainly used for gpg key)
    attr_accessor :myname
    # Listadmin's emailaddress(es). Must be an array.
    attr_accessor :adminaddr
    # Default mime setting
    attr_accessor :default_mime
    # The gpg password
    attr_accessor :gpg_password
    # Wether sending emails in the clear is allowed or not.
    attr_accessor :send_encrypted_only
    # Wether to accept only incoming emails that are encrypted
    attr_accessor :receive_encrypted_only
    # Wether to accept only emails that are validly signed
    attr_accessor :receive_signed_only
    # Wether to accept only emails that are validly signed by a listmember's key
    attr_accessor :receive_authenticated_only
    # Wether to keep the msgid or not
    attr_accessor :keep_msgid
    # Footer for outgoing mails
    attr_accessor :public_footer
    # Subject prefix for incoming (signed) mails from listmembers
    attr_accessor :prefix
    # Subject prefix for incoming mails
    attr_accessor :prefix_in
    # Subject prefix for outgoing mails
    attr_accessor :prefix_out
    # Wether to log or not
    attr_accessor :logging
    # The loglevel (ERROR || WARN || INFO || DEBUG)
    attr_accessor :loglevel
    # How many logfiles to keep when rotating (daily)
    attr_accessor :log_rotate_keep
    # Which headers from original mail to include into the internal meta data
    attr_accessor :headers_to_meta
    # Restrict specific plugins to admin
    attr_accessor :keywords_admin_only
    # Drop any bounces (incoming email not passing the receive_*_only-rules)
    attr_accessor :bounces_drop_all
    # Drop bounces if they match one of these headers. Must be a hash, keys and values are case insensitive.
    attr_accessor :bounces_drop_on_headers
    # Send a notice to admin(s) on bouncing or dropping
    attr_accessor :bounces_notify_admin
    
    # config_file = path to the config file
    # fromfile = wether to load the config from file.
    def initialize(config_file, fromfile=true)
      # Some defaults to run on.
      # If you want to change these, edit conf/default-list.conf
      @myaddr = ''
      @adminaddr = []
      @default_mime = 'MIME'
      @gpg_password  =  nil
      @send_encrypted_only = false
      @receive_encrypted_only = false
      @receive_signed_only = false
      @receive_authenticated_only = false
      @keep_msgid = true
      @public_footer = ''
      @prefix = ''
      @prefix_in = ''
      @prefix_out = ''
      @logging = true
      @loglevel = 'ERROR'
      @log_rotate_keep = 3
      @headers_to_meta = [:from, :to, :cc, :date]
      @keywords_admin_only = ['SAVE-MEMBERS', 'DEL-KEY']
      @bounces_drop_all = false
      @bounces_drop_on_headers = {'x-spam-flag' => 'yes'}
      @bounces_notify_admin = true

      # Overload with default-list.conf
      overload_from_file!(Schleuder.config.lists_default_conf)
      # overload with config_file
      super config_file,fromfile
    end
  end
end
