/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void topsites(void)
{

   FILE *fp_in, *fp_ou;

   char url[MAXLEN];
   char ourl[MAXLEN];
   char nacc[20];
   char nbytes[20];
   char ntime[20];
   char ntemp[255];
   char ttnacc[20];
   char ttnbytes[20];
   char ttntime[20];
   char csort[255];
   char general[MAXLEN];
   char general2[MAXLEN];
   char general3[MAXLEN];
   char per[MAXLEN];
   char sites[MAXLEN];
   char report[MAXLEN];
   char period[100];
   char sortf[10];
   char sortt[10];
   long long int tnacc=0;
   long long int tnbytes=0;
   long long int tntime=0;
   long long int twork1=0, twork2=0, twork3=0;
   int regs=0;
   int cstatus;

   if(strcmp(Privacy,"yes") == 0)
      return;

   sprintf(general,"%s/sarg-general",dirname);
   sprintf(sites,"%s/sarg-sites",dirname);
   sprintf(general2,"%s/sarg-general2",dirname);
   sprintf(general3,"%s/sarg-general3",dirname);
   sprintf(per,"%s/sarg-period",dirname);

   if (strstr(ReportType,"topusers") == 0)
      sprintf(report,"%s/index.html",dirname);
   else
      sprintf(report,"%s/topsites.html",dirname);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],per);
      exit(1);
   }

   if (!fgets(period,sizeof(period),fp_in)) {
      fprintf(stderr,"SARG: (topuser) read error in %s\n",per);
      exit(1);
   }
   fclose(fp_in);

   sprintf(csort,"sort -k 4,4 -o \"%s\" \"%s\"",general2,general);
   cstatus=system(csort);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }

   if((fp_in=fopen(general2,"r"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],general2);
     fprintf(stderr, "SARG: sort command: %s\n",csort);
     exit(1);
   }

   if((fp_ou=fopen(general3,"w"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],general3);
     exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if (getword(url,sizeof(url),buf,' ')<0) {
         printf("SARG: Maybe you have an invalid user in your %s file of the topsites.\n",general2);
         exit(1);
      }
      if(strcmp(url,"TOTAL") == 0) {
         if (getword(ttnacc,sizeof(ttnacc),buf,' ')<0) {
            printf("SARG: Maybe you have an invalid total number of access in your %s file of the topsites.\n",general2);
            exit(1);
         }
         if (getword(ttnbytes,sizeof(ttnbytes),buf,' ')<0) {
            printf("SARG: Maybe you have an invalid total number of bytes in your %s file of the topsites.\n",general2);
            exit(1);
         }
         if (getword(ttntime,sizeof(ttntime),buf,' ')<0) {
            printf("SARG: Maybe you have an invalid total time in your %s file of the topsites.\n",general2);
            exit(1);
         }
         continue;
      }
      if (getword(nacc,sizeof(nacc),buf,' ')<0) {
         printf("SARG: Maybe you have an invalid number of access in your %s file of the topsites.\n",general2);
         exit(1);
      }
      if (getword(nbytes,sizeof(nbytes),buf,' ')<0) {
         printf("SARG: Maybe you have an invalid number of bytes in your %s file of the topsites.\n",general2);
         exit(1);
      }
      if (getword(url,sizeof(url),buf,' ')<0) {
         printf("SARG: Maybe you have an invalid url in your %s file of the topsites.\n",general2);
         exit(1);
      }
      if (getword(ntemp,sizeof(ntemp),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in column 5 in your %s file of the topsites.\n",general2);
         exit(1);
      }
      if (getword(ntemp,sizeof(ntemp),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in column 6 in your %s file of the topsites.\n",general2);
         exit(1);
      }
      if (getword(ntemp,sizeof(ntemp),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in column 7 in your %s file of the topsites.\n",general2);
         exit(1);
      }
      if (getword(ntime,sizeof(ntime),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in column 8 in your %s file of the topsites.\n",general2);
         exit(1);
      }

      if(!regs) {
         strcpy(ourl,url);
         regs++;
      }

      if(strcmp(url,ourl) != 0) {
         my_lltoa(tnacc,val1,15);
         my_lltoa(tnbytes,val2,15);
         my_lltoa(tntime,val3,15);
         fprintf(fp_ou,"%s %s %s %s\n",val1,val2,val3,ourl);
         strcpy(ourl,url);
         tnacc=0;
         tnbytes=0;
         tntime=0;
      }

      tnacc+=my_atoll(nacc);
      tnbytes+=my_atoll(nbytes);
      tntime+=my_atoll(ntime);
   }

   my_lltoa(tnacc,val1,15);
   my_lltoa(tnbytes,val2,15);
   my_lltoa(tntime,val3,15);
   fprintf(fp_ou,"%s %s %s %s\n",val1,val2,val3,ourl);

   fclose(fp_in);
   fclose(fp_ou);
   unlink(general2);

   strlow(TopsitesSortField);
   strlow(TopsitesSortType);

   if(strcmp(TopsitesSortField,"connect") == 0)
      strcpy(sortf,"1,1");
   if(strcmp(TopsitesSortField,"bytes") == 0)
      strcpy(sortf,"2,2");
   if(strcmp(TopsitesSortType,"a") == 0)
      strcpy(sortt," ");
   if(strcmp(TopsitesSortType,"d") == 0)
      strcpy(sortt,"-r");

   sprintf(csort,"sort %s -k %s -o \"%s\" \"%s\"",sortt,sortf,sites,general3);
   cstatus=system(csort);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }
   if((fp_in=fopen(sites,"r"))==NULL) {
      fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],sites);
      fprintf(stderr, "SARG: sort command: %s\n",csort);
      exit(1);
   }

   unlink(general2);
   unlink(general3);

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],report);
     exit(1);
   }

   regs=0;

   fprintf(fp_ou, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   css(fp_ou);
   fputs("</head>\n",fp_ou);
   fprintf(fp_ou,"<body bgcolor=\"%s\" text=\"%s\" background=\"%s\">\n",BgColor,TxColor,BgImage);
   write_logo_image(fp_ou);

   if(strcmp(IndexTree,"date") == 0)
      show_sarg(fp_ou,"../../..");
   else
      show_sarg(fp_ou, "..");

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"title\">%s</th></tr>\n",Title);

   fprintf(fp_ou,"<tr><td class=\"header3\">%s: %s</td></tr>\n",text[89],period);
   fprintf(fp_ou,"<tr><th class=\"header3\">%s %s %s</th></tr>\n",text[83],TopSitesNum,text[84]);
   fputs("</table></div>\n",fp_ou);

   fputs("<div align=\"center\"><table cellpadding=\"1\" cellspacing=\"2\">\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th> \
		<th class=\"header\">%s</th><th class=\"header\">%s</th> \
		<th class=\"header\">%s</th></tr>\n", \
		text[100],text[91],text[92],text[93],text[99]);

   regs=1;
   ntopsites = 0;

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if(regs>atoi(TopSitesNum))
         break;
      if (getword(nacc,sizeof(nacc),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",sites);
         exit(1);
      }
      if (atoi(nacc) == 0) continue;
      if (getword(nbytes,sizeof(nbytes),buf,' ')<0 ||
          getword(ntime,sizeof(ntime),buf,' ')<0 || getword(url,sizeof(url),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",sites);
         exit(1);
      }

      twork1=my_atoll(nacc);
      twork2=my_atoll(nbytes);
      twork3=my_atoll(ntime);

      strcpy(wwork1,fixnum(twork1,1));
      strcpy(wwork2,fixnum(twork2,1));
      strcpy(wwork3,fixtime(twork3));

      if(strlen(BlockIt) > 0)
         sprintf(BlockImage,"<a href=\"%s%s?url=%s\"><img src=\"../images/sarg-squidguard-block.png\" border=\"0\"></a>&nbsp;",wwwDocumentRoot,BlockIt,url);
      else BlockImage[0]='\0';


      fprintf(fp_ou,"<tr><td class=\"data\">%d</td><td class=\"data2\">%s<a href=\"http://%s\"><font class=\"link\">%s</font></a></td><td class=\"data\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s</td></tr>\n",regs,BlockImage,url,url,wwork1,wwork2,wwork3);
      regs++;
   }


   fputs("</table>\n</div>\n",fp_ou);

   show_info(fp_ou);

   fputs("</body>\n</html>\n",fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   return;

}
