/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void tmpsort(void)
{

   DIR *dirp;
   struct dirent *direntp;
   int cstatus;
   const char tmpext[]=".utmp";
   int dlen;

   char csort[MAXLEN];
   char arqou[MAXLEN], arqin[MAXLEN], wnome[MAXLEN];
   char field1[10]="2,2";
   char field2[10]="1,1";
   char field3[10]="3,3";
   char order[4]="-r";

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strup(UserSortField);
   if(strcmp(UserSortField,"CONNECT") == 0) {
      strcpy(field1,"1,1");
      strcpy(field2,"2,2");
      strcpy(field3,"3,3");
   } else if(strcmp(UserSortField,"SITE") == 0) {
      strcpy(field1,"3,3");
      strcpy(field2,"2,2");
      strcpy(field3,"1,1");
   } else if(strcmp(UserSortField,"TIME") == 0) {
      strcpy(field1,"5,5");
      strcpy(field2,"2,2");
      strcpy(field3,"1,1");
   }

   strlow(UserSortOrder);
   if(strcmp(UserSortOrder,"normal") == 0)
      order[0]='\0';

   dirp = opendir(tmp);
   while ((direntp = readdir( dirp )) != NULL ){
      dlen=strlen(direntp->d_name)-(sizeof(tmpext)-1);
      if (dlen<0) continue;
      if(strcmp(direntp->d_name+dlen,tmpext) != 0)
         continue;

      if (dlen>0) {
         if (dlen>=sizeof(wnome)) continue;
         strncpy(wnome,direntp->d_name,dlen);
         wnome[dlen]=0;
      } else {
         wnome[0]='\0';
      }

      strcpy(arqou,tmp);
      strcat(arqou,"/");
      strcpy(arqin,arqou);
      strcat(arqou,wnome);
      strcat(arqin,direntp->d_name);

      if(debug) {
         debuga("%s: %s",text[54],arqou);
      }

      strcat(arqou,".txt");
      sprintf(csort,"sort -n -T \"%s\" %s -k %s -k %s -k %s -o \"%s\" \"%s\"",TempDir,order,field1,field2,field3,arqou,arqin);
      cstatus=system(csort);
      if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
         fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
         fprintf(stderr, "SARG: sort command: %s\n",csort);
         exit(1);
      }
      unlink(arqin);

   }

   (void)closedir( dirp );
   return;
}

void sort_users_log(const char *tmp, int debug)
{
   DIR *dirp;
   struct dirent *direntp;
   char csort[MAXLEN];
   char wtmp[MAXLEN];
   char user[MAXLEN];
   char wdname[MAXLEN];
   int cstatus;
   const char unsortext[]=".unsort";
   int dlen;

   if(debug) {
      debuga("%s",text[138]);
   }

   sprintf(wtmp,"%s/sarg",tmp);

   dirp = opendir(wtmp);
   while ( (direntp = readdir( dirp )) != NULL ){
      dlen=strlen(direntp->d_name)-(sizeof(unsortext)-1);
      if (dlen<0) continue;
      if(strcmp(direntp->d_name+dlen,unsortext) != 0)
         continue;
      if(strcmp(direntp->d_name,"authfail.log.unsort") == 0)
         continue;

      if (dlen>0) {
         if (dlen>=sizeof(user)) continue;
         strncpy(user,direntp->d_name,dlen);
         user[dlen]=0;
      } else {
         bzero(user, MAXLEN);
      }

      if(strcmp(direntp->d_name,"download.unsort") == 0)
         sprintf(csort,"sort -T \"%s\" -k 3,3 -k 1,1 -k 2,2 -k 5,5 -o \"%s/%s.log\" \"%s/%s.unsort\"",
              tmp, wtmp, user, wtmp, user);
      else
         sprintf(csort,"sort -T \"%s\" -k 5,5 -k 1,1 -k 2,2 -o \"%s/%s.log\" \"%s/%s.unsort\"",
              tmp, wtmp, user, wtmp, user);
      cstatus=system(csort);
      if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
         fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
         fprintf(stderr, "SARG: sort command: %s\n",csort);
         exit(1);
      }
      if (snprintf(wdname,sizeof(wdname),"%s/%s.unsort",wtmp,user)>=sizeof(wdname)) {
         fprintf(stderr, "SARG: user name too long for: %s/%s.unsort\n",wtmp,user);
         exit(1);
      }
      unlink(wdname);
      bzero(user, MAXLEN);

   }
   (void)closedir( dirp );

   return;
}
