/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

static void maketmp(const char *user, const char *dirname, int debug, int indexonly);
static void maketmp_hour(const char *user, const char *dirname, int indexonly);
static void gravatmp_hora(const char *dirname, const char *user, const char *data, const char *hora, const char *elap, const char *accbytes, int indexonly);
static void gravatmpf(const char *oldaccuser, const char *dirname, const char *oldurl, long long int nacc, long long int nbytes, const char *oldmsg, long long int nelap, int indexonly, long long int incache, long long int oucache);
static void gravaporuser(const char *user, const char *dirname, const char *url, const char *ip, const char *data, const char *hora, const char *tam, const char *elap, int indexonly);
static void gravager(char *dirname, const char *user, long long int nacc, const char *url, long long int nbytes, const char *ip, const char *hora, const char *dia, long long int nelap, long long int incache, long long int oucache);
static void grava_SmartFilter(const char *dirname, const char *user, const char *ip, const char *data, const char *hora, const char *url, const char *smart);

void gerarel(void)
{

   FILE *fp_in;

   char accdia[11], acchora[9], accuser[MAXLEN], accip[MAXLEN], accurl[MAXLEN], accbytes[12], accelap[10];
   char oldaccdia[11], oldacchora[9], oldaccip[MAXLEN], wdir[MAXLEN], per1[MAXLEN];
   char wdirname[MAXLEN], oldurl[MAXLEN], oldaccuser[MAXLEN];
   char olduser[MAXLEN], oldmsg[50], acccode[MAXLEN/2 - 1], oldaccelap[10], oldacccode[MAXLEN/2 - 1], user[MAXLEN];
   char ipantes[MAXLEN], nameantes[MAXLEN];
   char accsmart[MAXLEN];
   char wcrc[MAXLEN/2 -1];
   char crc2[MAXLEN/2 -1];
   long long int nbytes=0;
   long long int nelap=0;
   long long int nacc=0;
   long long int rtotal=0;
   long long int incache=0;
   long long int oucache=0;
   char *s;
   DIR *dirp;
   struct dirent *direntp;
   const char logext[]=".log";
   int dlen;
   char siteind[MAXLEN];

   ipantes[0]='\0';
   nameantes[0]='\0';
   smartfilter=0;

   sprintf(dirname, "%s%s", outdir, period);
   sprintf(wdir, "%s%s", outdir, period);
   strcpy(per1,period);
   vrfydir(wdir, per1, addr, site, us, email);

   if(debugz){
      debugaz("dirname",dirname);
      debugaz("wdir",wdir);
   }

   gperiod(dirname,period);

   if(UserAgentLog[0] != '\0' && email[0] == '\0') useragent();

   olduser[0]='\0';
   strncat(tmp,"/sarg",5);

   dirp = opendir(tmp);
   while ((direntp = readdir( dirp )) != NULL ) {
      dlen=strlen(direntp->d_name)-(sizeof(logext)-1);
      if (dlen<0) continue;
      if((strcmp(direntp->d_name+dlen,logext) != 0) ||
         (strncmp(direntp->d_name,"download.log",12) == 0) ||
         (strncmp(direntp->d_name,"denied.log",10) == 0) ||
         (strncmp(direntp->d_name,"authfail.log.unsort",19) == 0))
         continue;
      if (snprintf(tmp3,sizeof(tmp3),"%s/%s",tmp,direntp->d_name)>=sizeof(tmp3)) {
         fprintf(stderr, "SARG: (report) directory entry too long: %s/%s\n",tmp,direntp->d_name);
         exit(1);
      }
      if((fp_in=MY_FOPEN(tmp3,"r"))==NULL){
         fprintf(stderr, "SARG: (report) %s: %s\n",text[45],tmp);
         exit(1);
      }

      if (dlen>0) {
         if (dlen>=sizeof(user)) continue;
         strncpy(user,direntp->d_name,dlen);
         user[dlen]=0;
      } else {
         user[0]='\0';
      }

      strcpy(wdirname,dirname);
      maketmp(user,tmp,debug,indexonly);
      maketmp_hour(user,tmp,indexonly);

      strcpy(u2,user);
      if(strcmp(Ip2Name,"yes") == 0)
         ip2name(u2,sizeof(u2));
      get_usertab_name(u2,name,sizeof(name));

      if(dotinuser && strchr(name,'_')) {
         subs(name,sizeof(name),"_",".");
      }

      ttopen=0;
      bzero(html_old, MAXLEN);

      while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
         if (getword(accdia,sizeof(accdia),buf,' ')<0 || getword(acchora,sizeof(acchora),buf,' ')<0 ||
             getword(accuser,sizeof(accuser),buf,' ')<0 || getword(accip,sizeof(accip),buf,' ')<0 ||
             getword(accurl,sizeof(accurl),buf,' ')<0 || getword(accbytes,sizeof(accbytes),buf,' ')<0 ||
             getword(acccode,sizeof(acccode),buf,' ')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",tmp3);
            exit(1);
         }
         if(strncmp(acccode,"TCP_DENIED/407",14) == 0) continue;
         if (getword(accelap,sizeof(accelap),buf,' ')<0 || getword(accsmart,sizeof(accsmart),buf,' ')<0 ||
             getword(accsmart,sizeof(accsmart),buf,'"')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",tmp3);
            exit(1);
         }

         if(accsmart[0] != '\0') {
            smartfilter++;
            strcpy(wdirname,dirname);
            grava_SmartFilter(wdirname,accuser,accip,accdia,acchora,accurl,accsmart);
         }

         if(strcmp(Ip2Name,"yes") == 0) {
            if(strcmp(accip,ipantes) != 0) {
               strcpy(ipantes,accip);
               ip2name(accip,sizeof(accip));
               strcpy(nameantes,accip);
            } else strcpy(accip,nameantes);
         }

         strcpy(wdirname,dirname);
         gravatmp_hora(wdirname,accuser,accdia,acchora,accelap,accbytes,indexonly);

         if(iprel){
            strcpy(wdirname,dirname);
            gravaporuser(accuser,wdirname,accurl,accip,accdia,acchora,accbytes,accelap,indexonly);
         }

         if(!rtotal){
            strcpy(oldurl,accurl);
            strcpy(oldacccode,acccode);
            strcpy(oldaccelap,accelap);
            strcpy(oldaccuser,accuser);
            strcpy(oldaccip,accip);
            strcpy(oldaccdia,accdia);
            strcpy(oldacchora,acchora);
            rtotal++;
         }

         if(site[0] != '\0') {
            if(strcmp(oldaccuser,accuser) != 0){
               strcpy(oldmsg,"OK");
               if(strstr(oldacccode,"DENIED") != 0)
                  sprintf(oldmsg,"%s",text[46]);
               gravatmp(oldaccuser,wdirname,oldurl,nacc,nbytes,oldmsg,nelap,indexonly,incache,oucache);
               gravager(wdirname,oldaccuser,nacc,oldurl,nbytes,oldaccip,oldacchora,oldaccdia,nelap,incache,oucache);
               nacc=0;
               nbytes=0;
               nelap=0;
               incache=0;
               oucache=0;
            }
         } else {
            if(strcmp(oldurl,accurl) != 0 || strcmp(oldaccuser,accuser) != 0){
               strcpy(oldmsg,"OK");
               if(strstr(oldacccode,"DENIED") != 0)
                  sprintf(oldmsg,"%s",text[46]);
               strcpy(wdirname,dirname);
               gravatmp(oldaccuser,wdirname,oldurl,nacc,nbytes,oldmsg,nelap,indexonly,incache,oucache);
               strcpy(wdirname,dirname);
               gravager(wdirname,oldaccuser,nacc,oldurl,nbytes,oldaccip,oldacchora,oldaccdia,nelap,incache,oucache);
               nacc=0;
               nbytes=0;
               nelap=0;
               incache=0;
               oucache=0;
               if(strcmp(oldaccuser,accuser) != 0)
                  ind2=0;
            }
         }
         nacc++;
         nbytes+=my_atoll(accbytes);
         nelap+=my_atoll(accelap);

         if(strstr(ReportType,"site_user_time_date") != 0) {
            if(!ttopen) {
               ind2++;
               strcpy(siteind,accurl);
               for(str=siteind; *str; str++) {
                  if(*str=='?' || *str=='-' || *str=='.' || *str==':' || *str=='/' || *str=='\\' || *str=='*' ||
                     *str=='\'' || *str=='\"' || *str=='$')
                     *str='_';
               }
               sprintf(arqtt,"%s/%s",dirname,accuser);
               if(access(arqtt, R_OK) != 0)
                  my_mkdir(arqtt);
               sprintf(arqtt,"%s/%s/tt%s-%s.html",dirname,accuser,accuser,siteind);
               if(strlen(arqtt) > 255) {
                  arqtt[255]='\0';
               }
               if ((fp_tt = fopen(arqtt, "w")) == 0) {
                  fprintf(stderr, "SARG: (report) %s: %s\n",text[45],arqtt);
                  exit(1);
               }
               ttopen=1;

               /*
               if(strcmp(Privacy,"yes") == 0)
                  sprintf(httplink,"<font size=%s color=%s><href=http://%s>%s",	\
                              FontSize,PrivacyStringColor,PrivacyString,PrivacyString);
               else
                  sprintf(httplink,"<font size=%s><a href=\"http://%s\">%s</a>",FontSize,accurl,accurl);
               */

               sprintf(ltext110,"%s",text[110]);
               for(s=ltext110; *s; ++s)
                  *s=tolower(*s);

               fprintf(fp_tt, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
               css(fp_tt);
               fputs("</head>\n",fp_tt);
               fprintf(fp_tt,"<body bgcolor=\"%s\" text=\"%s\" background=\"%s\">\n",BgColor,TxColor,BgImage);
               write_logo_image(fp_tt);

               if(strcmp(IndexTree,"date") == 0)
                  show_sarg(fp_tt, "../../../..");
               else
                  show_sarg(fp_tt, "../..");

               fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_tt);
               fprintf(fp_tt,"<tr><th class=\"title\" colspan=\"2\">%s</th></tr>\n",Title);

               fprintf(fp_tt,"<tr><td class=\"header\" colspan=\"2\">%s:&nbsp;%s</td></tr>\n",text[89],period);
               fprintf(fp_tt,"<tr><td class=\"header\" colspan=\"2\">%s:&nbsp;%s</td></tr>\n",text[90],name);
               fprintf(fp_tt,"<tr><td class=\"header\" colspan=\"2\">%s:&nbsp;%s, %s</td></tr>\n",text[104],UserSortField,UserSortOrder);
               fprintf(fp_tt,"<tr><th class=\"header3\" colspan=\"2\">%s</th></tr>\n",text[32]);

               fputs("</table></div>\n",fp_tt);
               fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"2\">\n",fp_tt);
               fputs("<tr><td></td><td></td></tr>",fp_tt);
               bzero(tmp4, MAXLEN);
               strncpy(tmp4,text[110],4);
               fprintf(fp_tt,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th></tr>\n",text[91],tmp4,text[110]+5);
            }

            sprintf(html,"<tr><td class=\"data\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s</td></tr>\n",accurl,accdia,acchora);

            if(strcmp(html,html_old) != 0)
               fputs(html,fp_tt);
            strcpy(html_old, html);
         } else bzero(ltext110, 50);

         strcpy(wcrc,acccode);
         if (getword(crc2,sizeof(crc2),wcrc,'/')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",tmp3);
            exit(1);
         }

         if(strstr(crc2,"MISS") != 0)
            oucache+=my_atoll(accbytes);
         else incache+=my_atoll(accbytes);

         strcpy(oldurl,accurl);

         if(strcmp(accuser,oldaccuser) != 0) {
            strcpy(wdirname,dirname);
            day_totalize(tmp,oldaccuser,indexonly);
         }

         strcpy(oldaccuser,accuser);
         strcpy(oldacccode,acccode);
         strcpy(oldaccelap,accelap);
         strcpy(oldaccip,accip);
         strcpy(oldaccdia,accdia);
         strcpy(oldacchora,acchora);

      }
      bzero(user,MAXLEN);
      fclose(fp_in);
      unlink(tmp3);
   }
   closedir(dirp);

   strcpy(oldmsg,"OK");
   if(strstr(oldacccode,"DENIED") != 0)
      sprintf(oldmsg,"%s",text[46]);
   strcpy(wdirname,dirname);
   if(strlen(oldaccuser) == 0)
      strcpy(oldaccuser,accuser);
   gravatmpf(oldaccuser,wdirname,oldurl,nacc,nbytes,oldmsg,nelap,indexonly,incache,oucache);
   strcpy(wdirname,dirname);
   gravager(wdirname,oldaccuser,nacc,oldurl,nbytes,oldaccip,oldacchora,oldaccdia,nelap,incache,oucache);
   strcpy(wdirname,dirname);
   day_totalize(tmp,oldaccuser,indexonly);

   tmpsort();

   strcpy(wdirname,dirname);
   totalger(wdirname, debug, outdir);

   if(email[0] == '\0') {
      if(strstr(ReportType,"downloads") != 0) download_report();

      if(strlen(DansGuardianConf) > 0) {
         strcpy(wdirname,dirname);
         dansguardian_log();
      }

      strcpy(wdirname,dirname);
      squidguard_log();

      strcpy(wdirname,dirname);
      topuser();

      if(strstr(ReportType,"topsites") != 0) topsites();

      if(strstr(ReportType,"sites_users") != 0) siteuser();
      gen_denied_report();

      strcpy(wdirname,dirname);
      authfail_report();

      if(smartfilter) smartfilter_report();

      if(strlen(DansGuardianConf) > 0) dansguardian_report();

      squidguard_report();

      if(strstr(ReportType,"users_sites") != 0) htmlrel();

      make_index();

      if(strncmp(SuccessfulMsg,"yes",3) == 0) fprintf(stderr, "SARG: %s %s\n",text[47],dirname);
    } else {
      strcpy(wdirname,dirname);
      geramail(wdirname, debug, outdir, userip, email, TempDir);

      if((strcmp(email,"stdout") != 0) && (strncmp(SuccessfulMsg,"yes",3) == 0))
            fprintf(stderr, "SARG: %s %s\n",text[48],email);
   }

   if(indexonly) {
      strcpy(wdirname,dirname);
      index_only(wdirname, debug);
   }

   /*
   2009-10-13(Frederic) This piece of code is never called so it is commented out for good.
   if(strlen(email) < 0)
      removetmp(dirname);
   */

   return;
}

static void maketmp(const char *user, const char *dirname, int debug, int indexonly)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,tmp);
   strcat(wdirname,"/");
   strcat(wdirname,user);

   if(debug){
      debuga("%s: %s",text[49],wdirname);
   }

   strcat(wdirname,".utmp");
   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   fclose(fp_ou);
   return;
}


static void maketmp_hour(const char *user, const char *dirname, int indexonly)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,tmp);
   strcat(wdirname,"/");
   strcat(wdirname,user);

   strcat(wdirname,".htmp");
   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SARG: (report-1) %s: %s - %s\n",text[45],wdirname,strerror(errno));
      exit(1);
   }

   fclose(fp_ou);
   return;
}


void gravatmp(const char *oldaccuser, const char *dirname, const char *oldurl, long long int nacc, long long int nbytes, const char *oldmsg, long long int nelap, int indexonly, long long int incache, long long int oucache)
{

   FILE *fp_ou;
   char val1[16];
   char val2[16];
   char val3[16];
   char val4[16];
   char val5[16];

   char wdirname[MAXLEN];

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(wdirname,tmp);
   strcat(wdirname,"/");
   strcat(wdirname,oldaccuser);
   strcat(wdirname,".utmp");

   if((fp_ou=MY_FOPEN(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   my_lltoa(nacc,val1,15);
   my_lltoa(nbytes,val2,15);
   my_lltoa(nelap,val3,15);
   my_lltoa(incache,val4,15);
   my_lltoa(oucache,val5,15);
   fprintf(fp_ou,"%s %s %s %s %s %s %s\n",val1,val2,oldurl,oldmsg,val3,val4,val5);

   fclose(fp_ou);
   ttopen=0;

   if(fp_tt) {
      fputs("</table>\n",fp_tt);
      fputs("</body>\n</html>\n",fp_tt);
      fclose(fp_tt);
   }

   return;

}


static void gravatmp_hora(const char *dirname, const char *user, const char *data, const char *hora, const char *elap, const char *bytes, int indexonly)
{

   FILE *fp_ou;
   char wdirname[MAXLEN];

   if(indexonly || (strstr(ReportType,"users_sites") == 0)) return;

   strcpy(wdirname,tmp);
   strcat(wdirname,"/");
   strcat(wdirname,user);
   strcat(wdirname,".htmp");

   if((fp_ou=MY_FOPEN(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report-2) %s: %s - %s\n",text[45],wdirname,strerror(errno));
      exit(1);
   }

   if(strcmp(datetimeby,"bytes") == 0) fprintf(fp_ou,"%s %s %s\n",data,hora,bytes);
   else fprintf(fp_ou,"%s %s %s\n",data,hora,elap);

   fclose(fp_ou);

   return;
}


static void gravaporuser(const char *user, const char *dirname, const char *url, const char *ip, const char *data, const char *hora, const char *tam, const char *elap, int indexonly)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   if(indexonly || (strstr(ReportType,"users_sites") == 0)) return;

   strcpy(wdirname,tmp);
   strcat(wdirname,"/");
   strcat(wdirname,user);
   strcat(wdirname,".ip");

   if((fp_ou=MY_FOPEN(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   fprintf(fp_ou,"%s %s %s %s %s %s\n",ip,url,data,hora,tam,elap);

   fclose(fp_ou);

   return;

}


static void gravatmpf(const char *oldaccuser, const char *dirname, const char *oldurl, long long int nacc, long long int nbytes, const char *oldmsg, long long int nelap, int indexonly, long long int incache, long long int oucache)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   if(indexonly || (strstr(ReportType,"users_sites") == 0)) return;

   strcpy(wdirname,tmp);
   strcat(wdirname,"/");
   strcat(wdirname,oldaccuser);
   strcat(wdirname,".utmp");

   if((fp_ou=MY_FOPEN(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   my_lltoa(nacc,val1,15);
   my_lltoa(nbytes,val2,15);
   my_lltoa(nelap,val3,15);
   my_lltoa(incache,val4,15);
   my_lltoa(oucache,val5,15);
   fprintf(fp_ou,"%s %s %s %s %s %s %s\n",val1,val2,oldurl,oldmsg,val3,val4,val5);

   fclose(fp_ou);
   ttopen=0;
   ind2=0;

   if(fp_tt) {
      fputs("</table>\n",fp_tt);
      fputs("</body>\n</html>\n",fp_tt);
      fclose(fp_tt);
   }

   return;

}


static void gravager(char *dirname, const char *user, long long int nacc, const char *url, long long int nbytes, const char *ip, const char *hora, const char *dia, long long int nelap, long long int incache, long long int oucache)
{

   FILE *fp_ou;

   strcat(dirname,"/");
   strcat(dirname,"sarg-general");

   if((fp_ou=MY_FOPEN(dirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],dirname);
      exit(1);
   }

   my_lltoa(nacc,val1,15);
   my_lltoa(nbytes,val2,15);
   my_lltoa(nelap,val3,15);
   my_lltoa(incache,val4,15);
   my_lltoa(oucache,val5,15);
   fprintf(fp_ou,"%s %s %s %s %s %s %s %s %s %s\n",user,val1,val2,url,ip,hora,dia,val3,val4,val5);

   fclose(fp_ou);
   return;

}

static void grava_SmartFilter(const char *dirname, const char *user, const char *ip, const char *data, const char *hora, const char *url, const char *smart)
{

   FILE *fp_ou;

   char wdirname[MAXLEN];

   sprintf(wdirname,"%s/smartfilter.unsort",dirname);

   if((fp_ou=MY_FOPEN(wdirname,"a"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   fprintf(fp_ou,"%s %s %s %s %s %s\n",user,data,hora,ip,url,smart);
   fputs("</body>\n</html>\n",fp_tt);

   fclose(fp_ou);

   return;

}
