#! /bin/sh

echo "XPA Tests"

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]; then
    ds9 -tcl&

    i=1
    while [ "$i" -le 30 ]
	do
	sleep 2
	if [ `xpaaccess ds9` = yes ]; then
	    break
	fi

	i=`expr $i + 1`
    done
fi

testit () {
    echo "Testing $1"

    if [ -f xpa/${1}.xpa ]
    then
	o=`diff xpa/${1}.xpa ${1}.out`
	if [ "$o" = "" ]
	then
	    echo "PASSED"
	else
            echo "FAILED"
	    echo "$o"
	fi
    else
        echo "PASSED"
    fi
    rm -f ${1}.out
    xpaset -p ds9 raise
}

# must be invoked
#         imexam

# load default image
rm -f *.out
xpaset -p ds9 scale zscale
xpaset -p ds9 file img16.fits

delay=.5

if [ "$1" = "2mass" ]; then
tt="2mass"
xpaset -p ds9 2mass open
xpaset -p ds9 2mass close
xpaset -p ds9 2mass survey h
xpaget ds9 2mass survey >> ${tt}.out
xpaset -p ds9 2mass size 30 30 arcsec
xpaget ds9 2mass size >> ${tt}.out
xpaset -p ds9 2mass save no
xpaget ds9 2mass save >> ${tt}.out
xpaset -p ds9 2mass frame new
xpaget ds9 2mass frame >> ${tt}.out
xpaset -p ds9 2mass update frame
xpaset -p ds9 2mass m1
xpaset -p ds9 2mass name m51
xpaget ds9 2mass name >> ${tt}.out
xpaset -p ds9 2mass name {}
xpaset -p ds9 2mass coord 00:42:44.404 +41:16:08.78 sexagesimal
xpaget ds9 2mass coord >> ${tt}.out
xpaset -p ds9 2mass update frame
xpaset -p ds9 mode crosshair
xpaset -p ds9 2mass update crosshair
xpaset -p ds9 2mass close
xpaset -p ds9 mode pointer
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "3d" -o -z "$1" ]; then
tt="3d"
xpaset -p ds9 3d open
xpaset -p ds9 3d close
xpaset -p ds9 3d
xpaset -p ds9 3d vp 45 30
xpaget ds9 3d vp >> ${tt}.out
xpaget ds9 3d az >> ${tt}.out
xpaget ds9 3d el >> ${tt}.out
xpaget ds9 3d scale >> ${tt}.out
xpaget ds9 3d method >> ${tt}.out
xpaget ds9 3d border >> ${tt}.out
xpaget ds9 3d border color >> ${tt}.out
xpaget ds9 3d compass >> ${tt}.out
xpaget ds9 3d compass color >> ${tt}.out
xpaget ds9 3d highlite >> ${tt}.out
xpaget ds9 3d highlite color >> ${tt}.out
xpaset -p ds9 3d vp 45 30
xpaset -p ds9 3d az 45
xpaset -p ds9 3d el 30
xpaset -p ds9 3d scale 5
xpaset -p ds9 3d method mip
xpaset -p ds9 3d border yes
xpaset -p ds9 3d border color red
xpaset -p ds9 3d compass yes
xpaset -p ds9 3d compass color red
xpaset -p ds9 3d highlite yes
xpaset -p ds9 3d highlite color red
xpaset -p ds9 3d close
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "about" -o -z "$1" ]; then
tt="about"
xpaget ds9 about >> /dev/null
testit $tt
fi

if [ "$1" = "align" -o -z "$1" ]; then
tt="align"
xpaget ds9 align >> ${tt}.out
xpaset -p ds9 align
xpaset -p ds9 frame reset
testit $tt
fi

if [ "$1" = "analysis" -o -z "$1" ]; then
tt="analysis"
xpaset -p ds9 analysis clear
xpaset -p ds9 analysis analysis.ans
xpaget ds9 analysis > /dev/null
xpaget ds9 analysis task > /dev/null
#xpaget ds9 analysis entry 'hello world'

xpaset -p ds9 analysis 0
xpaset -p ds9 analysis task 1
xpaset -p ds9 analysis task '{Basic Help}'
xpaset -p ds9 analysis clear
xpaset -p ds9 analysis load analysis.ans
xpaset -p ds9 analysis clear load analysis.ans
xpaset -p ds9 analysis clear
cat analysis.ans | xpaset ds9 analysis load
xpaset -p ds9 analysis clear
#xpaset -p ds9 analysis message {This is a message}
#xpaset -p ds9 analysis message yesno {This is a message}
xpaset -p ds9 analysis text {This is text}
cat analysis.txt | xpaset ds9 analysis text
testit $tt
fi

if [ "$1" = "array" -o -z "$1" ]; then
tt="array"
xpaget ds9 array > /dev/null
xpaget ds9 array bigendian > /dev/null
xpaget ds9 array littleendian > /dev/null

cat array.arr | xpaset ds9 array new 'array.arr[dim=512,bitpix=-32,arch=bigendian]'
xpaset -p ds9 frame clear
cat array.arr | xpaset ds9 array 'array.arr[dim=512,bitpix=-32,arch=bigendian]'
cat rgb.arr | xpaset ds9 array new rgb 'rgb.arr[dim=200,zdim=3,bitpix=8]'
xpaset -p ds9 frame clear
cat rgb.arr | xpaset ds9 array rgb 'rgb.arr[dim=200,zdim=3,bitpix=8]'
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 rgb close
xpaset -p ds9 cube close
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "bg" -o -z "$1" ]; then
tt="bg"
xpaget ds9 background >> ${tt}.out
xpaget ds9 bg >> ${tt}.out
xpaset -p ds9 background red
xpaset -p ds9 bg blue
xpaset -p ds9 prefs bgcolor white
testit $tt
fi

if [ "$1" = "bin" -o -z "$1" ]; then
tt="bin"
xpaset -p ds9 file new table.fits
xpaset -p ds9 single
xpaset -p ds9 bin open
xpaset -p ds9 bin factor 4
xpaset -p ds9 bin factor 8 8
xpaset -p ds9 scale log
xpaset -p ds9 scale minmax
xpaset -p ds9 bin buffersize 1024
xpaset -p ds9 bin filter 'circle(4096,4096,200)'
xpaset -p ds9 bin filter ''
xpaset -p ds9 bin cols rawx rawy
xpaset -p ds9 bin about center
xpaset -p ds9 bin colsz x y pha
xpaset -p ds9 bin depth 10
xpaset -p ds9 bin about 4096 4096
xpaset -p ds9 bin depth 1
xpaset -p ds9 bin function sum
xpaset -p ds9 bin to fit
xpaset -p ds9 bin match
xpaset -p ds9 bin lock yes
xpaset -p ds9 bin lock no
xpaset -p ds9 bin close
xpaget ds9 bin about >> ${tt}.out
xpaget ds9 bin buffersize >> ${tt}.out
xpaget ds9 bin cols >> ${tt}.out
xpaget ds9 bin factor >> ${tt}.out
xpaget ds9 bin filter >> ${tt}.out
xpaget ds9 bin function >> ${tt}.out
xpaget ds9 bin lock >> ${tt}.out
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "catalog" -o -z "$1" ]; then
tt="catalog"
xpaset -p ds9 catalog cds 2mass

xpaget ds9 catalog >> ${tt}.out
xpaget ds9 catalog header > /dev/null
xpaget ds9 catalog cat2mass header > /dev/null
xpaset -p ds9 catalog clear
xpaset -p ds9 catalog close

xpaset -p ds9 catalog
xpaset -p ds9 catalog close

xpaset -p ds9 catalog cds "I/284"
xpaset -p ds9 catalog clear
xpaset -p ds9 catalog close

xpaset -p ds9 catalog import sb ds9.cat
xpaset -p ds9 catalog clear
xpaset -p ds9 catalog close

xpaset -p ds9 catalog cds 2mass
xpaset -p ds9 raise
xpaset -p ds9 catalog plot '$Jmag' '$Hmag' '$e_Jmag' '$e_Hmag'
xpaset -p ds9 catalog symbol condition '$Jmag>15'
xpaset -p ds9 catalog symbol shape "{boxcircle point}"
xpaset -p ds9 catalog symbol color red
xpaset -p ds9 catalog symbol condition "{}"
xpaset -p ds9 catalog symbol color red
xpaset -p ds9 catalog symbol shape text
xpaset -p ds9 catalog symbol font times
xpaset -p ds9 catalog symbol fontsize 14
xpaset -p ds9 catalog symbol fontweight bold
xpaset -p ds9 catalog symbol fontslant italic
xpaset -p ds9 catalog symbol add
xpaset -p ds9 catalog symbol remove
xpaset -p ds9 catalog symbol load ds9.sym
xpaset -p ds9 catalog symbol save foo.sym
xpaset -p ds9 catalog name m51
xpaset -p ds9 catalog coordinate 202.48 47.21 fk5
xpaset -p ds9 catalog system wcs
xpaset -p ds9 catalog sky fk5
xpaset -p ds9 catalog skyformat degrees
xpaset -p ds9 catalog size 22 22 arcmin
xpaset -p ds9 catalog retrieve
xpaset -p ds9 catalog save foo.cat
xpaset -p ds9 catalog filter '$Jmag>15'
xpaset -p ds9 catalog filter load ds9.flt
xpaset -p ds9 catalog retrieve
xpaset -p ds9 catalog cancel
#xpaset -p ds9 catalog print
xpaset -p ds9 catalog server sao
xpaset -p ds9 catalog sort "Jmag" incr
xpaset -p ds9 catalog maxrows 3000
xpaset -p ds9 catalog allcols
xpaset -p ds9 catalog allrows
xpaset -p ds9 catalog ra "RAJ2000"
xpaset -p ds9 catalog dec "DEJ2000"
xpaset -p ds9 catalog psystem wcs
xpaset -p ds9 catalog psky fk5
xpaset -p ds9 catalog hide
xpaset -p ds9 catalog show
xpaset -p ds9 catalog panto no
#xpaset -p ds9 catalog edit yes
xpaset -p ds9 catalog location 400
xpaset -p ds9 catalog header
xpaset -p ds9 catalog clear
xpaset -p ds9 catalog close
xpaset -p ds9 catalog 2mass
xpaset -p ds9 catalog xmm
xpaset -p ds9 catalog match function 1and2
xpaset -p ds9 catalog match error 2 arcsec
xpaset -p ds9 catalog match return 1only
xpaset -p ds9 catalog match unique no
xpaset -p ds9 catalog match 2mass xmm
xpaset -p ds9 catalog clear
xpaset -p ds9 catalog close
xpaset -p ds9 catalog clear
xpaset -p ds9 catalog close
xpaset -p ds9 catalog clear
xpaset -p ds9 catalog close
rm -f foo.cat
testit $tt
fi

if [ "$1" = "cd" -o -z "$1" ]; then
tt="cd"
xpaget ds9 cd >> ${tt}.out
xpaset -p ds9 cd .
testit $tt
fi

if [ "$1" = "cmap" -o -z "$1" ]; then
tt="cmap"
xpaget ds9 cmap >> ${tt}.out
xpaget ds9 cmap file >> ${tt}.out
xpaget ds9 cmap invert >> ${tt}.out
xpaget ds9 cmap value >> ${tt}.out
xpaget ds9 cmap lock >> ${tt}.out
xpaset -p ds9 cmap open
xpaset -p ds9 cmap Heat
xpaset -p ds9 cmap load ds9.sao
xpaset -p ds9 cmap save foo.sao
xpaset -p ds9 cmap invert yes
xpaset -p ds9 cmap value 5 .2
xpaset -p ds9 cmap match
xpaset -p ds9 cmap lock yes
xpaset -p ds9 cmap lock no
xpaset -p ds9 cmap tag load ds9.tag
xpaset -p ds9 cmap tag save foo.tag
xpaset -p ds9 cmap tag delete
xpaset -p ds9 cmap Grey
xpaset -p ds9 cmap close
testit $tt
rm -f foo.sao foo.tag
fi

if [ "$1" = "colorbar" -o -z "$1" ]; then
tt="colorbar"
xpaget ds9 colorbar >> ${tt}.out
xpaget ds9 colorbar orientation >> ${tt}.out
xpaget ds9 colorbar numerics >> ${tt}.out
xpaget ds9 colorbar space >> ${tt}.out
xpaget ds9 colorbar font >> ${tt}.out
xpaget ds9 colorbar fontsize >> ${tt}.out
xpaget ds9 colorbar fontweight >> ${tt}.out
xpaget ds9 colorbar fontslant >> ${tt}.out
xpaget ds9 colorbar size >> ${tt}.out
xpaget ds9 colorbar ticks >> ${tt}.out

xpaset -p ds9 colorbar no
xpaset -p ds9 colorbar yes
xpaset -p ds9 colorbar vertical
xpaset -p ds9 colorbar horizontal
xpaset -p ds9 colorbar numerics no
xpaset -p ds9 colorbar numerics yes
xpaset -p ds9 colorbar space value
xpaset -p ds9 colorbar space distance
xpaset -p ds9 colorbar font times
xpaset -p ds9 colorbar fontsize 30
xpaset -p ds9 colorbar fontweight bold
xpaset -p ds9 colorbar fontslant roman
xpaset -p ds9 colorbar font helvetica
xpaset -p ds9 colorbar fontsize 10
xpaset -p ds9 colorbar fontweight normal
xpaset -p ds9 colorbar fontslant roman
xpaset -p ds9 colorbar size 30
xpaset -p ds9 colorbar ticks 9
xpaset -p ds9 colorbar size 20
xpaset -p ds9 colorbar ticks 11
testit $tt
fi

if [ "$1" = "console" -o -z "$1" ]; then
tt="console"
xpaset -p ds9 console
testit $tt
fi

if [ "$1" = "contour" -o -z "$1" ]; then
tt="contour"
xpaset -p ds9 contour yes

xpaget ds9 contour >> ${tt}.out
xpaget ds9 contour wcs fk5 >> ${tt}.out
xpaget ds9 contour color >> ${tt}.out
xpaget ds9 contour width >> ${tt}.out
xpaget ds9 contour smooth >> ${tt}.out
xpaget ds9 contour method >> ${tt}.out
xpaget ds9 contour nlevels >> ${tt}.out
xpaget ds9 contour scale >> ${tt}.out
xpaget ds9 contour log exp >> ${tt}.out
xpaget ds9 contour mode >> ${tt}.out
xpaget ds9 contour limits >> ${tt}.out
xpaget ds9 contour levels >> ${tt}.out

xpaset -p ds9 contour open
xpaset -p ds9 contour
xpaset -p ds9 contour yes

xpaset -p ds9 contour clear
xpaset -p ds9 contour yes
xpaset -p ds9 contour load ds9.con wcs fk5 red 2
xpaset -p ds9 contour save foo.con wcs fk5

xpaset -p ds9 contour clear
xpaset -p ds9 contour yes
xpaset -p ds9 contour convert
xpaset -p ds9 regions delete all
xpaset -p ds9 contour loadlevels ds9.lev
xpaset -p ds9 contour savelevels foo.lev

xpaset -p ds9 contour clear
xpaset -p ds9 contour yes
xpaset -p ds9 contour copy
xpaset -p ds9 contour paste wcs red 2

xpaset -p ds9 contour clear
xpaset -p ds9 contour yes
xpaset -p ds9 contour color yellow
xpaset -p ds9 contour width 2
xpaset -p ds9 contour smooth 5
xpaset -p ds9 contour method block
xpaset -p ds9 contour nlevels 10
xpaset -p ds9 contour width 2
xpaset -p ds9 contour scale sqrt
xpaset -p ds9 contour log exp 1000
xpaset -p ds9 contour mode zscale
xpaset -p ds9 contour limits 1 100
xpaset -p ds9 contour levels "{1 10 100 1000}"

xpaset -p ds9 contour clear
xpaset -p ds9 contour close
rm -f foo.con foo.lev
testit $tt
fi

if [ "$1" = "crop" -o -z "$1" ]; then
tt="crop"
xpaset -p ds9 mode crop
xpaset -p ds9 crop  978 970  356 308 
xpaget ds9 crop >> ${tt}.out
xpaget ds9 crop wcs fk5 sexagesimal arcsec >> ${tt}.out
xpaget ds9 crop lock >> ${tt}.out
xpaset -p ds9 crop  978 970  356 308 
xpaset -p ds9 crop 13:29:52.908 +47:11:38.19  35.279606 30.522805 wcs fk5 arcsec
xpaset -p ds9 crop reset
xpaset -p ds9 3d
xpaset -p ds9 file 3d.fits
xpaset -p ds9 crop 3d 25 75
xpaset -p ds9 crop reset
xpaset -p ds9 crop match wcs
xpaset -p ds9 crop lock wcs
xpaset -p ds9 crop lock none
xpaset -p ds9 3d close
xpaset -p ds9 frame delete
xpaset -p ds9 mode pointer
testit $tt
fi

if [ "$1" = "crosshair" -o -z "$1" ]; then
tt="crosshair"
xpaset -p ds9 mode crosshair
xpaget ds9 crosshair >> ${tt}.out
xpaget ds9 crosshair wcs fk5 sexagesimal >> ${tt}.out
xpaget ds9 crosshair lock >> ${tt}.out
xpaset -p ds9 crosshair 13:29:55.287 +47:11:37.73 wcs fk5
xpaset -p ds9 crosshair match wcs
xpaset -p ds9 crosshair lock wcs
xpaset -p ds9 crosshair lock none
xpaset -p ds9 mode pointer
testit $tt
fi

if [ "$1" = "cube" -o -z "$1" ]; then
tt="cube"
xpaset -p ds9 cube open
xpaset -p ds9 cube close
xpaset -p ds9 file new hst.fits
xpaget ds9 cube >> ${tt}.out
xpaget ds9 cube interval >> ${tt}.out
xpaget ds9 cube axis >> ${tt}.out
xpaget ds9 cube lock >> ${tt}.out
xpaset -p ds9 cube 2
xpaset -p ds9 cube interval .5
xpaset -p ds9 cube axis 3
xpaset -p ds9 cube play
xpaset -p ds9 cube stop
xpaset -p ds9 cube match
xpaset -p ds9 cube lock yes
xpaset -p ds9 cube lock no
xpaset -p ds9 cube close
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "cursor" -o -z "$1" ]; then
tt="cursor"
xpaset -p ds9 mode crosshair
xpaset -p ds9 cursor 10 10
xpaset -p ds9 mode pointer
testit $tt
fi

if [ "$1" = "data" -o -z "$1" ]; then
tt="data"
xpaget ds9 data image 450 520 3 3 yes >> ${tt}.out
xpaget ds9 data physical 899 1039 6 6 no >> ${tt}.out
xpaget ds9 data fk5 202.4709 47.19681 0.00016517 0.00016517 yes >> ${tt}.out
xpaget ds9 data wcs fk5 202.4709 47.19681 0.00016517 0.00016517 no >> ${tt}.out
testit $tt
fi

if [ "$1" = "dsssao" -o -z "$1" ]; then
tt="dsssao"
xpaset -p ds9 dsssao open
xpaset -p ds9 dsssao close
xpaset -p ds9 dsssao size 30 30 arcsec
xpaget ds9 dsssao size >> ${tt}.out
xpaset -p ds9 dsssao save no
xpaget ds9 dsssao save >> ${tt}.out
xpaset -p ds9 dsssao frame new
xpaget ds9 dsssao frame >> ${tt}.out
xpaset -p ds9 dsssao update frame
xpaset -p ds9 dsssao m1
xpaset -p ds9 dsssao name m51
xpaget ds9 dsssao name >> ${tt}.out
xpaset -p ds9 dsssao name {}
xpaset -p ds9 dsssao coord 00:42:44.404 +41:16:08.78 sexagesimal
xpaget ds9 dsssao coord >> ${tt}.out
xpaset -p ds9 dsssao update frame
xpaset -p ds9 mode crosshair
xpaset -p ds9 dsssao update crosshair
xpaset -p ds9 dsssao close
xpaset -p ds9 mode pointer
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "dsseso" -o -z "$1" ]; then
tt="dsseso"
xpaset -p ds9 dsseso open
xpaset -p ds9 dsseso close
xpaset -p ds9 dsseso survey DSS2-red
xpaget ds9 dsseso survey >> ${tt}.out
xpaset -p ds9 dsseso size 30 30 arcsec
xpaget ds9 dsseso size >> ${tt}.out
xpaset -p ds9 dsseso save no
xpaget ds9 dsseso save >> ${tt}.out
xpaset -p ds9 dsseso frame new
xpaget ds9 dsseso frame >> ${tt}.out
xpaset -p ds9 dsseso update frame
xpaset -p ds9 dsseso m1
xpaset -p ds9 dsseso name m51
xpaget ds9 dsseso name >> ${tt}.out
xpaset -p ds9 dsseso name {}
xpaset -p ds9 dsseso coord 00:42:44.404 +41:16:08.78 sexagesimal
xpaget ds9 dsseso coord >> ${tt}.out
xpaset -p ds9 dsseso update frame
xpaset -p ds9 mode crosshair
xpaset -p ds9 dsseso update crosshair
xpaset -p ds9 dsseso close
xpaset -p ds9 mode pointer
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "dssstsci" -o -z "$1" ]; then
tt="dssstsci"
xpaset -p ds9 dssstsci open
xpaset -p ds9 dssstsci close
xpaset -p ds9 dssstsci survey all
xpaget ds9 dssstsci survey >> ${tt}.out
xpaset -p ds9 dssstsci size 30 30 arcsec
xpaget ds9 dssstsci size >> ${tt}.out
xpaset -p ds9 dssstsci save no
xpaget ds9 dssstsci save >> ${tt}.out
xpaset -p ds9 dssstsci frame new
xpaget ds9 dssstsci frame >> ${tt}.out
xpaset -p ds9 dssstsci update frame
xpaset -p ds9 dssstsci m1
xpaset -p ds9 dssstsci name m51
xpaget ds9 dssstsci name >> ${tt}.out
xpaset -p ds9 dssstsci name {}
xpaset -p ds9 dssstsci coord 00:42:44.404 +41:16:08.78 sexagesimal
xpaget ds9 dssstsci coord >> ${tt}.out
xpaset -p ds9 dssstsci update frame
xpaset -p ds9 mode crosshair
xpaset -p ds9 dssstsci update crosshair
xpaset -p ds9 dssstsci close
xpaset -p ds9 mode pointer
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "export" -o -z "$1" ]; then
tt="export"
xpaset -p ds9 export foo.fits
xpaset -p ds9 export foo.gif
xpaset -p ds9 export foo.tif
xpaset -p ds9 export foo.tif none
xpaset -p ds9 export foo.jpg
xpaset -p ds9 export foo.jpg 100
xpaset -p ds9 export foo.png
xpaset -p ds9 export foo.ppm

# backward compatability
xpaset -p ds9 savefits foo.fits

testit $tt
rm -f foo.fits foo.gif foo.tif foo.jpg foo.png foo.ppm
fi

if [ "$1" = "file" -o -z "$1" ]; then
tt="file"
xpaget ds9 file >> ${tt}.out

# most functionality tested elsewhere
echo "..fits new"
xpaset -p ds9 file new img16.fits
xpaset -p ds9 frame delete
# backward compatibily, use SAVE and SAVEIMAGE
echo "..file save"
xpaset -p ds9 file img16.fits
xpaset -p ds9 file save foo.fits
echo "..file save gz"
xpaset -p ds9 file save gz foo.fits.gz
echo "..file save resample"
xpaset -p ds9 file save resample foo.fits
echo "..file save resample gz"
xpaset -p ds9 file save resample gz foo.fits.gz
rm -f foo.fits foo.fits.gz
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "first" ]; then
tt="first"
xpaset -p ds9 first open
xpaset -p ds9 first close
xpaset -p ds9 first size 30 30 arcsec
xpaget ds9 first size >> ${tt}.out
xpaset -p ds9 first save no
xpaget ds9 first save >> ${tt}.out
xpaset -p ds9 first frame new
xpaget ds9 first frame >> ${tt}.out
xpaset -p ds9 first update frame
xpaset -p ds9 first m3
xpaset -p ds9 first name m51
xpaget ds9 first name >> ${tt}.out
xpaset -p ds9 first name {}
xpaset -p ds9 first coord 13:29:52.37 +47:11:40.8 sexagesimal
xpaget ds9 first coord >> ${tt}.out
xpaset -p ds9 first update frame
xpaset -p ds9 mode crosshair
xpaset -p ds9 first update crosshair
xpaset -p ds9 first close
xpaset -p ds9 mode pointer
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "fits" -o -z "$1" ]; then
tt="fits"

echo "..fits new"
cat img16.fits | xpaset ds9 fits new 
xpaset -p ds9 frame delete

echo "..get table"
cat table.fits | xpaset ds9 fits
xpaget ds9 fits table > /dev/null
echo "..get table gz"
xpaget ds9 fits table gz > /dev/null

echo "..get fits"
xpaset -p ds9 file img16.fits
xpaget ds9 fits size >> ${tt}.out
xpaget ds9 fits width >> ${tt}.out
xpaget ds9 fits height >> ${tt}.out
xpaget ds9 fits depth >> ${tt}.out
xpaget ds9 fits bitpix >> ${tt}.out
xpaget ds9 fits type >> ${tt}.out
xpaget ds9 fits size wcs fk5 arcsec >> ${tt}.out
xpaget ds9 fits header >> ${tt}.out
xpaget ds9 fits header 1 >> ${tt}.out
xpaget ds9 fits header keyword "'BITPIX'" >> ${tt}.out
xpaget ds9 fits header 1 keyword "'BITPIX'" >> ${tt}.out
xpaget ds9 fits > /dev/null

echo "..get image"
xpaget ds9 fits image > /dev/null
echo "..get image gz"
xpaget ds9 fits image gz > /dev/null
echo "..get fits resample"
xpaget ds9 fits resample > /dev/null
echo "..get fits resample gz"
xpaget ds9 fits resample gz > /dev/null

xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "frame" -o -z "$1" ]; then
tt="frame"
xpaget ds9 frame lock >> ${tt}.out
xpaget ds9 frame has amplifier >> ${tt}.out
xpaget ds9 frame has datamin >> ${tt}.out
xpaget ds9 frame has datasec >> ${tt}.out
xpaget ds9 frame has detector >> ${tt}.out
xpaget ds9 frame has grid >> ${tt}.out
xpaget ds9 frame has iis >> ${tt}.out
xpaget ds9 frame has irafmin >> ${tt}.out
xpaget ds9 frame has physical >> ${tt}.out
xpaget ds9 frame has smooth >> ${tt}.out
xpaget ds9 frame has contour >> ${tt}.out
xpaget ds9 frame has contour aux >> ${tt}.out
xpaget ds9 frame has fits >> ${tt}.out
xpaget ds9 frame has fits bin >> ${tt}.out
xpaget ds9 frame has fits cube >> ${tt}.out
xpaget ds9 frame has fits mosaic >> ${tt}.out
xpaget ds9 frame has marker highlite >> ${tt}.out
xpaget ds9 frame has marker paste >> ${tt}.out
xpaget ds9 frame has marker select >> ${tt}.out
xpaget ds9 frame has marker undo >> ${tt}.out
xpaget ds9 frame has system physical >> ${tt}.out
xpaget ds9 frame has wcs wcsa >> ${tt}.out
xpaget ds9 frame has wcs equatorial wcsa >> ${tt}.out
xpaset -p ds9 frame new rgb
xpaset -p ds9 frame delete
xpaset -p ds9 frame new 3d
xpaset -p ds9 frame delete
xpaset -p ds9 frame new
xpaset -p ds9 file img16.fits
xpaset -p ds9 tile
xpaget ds9 frame > /dev/null
xpaget ds9 frame frameno > /dev/null
xpaget ds9 frame all > /dev/null
xpaget ds9 frame active > /dev/null
xpaset -p ds9 frame center
xpaset -p ds9 frame center 1
xpaset -p ds9 frame center all
xpaset -p ds9 frame reset
xpaset -p ds9 frame reset 1
xpaset -p ds9 frame reset all
xpaset -p ds9 frame refresh
xpaset -p ds9 frame refresh 1
xpaset -p ds9 frame refresh all
xpaset -p ds9 frame hide
xpaset -p ds9 frame hide 1
xpaset -p ds9 frame hide all
xpaset -p ds9 frame show
xpaset -p ds9 frame show 1
xpaset -p ds9 frame show all
xpaset -p ds9 frame move first
xpaset -p ds9 frame move back
xpaset -p ds9 frame move forward
xpaset -p ds9 frame move last
xpaset -p ds9 frame first
xpaset -p ds9 frame prev
xpaset -p ds9 frame next
xpaset -p ds9 frame last
xpaset -p ds9 frame frameno 1
xpaset -p ds9 frame 2
xpaset -p ds9 frame match wcs
xpaset -p ds9 frame lock wcs
xpaset -p ds9 frame lock none
xpaset -p ds9 frame clear
xpaset -p ds9 frame clear 1
xpaset -p ds9 frame clear all
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete 1
xpaset -p ds9 frame delete all
xpaset -p ds9 file new img16.fits
xpaset -p ds9 rgb close
xpaset -p ds9 3d close
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "grid" -o -z "$1" ]; then
tt="grid"
xpaset -p ds9 wcs wcs
xpaget ds9 grid >> ${tt}.out
 
xpaget ds9 grid type >> ${tt}.out
xpaget ds9 grid system >> ${tt}.out
xpaget ds9 grid sky >> ${tt}.out
xpaget ds9 grid skyformat >> ${tt}.out

xpaget ds9 grid grid >> ${tt}.out
xpaget ds9 grid grid color >> ${tt}.out
xpaget ds9 grid grid width >> ${tt}.out
xpaget ds9 grid grid style >> ${tt}.out
xpaget ds9 grid grid gap1 >> ${tt}.out
xpaget ds9 grid grid gap2 >> ${tt}.out
 
xpaget ds9 grid axes >> ${tt}.out
xpaget ds9 grid axes color >> ${tt}.out
xpaget ds9 grid axes width >> ${tt}.out
xpaget ds9 grid axes style >> ${tt}.out
xpaget ds9 grid axes type >> ${tt}.out
xpaget ds9 grid axes origin >> ${tt}.out
 
xpaget ds9 grid format1 >> ${tt}.out
xpaget ds9 grid format2 >> ${tt}.out

xpaget ds9 grid tickmarks >> ${tt}.out
xpaget ds9 grid tickmarks color >> ${tt}.out
xpaget ds9 grid tickmarks width >> ${tt}.out
xpaget ds9 grid tickmarks style >> ${tt}.out

xpaget ds9 grid border >> ${tt}.out
xpaget ds9 grid border color >> ${tt}.out
xpaget ds9 grid border width >> ${tt}.out
xpaget ds9 grid border style >> ${tt}.out

xpaget ds9 grid numerics >> ${tt}.out
xpaget ds9 grid numerics font >> ${tt}.out
xpaget ds9 grid numerics fontweight >> ${tt}.out
xpaget ds9 grid numerics fontslant >> ${tt}.out
xpaget ds9 grid numerics fontsize >> ${tt}.out
xpaget ds9 grid numerics color >> ${tt}.out
xpaget ds9 grid numerics gap1 >> ${tt}.out
xpaget ds9 grid numerics gap2 >> ${tt}.out
xpaget ds9 grid numerics type >> ${tt}.out
xpaget ds9 grid numerics vertical >> ${tt}.out

xpaget ds9 grid title >> ${tt}.out
xpaget ds9 grid title text >> ${tt}.out
xpaget ds9 grid title def >> ${tt}.out
xpaget ds9 grid title gap >> ${tt}.out
xpaget ds9 grid title font >> ${tt}.out
xpaget ds9 grid title fontweight >> ${tt}.out
xpaget ds9 grid title fontslant >> ${tt}.out
xpaget ds9 grid title fontsize >> ${tt}.out
xpaget ds9 grid title color >> ${tt}.out

xpaget ds9 grid labels >> ${tt}.out
xpaget ds9 grid labels text1 >> ${tt}.out
xpaget ds9 grid labels def1 >> ${tt}.out
xpaget ds9 grid labels gap1 >> ${tt}.out
xpaget ds9 grid labels text2 >> ${tt}.out
xpaget ds9 grid labels def2 >> ${tt}.out
xpaget ds9 grid labels gap2 >> ${tt}.out
xpaget ds9 grid labels font >> ${tt}.out
xpaget ds9 grid labels fontweight >> ${tt}.out
xpaget ds9 grid labels fontslant >> ${tt}.out
xpaget ds9 grid labels fontsize >> ${tt}.out
xpaget ds9 grid labels color >> ${tt}.out

xpaset -p ds9 grid open
xpaset -p ds9 grid close

xpaset -p ds9 grid
xpaset -p ds9 grid yes
 
xpaset -p ds9 grid type analysis
xpaset -p ds9 grid system wcs
xpaset -p ds9 grid sky fk5
xpaset -p ds9 grid skyformat degrees

xpaset -p ds9 grid grid yes
xpaset -p ds9 grid grid color red
xpaset -p ds9 grid grid width 2
xpaset -p ds9 grid grid style 1
xpaset -p ds9 grid grid gap1 .01
xpaset -p ds9 grid grid gap2 .01
 
xpaset -p ds9 grid axes yes
xpaset -p ds9 grid axes color red
xpaset -p ds9 grid axes width 2
xpaset -p ds9 grid axes style 1
xpaset -p ds9 grid axes type exterior
xpaset -p ds9 grid axes origin lll
 
xpaset -p ds9 grid format1 d.2
xpaset -p ds9 grid format2 d.2

xpaset -p ds9 grid tickmarks yes
xpaset -p ds9 grid tickmarks color red
xpaset -p ds9 grid tickmarks width 2
xpaset -p ds9 grid tickmarks style 1

xpaset -p ds9 grid border yes
xpaset -p ds9 grid border color red
xpaset -p ds9 grid border width 2
xpaset -p ds9 grid border style 1

xpaset -p ds9 grid numerics yes
xpaset -p ds9 grid numerics font courier
xpaset -p ds9 grid numerics fontweight bold
xpaset -p ds9 grid numerics fontslant roman
xpaset -p ds9 grid numerics fontsize 12
xpaset -p ds9 grid numerics color red
xpaset -p ds9 grid numerics gap1 10
xpaset -p ds9 grid numerics gap2 10
xpaset -p ds9 grid numerics type exterior
xpaset -p ds9 grid numerics vertical yes

xpaset -p ds9 grid title yes
xpaset -p ds9 grid title text {Hello World}
xpaset -p ds9 grid title def yes
xpaset -p ds9 grid title gap 10
xpaset -p ds9 grid title font courier
xpaset -p ds9 grid title fontweight bold
xpaset -p ds9 grid title fontslant roman
xpaset -p ds9 grid title fontsize 12
xpaset -p ds9 grid title color red

xpaset -p ds9 grid labels yes
xpaset -p ds9 grid labels text1 {Hello World}
xpaset -p ds9 grid labels def1 yes
xpaset -p ds9 grid labels gap1 10
xpaset -p ds9 grid labels text2 {Hello World}
xpaset -p ds9 grid labels def2 yes
xpaset -p ds9 grid labels gap2 10
xpaset -p ds9 grid labels font courier
xpaset -p ds9 grid labels fontweight bold
xpaset -p ds9 grid labels fontslant roman
xpaset -p ds9 grid labels fontsize 12
xpaset -p ds9 grid labels color red

xpaset -p ds9 grid save foo.grd
xpaset -p ds9 grid load foo.grd
xpaset -p ds9 grid reset

xpaset -p ds9 grid no
xpaset -p ds9 grid close
testit $tt
fi

if [ "$1" = "header" -o -z "$1" ]; then
tt="header"
xpaset -p ds9 header
xpaset -p ds9 header save foo.txt
xpaset -p ds9 header close
xpaset -p ds9 header 1
xpaset -p ds9 header close 1
testit $tt
fi

if [ "$1" = "height" -o -z "$1" ]; then
tt="height"
xpaget ds9 height >> /dev/null
xpaset -p ds9 height 443
testit $tt
fi

if [ "$1" = "iconify" -o -z "$1" ]; then
tt="iconify"
xpaget ds9 iconify >> ${tt}.out
xpaset -p ds9 iconify
xpaset -p ds9 iconify yes
xpaset -p ds9 iconify no
testit $tt
fi

if [ "$1" = "iis" -o -z "$1" ]; then
tt="iis"
xpaget ds9 iis filename >> ${tt}.out
xpaget ds9 iis filename 1 >> ${tt}.out
xpaset -p ds9 iis filename foo.fits
xpaset -p ds9 iis filename foo.fits 1
testit $tt
fi

if [ "$1" = "imexam" ]; then
tt="imexam"
echo "Select coordinate point:"
xpaget ds9 imexam coordinate wcs fk5 degrees
echo "  ok"
sleep "$delay"
echo "Press key:"
xpaget ds9 imexam key coordinate wcs fk5 degrees
echo "  ok"
sleep "$delay"
echo "Press either:"
xpaget ds9 imexam any coordinate wcs fk5 degrees
echo "  ok"
sleep "$delay"
echo "Select value point:"
xpaget ds9 imexam data
echo "  ok"
sleep "$delay"
echo "Press key:"
xpaget ds9 imexam key data
echo "  ok"
sleep "$delay"
echo "Press any:"
xpaget ds9 imexam any data
echo "  ok"
sleep "$delay"
testit $tt
fi

if [ "$1" = "lock" -o -z "$1" ]; then
tt="lock"
xpaget ds9 lock frame >> ${tt}.out
xpaget ds9 lock crosshair >> ${tt}.out
xpaget ds9 lock crop >> ${tt}.out
xpaget ds9 lock slice >> ${tt}.out
xpaget ds9 lock bin >> ${tt}.out
xpaget ds9 lock scale >> ${tt}.out
xpaget ds9 lock colorbar >> ${tt}.out
xpaget ds9 lock smooth >> ${tt}.out
xpaset -p ds9 file new img16.fits
xpaset -p ds9 tile
xpaset -p ds9 mode crosshair
xpaset -p ds9 lock frame wcs
xpaset -p ds9 lock frame none
xpaset -p ds9 lock crosshair wcs
xpaset -p ds9 crosshair 13:29:56 +47:11:38 wcs fk5
xpaset -p ds9 lock crosshair none
xpaset -p ds9 lock crop wcs
xpaset -p ds9 lock crop none
xpaset -p ds9 lock slice yes
xpaset -p ds9 lock slice no
xpaset -p ds9 lock bin yes
xpaset -p ds9 lock bin no
xpaset -p ds9 lock scale yes
xpaset -p ds9 lock scale no
xpaset -p ds9 lock colorbar yes
xpaset -p ds9 lock colorbar no
xpaset -p ds9 lock smooth yes
xpaset -p ds9 lock smooth no
xpaset -p ds9 mode pointer
xpaset -p ds9 frame delete
xpaset -p ds9 wcs align no
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "lower" -o -z "$1" ]; then
tt="lower"
xpaget ds9 iconify >> ${tt}.out
xpaset -p ds9 lower
xpaset -p ds9 raise
testit $tt
fi

if [ "$1" = "magnifier" -o -z "$1" ]; then
tt="magnifier"
xpaget ds9 magnifier color >> ${tt}.out
xpaget ds9 magnifier zoom >> ${tt}.out
xpaget ds9 magnifier cursor >> ${tt}.out
xpaget ds9 magnifier region >> ${tt}.out
xpaset -p ds9 magnifier color white
xpaset -p ds9 magnifier zoom 4
xpaset -p ds9 magnifier cursor yes
xpaset -p ds9 magnifier region yes
testit $tt
fi

if [ "$1" = "mask" -o -z "$1" ]; then
tt="mask"
xpaget ds9 mask color >> ${tt}.out
xpaget ds9 mask mark >> ${tt}.out
xpaget ds9 mask transparency >> ${tt}.out
xpaset -p ds9 mask open
xpaset -p ds9 mask color red
xpaset -p ds9 file mask mask.fits
sleep "$delay"
xpaset -p ds9 mask color cyan
xpaset -p ds9 file mask mask2.fits
sleep "$delay"
xpaset -p ds9 mask clear
xpaset -p ds9 mask color red
xpaset -p ds9 mask close
sleep "$delay"
testit $tt
fi

if [ "$1" = "match" -o -z "$1" ]; then
tt="match"
xpaset -p ds9 file new img-32.fits
xpaset -p ds9 tile
xpaset -p ds9 mode crosshair
xpaset -p ds9 match frame wcs
xpaset -p ds9 match frame image
xpaset -p ds9 match crosshair wcs
xpaset -p ds9 match crop wcs
xpaset -p ds9 match slice
xpaset -p ds9 match bin
xpaset -p ds9 match scale
xpaset -p ds9 match colorbar
xpaset -p ds9 match smooth
xpaset -p ds9 frame delete
xpaset -p ds9 mode pointer
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "minmax" -o -z "$1" ]; then
tt="minmax"
xpaget ds9 minmax >> ${tt}.out
xpaget ds9 minmax mode >> ${tt}.out
xpaget ds9 minmax sample >> ${tt}.out
xpaset -p ds9 minmax scan
xpaset -p ds9 minmax mode scan
xpaset -p ds9 minmax interval 10
testit $tt
fi

if [ "$1" = "mode" -o -z "$1" ]; then
tt="mode"
xpaget ds9 mode >> ${tt}.out
xpaset -p ds9 mode none
xpaset -p ds9 mode crosshair
xpaset -p ds9 mode colorbar
xpaset -p ds9 mode pan
xpaset -p ds9 mode zoom
xpaset -p ds9 mode rotate
xpaset -p ds9 mode catalog
xpaset -p ds9 mode examine
xpaset -p ds9 mode pointer
testit $tt
fi

# movie will fail if moved from corner
if [ "$1" = "movie" -o -z "$1" ]; then
tt="movie"
xpaset -p ds9 width 715
xpaset -p ds9 height 450
xpaset -p ds9 movie slice foo.mpg
xpaset -p ds9 movie frame foo.mpg
xpaset -p ds9 frame new 3d
xpaset -p ds9 movie 3d foo.mpg number 1 azfrom 0 azto 0 elfrom 0 elto 0 slfrom 1 slto 1 repeat 1
xpaset -p ds9 frame delete

# backward compatibility
xpaset -p ds9 savempeg foo.mpg

testit $tt
rm -f foo.mpg
fi

if [ "$1" = "nameserver" -o -z "$1" ]; then
tt="nameserver"
xpaset -p ds9 nameserver open
xpaset -p ds9 nameserver close
xpaset -p ds9 nameserver m51
xpaget ds9 nameserver >> ${tt}.out
xpaget ds9 nameserver server >> ${tt}.out
xpaget ds9 nameserver skyformat >> ${tt}.out
xpaget ds9 nameserver m51 >> ${tt}.out
xpaset -p ds9 nameserver name m51
xpaset -p ds9 nameserver server simbad-cds
xpaset -p ds9 nameserver skyformat degrees
xpaset -p ds9 mode crosshair
xpaset -p ds9 nameserver crosshair
xpaset -p ds9 nameserver pan
xpaset -p ds9 nameserver close
xpaset -p ds9 mode pointer
xpaset -p ds9 frame reset
testit $tt
fi

if [ "$1" = "nan" -o -z "$1" ]; then
tt="nan"
xpaget ds9 nan >> ${tt}.out
xpaset -p ds9 nan blue
xpaset -p ds9 prefs nancolor white
testit $tt
fi

if [ "$1" = "nvss" -o -z "$1" ]; then
tt="nvss"
xpaset -p ds9 nvss open
xpaset -p ds9 nvss close
xpaset -p ds9 nvss size 30 30 arcsec
xpaget ds9 nvss size >> ${tt}.out
xpaset -p ds9 nvss save no
xpaget ds9 nvss save >> ${tt}.out
xpaset -p ds9 nvss frame new
xpaget ds9 nvss frame >> ${tt}.out
xpaset -p ds9 nvss update frame
xpaset -p ds9 nvss m3
xpaset -p ds9 nvss name m51
xpaget ds9 nvss name >> ${tt}.out
xpaset -p ds9 nvss name {}
xpaset -p ds9 nvss coord 13:29:52.37 +47:11:40.8 sexagesimal
xpaget ds9 nvss coord >> ${tt}.out
xpaset -p ds9 nvss update frame
xpaset -p ds9 mode crosshair
xpaset -p ds9 nvss update crosshair
xpaset -p ds9 nvss close
xpaset -p ds9 mode pointer
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "orient" -o -z "$1" ]; then
tt="orient"
xpaset -p ds9 orient open
xpaset -p ds9 orient none
xpaset -p ds9 orient x
xpaset -p ds9 orient y
xpaset -p ds9 orient xy
xpaset -p ds9 orient close
xpaget ds9 orient >> ${tt}.out
xpaset -p ds9 frame reset
testit $tt
fi

if [ "$1" = "pagesetup" -o -z "$1" ]; then
tt="pagesetup"
xpaget ds9 pspagesetup orient >> ${tt}.out
xpaget ds9 pspagesetup scale >> ${tt}.out
xpaget ds9 pspagesetup size >> ${tt}.out
xpaset -p ds9 pspagesetup orient portrait
xpaset -p ds9 pspagesetup scale 100
xpaset -p ds9 pspagesetup size letter
testit $tt
fi

if [ "$1" = "pan" -o -z "$1" ]; then
tt="pan"
xpaget ds9 pan physical >> ${tt}.out
xpaget ds9 pan wcs fk5 sexagesimal >> ${tt}.out
xpaset -p ds9 pan open
xpaset -p ds9 pan 100 100 image
xpaset -p ds9 pan to 13:29:55.666 +47:12:16.29 wcs fk5
xpaset -p ds9 pan close
xpaset -p ds9 frame reset
testit $tt
fi

if [ "$1" = "pixeltable" -o -z "$1" ]; then
tt="pixeltable"
xpaget ds9 pixeltable >> ${tt}.out
xpaset -p ds9 pixeltable
xpaset -p ds9 pixeltable yes
xpaset -p ds9 pixeltable no
xpaset -p ds9 pixeltable open
xpaset -p ds9 pixeltable close
testit $tt
fi

if [ "$1" = "plot" -o -z "$1" ]; then
tt="plot"
echo "..empty plot"
xpaset -p ds9 plot
xpaget ds9 plot >> ${tt}.out
sleep "$delay"
xpaset -p ds9 plot close

xpaset -p ds9 plot new
xpaset -p ds9 plot new bar
xpaset -p ds9 plot new scatter
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

xpaset -p ds9 plot new name foo
xpaset -p ds9 plot new name foo bar
xpaset -p ds9 plot new name foo scatter
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

xpaset -p ds9 plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xy
xpaset -p ds9 plot new name foo bar "{The Title}" "{X Axis}" "{Y Axis}" xy
xpaset -p ds9 plot new name foo scatter "{The Title}" "{X Axis}" "{Y Axis}" xy
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..stdin 2|3|4|5"
cat stdin.2.dat | xpaset ds9 plot new stdin
cat stdin.3.dat | xpaset ds9 plot new stdin
cat stdin.4.dat | xpaset ds9 plot new stdin
cat stdin.5.dat | xpaset ds9 plot new stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat stdin.2.dat | xpaset ds9 plot new bar stdin
cat stdin.3.dat | xpaset ds9 plot new bar stdin
cat stdin.4.dat | xpaset ds9 plot new bar stdin
cat stdin.5.dat | xpaset ds9 plot new bar stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat stdin.2.dat | xpaset ds9 plot new scatter stdin
cat stdin.3.dat | xpaset ds9 plot new scatter stdin
cat stdin.4.dat | xpaset ds9 plot new scatter stdin
cat stdin.5.dat | xpaset ds9 plot new scatter stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..named stdin 2|3|4|5"
cat stdin.2.dat | xpaset ds9 plot new name foo stdin
cat stdin.3.dat | xpaset ds9 plot new name foo stdin
cat stdin.4.dat | xpaset ds9 plot new name foo stdin
cat stdin.5.dat | xpaset ds9 plot new name foo stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat stdin.2.dat | xpaset ds9 plot new name foo bar stdin
cat stdin.3.dat | xpaset ds9 plot new name foo bar stdin
cat stdin.4.dat | xpaset ds9 plot new name foo bar stdin
cat stdin.5.dat | xpaset ds9 plot new name foo bar stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat stdin.2.dat | xpaset ds9 plot new name foo scatter stdin
cat stdin.3.dat | xpaset ds9 plot new name foo scatter stdin
cat stdin.4.dat | xpaset ds9 plot new name foo scatter stdin
cat stdin.5.dat | xpaset ds9 plot new name foo scatter stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..stdin xy|xyex|xyey|xyexey"
cat stdin.xy.dat | xpaset ds9 plot new stdin
cat stdin.xyex.dat | xpaset ds9 plot new stdin
cat stdin.xyey.dat | xpaset ds9 plot new stdin
cat stdin.xyexey.dat | xpaset ds9 plot new stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat stdin.xy.dat | xpaset ds9 plot new bar stdin
cat stdin.xyex.dat | xpaset ds9 plot new bar stdin
cat stdin.xyey.dat | xpaset ds9 plot new bar stdin
cat stdin.xyexey.dat | xpaset ds9 plot new bar stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat stdin.xy.dat | xpaset ds9 plot new scatter stdin
cat stdin.xyex.dat | xpaset ds9 plot new scatter stdin
cat stdin.xyey.dat | xpaset ds9 plot new scatter stdin
cat stdin.xyexey.dat | xpaset ds9 plot new scatter stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..named stdin xy|xyex|xyey|xyexey"
cat stdin.xy.dat | xpaset ds9 plot new name foo stdin
cat stdin.xyex.dat | xpaset ds9 plot new name foo stdin
cat stdin.xyey.dat | xpaset ds9 plot new name foo stdin
cat stdin.xyexey.dat | xpaset ds9 plot new name foo stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat stdin.xy.dat | xpaset ds9 plot new name foo bar stdin
cat stdin.xyex.dat | xpaset ds9 plot new name foo bar stdin
cat stdin.xyey.dat | xpaset ds9 plot new name foo bar stdin
cat stdin.xyexey.dat | xpaset ds9 plot new name foo bar stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat stdin.xy.dat | xpaset ds9 plot new name foo scatter stdin
cat stdin.xyex.dat | xpaset ds9 plot new name foo scatter stdin
cat stdin.xyey.dat | xpaset ds9 plot new name foo scatter stdin
cat stdin.xyexey.dat | xpaset ds9 plot new name foo scatter stdin
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..stdin text|error"
cat stdin.error.dat | xpaset ds9 plot new stdin
cat stdin.text.dat | xpaset ds9 plot new stdin
sleep "$delay"
xpaset -p ds9 plot close

echo "..named stdin text|error"
cat stdin.error.dat | xpaset ds9 plot new name foo stdin
cat stdin.text.dat | xpaset ds9 plot new name foo stdin
sleep "$delay"
xpaset -p ds9 plot close

echo "..4|5"
cat 4.dat | xpaset ds9 plot new "{The Title}" "{X Axis}" "{Y Axis}" 4
cat 5.dat | xpaset ds9 plot new "{The Title}" "{X Axis}" "{Y Axis}" 5
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat 4.dat | xpaset ds9 plot new bar "{The Title}" "{X Axis}" "{Y Axis}" 4
cat 5.dat | xpaset ds9 plot new bar "{The Title}" "{X Axis}" "{Y Axis}" 5
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat 4.dat | xpaset ds9 plot new scatter "{The Title}" "{X Axis}" "{Y Axis}" 4
cat 5.dat | xpaset ds9 plot new scatter "{The Title}" "{X Axis}" "{Y Axis}" 5
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..named 4|5"
cat 4.dat | xpaset ds9 plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" 4
cat 5.dat | xpaset ds9 plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" 5
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat 4.dat | xpaset ds9 plot new name foo bar "{The Title}" "{X Axis}" "{Y Axis}" 4
cat 5.dat | xpaset ds9 plot new name foo bar "{The Title}" "{X Axis}" "{Y Axis}" 5
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat 4.dat | xpaset ds9 plot new name foo scatter "{The Title}" "{X Axis}" "{Y Axis}" 4
cat 5.dat | xpaset ds9 plot new name foo scatter "{The Title}" "{X Axis}" "{Y Axis}" 5
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..xy|xyex|xyey|xyexey"
cat xy.dat | xpaset ds9 plot new "{The Title}" "{X Axis}" "{Y Axis}" xy
cat xyex.dat | xpaset ds9 plot new "{The Title}" "{X Axis}" "{Y Axis}" xyex
cat xyey.dat | xpaset ds9 plot new "{The Title}" "{X Axis}" "{Y Axis}" xyey
cat xyexey.dat | xpaset ds9 plot new "{The Title}" "{X Axis}" "{Y Axis}" xyexey
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat xy.dat | xpaset ds9 plot new bar "{The Title}" "{X Axis}" "{Y Axis}" xy
cat xyex.dat | xpaset ds9 plot new bar "{The Title}" "{X Axis}" "{Y Axis}" xyex
cat xyey.dat | xpaset ds9 plot new bar "{The Title}" "{X Axis}" "{Y Axis}" xyey
cat xyexey.dat | xpaset ds9 plot new bar "{The Title}" "{X Axis}" "{Y Axis}" xyexey
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat xy.dat | xpaset ds9 plot new scatter "{The Title}" "{X Axis}" "{Y Axis}" xy
cat xyex.dat | xpaset ds9 plot new scatter "{The Title}" "{X Axis}" "{Y Axis}" xyex
cat xyey.dat | xpaset ds9 plot new scatter "{The Title}" "{X Axis}" "{Y Axis}" xyey
cat xyexey.dat | xpaset ds9 plot new scatter "{The Title}" "{X Axis}" "{Y Axis}" xyexey
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..name xy|xyex|xyey|xyexey"
cat xy.dat | xpaset ds9 plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xy
cat xyex.dat | xpaset ds9 plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xyex
cat xyey.dat | xpaset ds9 plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xyey
cat xyexey.dat | xpaset ds9 plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xyexey
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat xy.dat | xpaset ds9 plot new name foo bar "{The Title}" "{X Axis}" "{Y Axis}" xy
cat xyex.dat | xpaset ds9 plot new name foo bar "{The Title}" "{X Axis}" "{Y Axis}" xyex
cat xyey.dat | xpaset ds9 plot new name foo bar "{The Title}" "{X Axis}" "{Y Axis}" xyey
cat xyexey.dat | xpaset ds9 plot new name foo bar "{The Title}" "{X Axis}" "{Y Axis}" xyexey
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

cat xy.dat | xpaset ds9 plot new name foo scatter "{The Title}" "{X Axis}" "{Y Axis}" xy
cat xyex.dat | xpaset ds9 plot new name foo scatter "{The Title}" "{X Axis}" "{Y Axis}" xyex
cat xyey.dat | xpaset ds9 plot new name foo scatter "{The Title}" "{X Axis}" "{Y Axis}" xyey
cat xyexey.dat | xpaset ds9 plot new name foo scatter "{The Title}" "{X Axis}" "{Y Axis}" xyexey
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..data"
xpaset -p ds9 plot new name foo
xpaset -p ds9 plot new
cat xy.dat | xpaset ds9 plot foo data xy
cat xy.dat | xpaset ds9 plot data xy
sleep "$delay"
xpaset -p ds9 plot close
xpaset -p ds9 plot close

echo "..clear/close"
cat stdin.xy.dat | xpaset ds9 plot new stdin
xpaset -p ds9 plot clear
sleep "$delay"
xpaset -p ds9 plot close

echo "..save/load"
xpaset -p ds9 plot new
xpaset -p ds9 plot load xy.dat xy
xpaset -p ds9 plot save foo.dat
xpaset -p ds9 plot saveconfig foo.plt
xpaset -p ds9 plot loadconfig foo.plt
sleep "$delay"
xpaset -p ds9 plot close
rm -f foo.dat foo.plt

echo "..print"
xpaset -p ds9 plot new
#xpaset -p ds9 plot print
xpaset -p ds9 plot print destination printer
xpaset -p ds9 plot print command "lp"
xpaset -p ds9 plot print filename "foo.ps"
xpaset -p ds9 plot print color rgb
xpaset -p ds9 plot pagesetup orient portrait
xpaset -p ds9 plot pagesetup size letter
sleep "$delay"
xpaset -p ds9 plot close
rm -f foo.ps

echo "..grid"
xpaset -p ds9 plot new
xpaset -p ds9 plot load xy.dat xy
xpaset -p ds9 plot graph grid x no
xpaset -p ds9 plot graph grid y yes
xpaset -p ds9 plot graph log x no
xpaset -p ds9 plot graph log y no
xpaset -p ds9 plot graph flip x no
xpaset -p ds9 plot graph flip y no
xpaset -p ds9 plot graph range x min 1
xpaset -p ds9 plot graph range x max 100
xpaset -p ds9 plot graph range y min 1
xpaset -p ds9 plot graph range y max 100
xpaset -p ds9 plot graph range x auto yes
xpaset -p ds9 plot graph range y auto yes
xpaset -p ds9 plot graph format x {}
xpaset -p ds9 plot graph format y {}
xpaset -p ds9 plot graph labels title "{The Title}"
xpaset -p ds9 plot graph labels xaxis "{X Axis}"
xpaset -p ds9 plot graph labels yaxis "{Y Axis}"

xpaset -p ds9 plot font numbers font times
xpaset -p ds9 plot font numbers size 12
xpaset -p ds9 plot font numbers weight bold
xpaset -p ds9 plot font numbers slant roman
xpaset -p ds9 plot font labels font times
xpaset -p ds9 plot font labels size 12
xpaset -p ds9 plot font labels weight bold
xpaset -p ds9 plot font labels slant roman
xpaset -p ds9 plot font title font times
xpaset -p ds9 plot font title size 12
xpaset -p ds9 plot font title weight bold
xpaset -p ds9 plot font title slant roman
sleep "$delay"
xpaset -p ds9 plot close

echo "..dataset"
xpaset -p ds9 plot new
cat xy.dat | xpaset ds9 plot data xy
cat xyey.dat | xpaset ds9 plot data xyey
xpaset -p ds9 plot dataset 2

xpaset -p ds9 plot view discrete yes
xpaset -p ds9 plot view line yes
xpaset -p ds9 plot view step yes
xpaset -p ds9 plot view quadratic yes
xpaset -p ds9 plot view errorbar yes

xpaset -p ds9 plot color discrete red
xpaset -p ds9 plot color line green
xpaset -p ds9 plot color step blue
xpaset -p ds9 plot color quadratic cyan
xpaset -p ds9 plot color errorbar yellow
xpaset -p ds9 plot color errorbar magenta

xpaset -p ds9 plot line discrete cross
xpaset -p ds9 plot line line width 2
xpaset -p ds9 plot line line dash yes
xpaset -p ds9 plot line step width 2
xpaset -p ds9 plot line step dash yes
xpaset -p ds9 plot line quadratic width 2
xpaset -p ds9 plot line quadratic dash yes
xpaset -p ds9 plot line errorbar width 2
xpaset -p ds9 plot line errorbar style 2
sleep "$delay"
xpaset -p ds9 plot close

testit $tt
fi

if [ "$1" = "prefs" -o -z "$1" ]; then
tt="prefs"
xpaset -p ds9 prefs clear
testit $tt
fi

if [ "$1" = "preserve" -o -z "$1" ]; then
tt="preserve"
xpaget ds9 preserve scale >> ${tt}.out
xpaget ds9 preserve pan >> ${tt}.out
xpaget ds9 preserve regions >> ${tt}.out

xpaset -p ds9 preserve scale no
xpaset -p ds9 preserve pan no
xpaset -p ds9 preserve regions no
testit $tt
fi

if [ "$1" = "print" -o -z "$1" ]; then
tt="print"
xpaget ds9 psprint destination >> ${tt}.out
xpaget ds9 psprint command >> ${tt}.out
xpaget ds9 psprint color >> ${tt}.out
xpaget ds9 psprint level >> ${tt}.out
xpaget ds9 psprint resolution >> ${tt}.out
#xpaset -p ds9 psprint
xpaset -p ds9 psprint destination printer
xpaset -p ds9 psprint command lp
xpaset -p ds9 psprint filename ds9.ps
xpaset -p ds9 psprint color rgb
xpaset -p ds9 psprint level 2
xpaset -p ds9 psprint resolution 150
testit $tt
fi

if [ "$1" = "regions" -o -z "$1" ]; then
tt="regions"
xpaset -p ds9 regions delete all
xpaset -p ds9 regions system physical
xpaset -p ds9 regions sky fk5
xpaset -p ds9 regions skyformat degrees
echo "physical;circle(957,1027,40) # tag=foo" | xpaset ds9 regions

xpaget ds9 regions >> ${tt}.out
xpaget ds9 regions show >> ${tt}.out
xpaget ds9 regions showtext >> ${tt}.out
xpaget ds9 regions centroid auto >> ${tt}.out
xpaget ds9 regions centroid radius >> ${tt}.out
xpaget ds9 regions centroid iteration >> ${tt}.out
xpaget ds9 regions -format pros -system wcs -sky fk5 -skyformat sexagesimal -delim nl -prop edit 1 -group foo -strip yes >> ${tt}.out
xpaget ds9 regions include >> ${tt}.out
xpaget ds9 regions exclude >> ${tt}.out
xpaget ds9 regions source >> ${tt}.out
xpaget ds9 regions background >> ${tt}.out
xpaget ds9 regions selected >> ${tt}.out

xpaget ds9 regions format >> ${tt}.out
xpaget ds9 regions system >> ${tt}.out
xpaget ds9 regions sky >> ${tt}.out
xpaget ds9 regions skyformat >> ${tt}.out
xpaget ds9 regions strip >> ${tt}.out
xpaget ds9 regions shape >> ${tt}.out
xpaget ds9 regions color >> ${tt}.out
xpaget ds9 regions width >> ${tt}.out
xpaget ds9 regions delim >> ${tt}.out
xpaget ds9 regions groups >> ${tt}.out

echo "image; circle 100 100 20" | xpaset ds9 regions
echo "fk5; circle 13:29:55 47:11:50 .5'" | xpaset ds9 regions
echo "physical; ellipse 100 100 20 40" | xpaset ds9 regions
echo "box 100 100 20 40 25" | xpaset ds9 regions
echo "image; line 100 100 200 400" | xpaset ds9 regions
echo "physical; ruler 200 300 200 400" | xpaset ds9 regions
echo "image; text 100 100 # text={Hello, World}" | xpaset ds9 regions
echo "fk4; boxcircle point 13:29:55 47:11:50" | xpaset ds9 regions
xpaset -p ds9 regions delete all

xpaset -p ds9 regions ds9.physical.reg
xpaset -p ds9 regions delete all
xpaset -p ds9 regions load ds9.physical.reg
xpaset -p ds9 regions delete all
xpaset -p ds9 regions load 'ds9.fk5*.reg'
xpaset -p ds9 regions delete all
xpaset -p ds9 regions load all ds9.physical.reg
xpaset -p ds9 regions save foo.reg
xpaset -p ds9 regions list
xpaset -p ds9 regions list close
xpaset -p ds9 regions delete all
rm -f foo.reg

xpaset -p ds9 regions show yes
xpaset -p ds9 regions showtext yes
xpaset -p ds9 regions centroid
xpaset -p ds9 regions centroid auto no
xpaset -p ds9 regions centroid radius 10
xpaset -p ds9 regions centroid iteration 30
#xpaset -p ds9 regions getinfo
xpaset -p ds9 regions move front
xpaset -p ds9 regions move back
xpaset -p ds9 regions select all
xpaset -p ds9 regions select none
xpaset -p ds9 regions delete all
xpaset -p ds9 regions delete select
xpaset -p ds9 regions format ds9
xpaset -p ds9 regions system physical
xpaset -p ds9 regions sky fk5
xpaset -p ds9 regions skyformat degrees
xpaset -p ds9 regions delim nl
xpaset -p ds9 regions strip no
xpaset -p ds9 regions shape circle
xpaset -p ds9 regions color green
xpaset -p ds9 regions width 1
xpaset -p ds9 regions edit yes
xpaset -p ds9 regions include
xpaset -p ds9 regions command {circle 100 100 20}

xpaset -p ds9 regions group new
xpaset -p ds9 regions group foo new
xpaset -p ds9 regions group foo update
xpaset -p ds9 regions group foo select
xpaset -p ds9 regions group foo color red
xpaset -p ds9 regions group foo copy
xpaset -p ds9 regions group foo delete
xpaset -p ds9 regions group foo cut
xpaset -p ds9 regions group foo font {time 14 bold}
xpaset -p ds9 regions group foo move 100 100
xpaset -p ds9 regions group foo movefront
xpaset -p ds9 regions group foo moveback
xpaset -p ds9 regions group foo property delete no

xpaset -p ds9 regions delete all

xpaset -p ds9 regions command {circle 100 100 20}
xpaset -p ds9 regions select all
xpaset -p ds9 regions copy
xpaset -p ds9 regions cut
xpaset -p ds9 regions paste
xpaset -p ds9 regions undo
xpaset -p ds9 regions delete all

xpaset -p ds9 regions load ds9.physical.reg
xpaset -p ds9 regions select all
xpaset -p ds9 regions composite
xpaset -p ds9 regions desolve
xpaset -p ds9 regions delete all

xpaset -p ds9 regions command {circle 100 100 20}
xpaset -p ds9 regions savetemplate foo.tpl
xpaset -p ds9 regions delete all
xpaset -p ds9 regions template foo.tpl
xpaset -p ds9 regions delete all
xpaset -p ds9 regions template foo.tpl at 202.46963 47.19556 fk5
xpaset -p ds9 regions delete all
rm -f foo.tpl

testit $tt
fi

if [ "$1" = "rgb" -o -z "$1" ]; then
tt="rgb"
xpaset -p ds9 rgb open
xpaset -p ds9 rgb close
xpaset -p ds9 rgb
xpaget ds9 rgb channel >> ${tt}.out
xpaget ds9 rgb view red >> ${tt}.out
xpaget ds9 rgb view green >> ${tt}.out
xpaget ds9 rgb view blue >> ${tt}.out
xpaget ds9 rgb system >> ${tt}.out
xpaget ds9 rgb lock wcs >> ${tt}.out
xpaget ds9 rgb lock crop >> ${tt}.out
xpaget ds9 rgb lock slice >> ${tt}.out
xpaget ds9 rgb lock bin >> ${tt}.out
xpaget ds9 rgb lock scale >> ${tt}.out
xpaget ds9 rgb lock colorbar >> ${tt}.out
xpaget ds9 rgb lock smooth >> ${tt}.out
xpaset -p ds9 rgb green
xpaset -p ds9 rgb channel blue
xpaset -p ds9 rgb view blue off
xpaset -p ds9 rgb system wcs
xpaset -p ds9 rgb lock crop wcs
xpaset -p ds9 rgb lock crop yes
xpaset -p ds9 rgb lock slice yes
xpaset -p ds9 rgb lock bin yes
xpaset -p ds9 rgb lock scale yes
xpaset -p ds9 rgb lock colorbar yes
xpaset -p ds9 rgb lock smooth yes
xpaset -p ds9 rgb close
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "rotate" -o -z "$1" ]; then
tt="rotate"
xpaget ds9 rotate >> ${tt}.out
xpaset -p ds9 rotate open
xpaset -p ds9 rotate to 30
xpaset -p ds9 rotate 15
xpaset -p ds9 rotate close
xpaset -p ds9 frame reset
testit $tt
fi

if [ "$1" = "save" -o -z "$1" ]; then
tt="save"
xpaset -p ds9 save foo.fits
xpaset -p ds9 save foo.fits image
testit $tt
rm -f foo.fits
fi

if [ "$1" = "saveimage" -o -z "$1" ]; then
tt="saveimage"
xpaset -p ds9 saveimage foo.fits
xpaset -p ds9 saveimage foo.gif
xpaset -p ds9 saveimage foo.tif
xpaset -p ds9 saveimage foo.tif none
xpaset -p ds9 saveimage foo.jpg
xpaset -p ds9 saveimage foo.jpg 100
xpaset -p ds9 saveimage foo.png
xpaset -p ds9 saveimage foo.ppm

# backward compatibility
xpaset -p ds9 saveimage fits foo.fits
xpaset -p ds9 saveimage jpeg foo.jpg
xpaset -p ds9 saveimage jpeg 100 foo.jpg
xpaset -p ds9 saveimage tiff foo.tif
xpaset -p ds9 saveimage tiff deflate foo.tif
xpaset -p ds9 saveimage png foo.png
xpaset -p ds9 saveimage ppm foo.ppm
xpaset -p ds9 saveimage mpeg foo.mpg

testit $tt
rm -f foo.fits foo.jpg foo.tif foo.png foo.ppm foo.mpg
fi

if [ "$1" = "scale" -o -z "$1" ]; then
tt="scale"
xpaget ds9 scale >> ${tt}.out
xpaget ds9 scale log exp >> ${tt}.out
xpaget ds9 scale limits >> ${tt}.out
xpaget ds9 scale mode >> ${tt}.out
xpaget ds9 scale scope >> ${tt}.out
xpaget ds9 scale datasec >> ${tt}.out
xpaget ds9 scale lock >> ${tt}.out
xpaset -p ds9 scale open
xpaset -p ds9 scale minmax
xpaset -p ds9 scale linear
xpaset -p ds9 scale log
xpaset -p ds9 scale pow
xpaset -p ds9 scale sqrt
xpaset -p ds9 scale squared
xpaset -p ds9 scale asinh
xpaset -p ds9 scale sinh
xpaset -p ds9 scale histequ
xpaset -p ds9 scale log exp 1000
xpaset -p ds9 scale log exp 10000
xpaset -p ds9 scale linear
xpaset -p ds9 scale minmax
xpaset -p ds9 scale zscale
xpaset -p ds9 scale zmax
xpaset -p ds9 scale user
xpaset -p ds9 scale mode zscale
xpaset -p ds9 scale mode zmax
xpaset -p ds9 scale mode 95
xpaset -p ds9 scale mode minmax
xpaset -p ds9 scale limits 0 100
xpaset -p ds9 scale global
xpaset -p ds9 scale local
xpaset -p ds9 scale scope global
xpaset -p ds9 scale scope local
xpaset -p ds9 scale mode minmax
xpaset -p ds9 scale linear
xpaset -p ds9 scale zscale
xpaset -p ds9 scale datasec yes
xpaset -p ds9 scale match
xpaset -p ds9 scale lock yes
xpaset -p ds9 scale lock no
xpaset -p ds9 scale close
testit $tt
fi

if [ "$1" = "single" -o -z "$1" ]; then
tt="single"
xpaget ds9 tile >> ${tt}.out
xpaget ds9 tile mode >> ${tt}.out
xpaget ds9 blink >> ${tt}.out
xpaget ds9 blink interval >> ${tt}.out
xpaset -p ds9 file new hst.fits
xpaset -p ds9 file new img16.fits
xpaset -p ds9 blink
xpaset -p ds9 blink yes
xpaset -p ds9 blink interval .5
xpaset -p ds9 single
xpaset -p ds9 tile
xpaset -p ds9 tile yes
xpaset -p ds9 tile row
xpaset -p ds9 tile column
xpaset -p ds9 tile grid
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
xpaset -p ds9 cube close
testit $tt
fi

if [ "$1" = "skyview" -o -z "$1" ]; then
tt="skyview"
xpaset -p ds9 skyview open
xpaset -p ds9 skyview close
xpaset -p ds9 skyview survey sdssi
xpaget ds9 skyview survey >> ${tt}.out
xpaset -p ds9 skyview size 30 30 arcsec
xpaget ds9 skyview size >> ${tt}.out
xpaset -p ds9 skyview save no
xpaget ds9 skyview save >> ${tt}.out
xpaset -p ds9 skyview frame new
xpaget ds9 skyview frame >> ${tt}.out
xpaset -p ds9 skyview update frame
xpaset -p ds9 skyview m3
xpaset -p ds9 skyview name m51
xpaget ds9 skyview name >> ${tt}.out
xpaset -p ds9 skyview name {}
xpaset -p ds9 skyview coord 13:29:55.301 +47:11:37.73 sexagesimal
xpaget ds9 skyview coord >> ${tt}.out
xpaset -p ds9 skyview update frame
xpaset -p ds9 mode crosshair
xpaset -p ds9 skyview update crosshair
xpaset -p ds9 skyview close
xpaset -p ds9 mode pointer
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
testit $tt
fi

if [ "$1" = "sleep" -o -z "$1" ]; then
tt="sleep"
xpaset -p ds9 sleep
xpaset -p ds9 sleep 2
testit $tt
fi

if [ "$1" = "smooth" -o -z "$1" ]; then
tt="smooth"
xpaget ds9 smooth >> ${tt}.out
xpaget ds9 smooth function >> ${tt}.out
xpaget ds9 smooth radius >> ${tt}.out
xpaset -p ds9 smooth open
xpaset -p ds9 smooth
xpaset -p ds9 smooth yes
xpaset -p ds9 smooth function tophat
xpaset -p ds9 smooth radius 5
xpaset -p ds9 smooth match
xpaset -p ds9 smooth lock yes
xpaset -p ds9 smooth lock no
xpaset -p ds9 smooth no
xpaset -p ds9 smooth close
testit $tt
fi

if [ "$1" = "source" -o -z "$1" ]; then
tt="source"
xpaset -p ds9 source source.tcl
testit $tt
fi

if [ "$1" = "tcl" -o -z "$1" ]; then
tt="tcl"
echo 'puts "Hello Again, World"' | xpaset ds9 tcl
xpaset -p ds9 tcl 'puts "Hello Again, World"'
testit $tt
fi

if [ "$1" = "theme" -o -z "$1" ]; then
tt="theme"
xpaget ds9 theme >> ${tt}.out
xpaset -p ds9 theme native
testit $tt
fi

if [ "$1" = "threads" -o -z "$1" ]; then
tt="threads"
xpaget ds9 threads >> ${tt}.out
xpaset -p ds9 threads 8
xpaset -p ds9 prefs threads 8
testit $tt
fi

if [ "$1" = "update" -o -z "$1" ]; then
tt="update"
xpaset -p ds9 update
xpaset -p ds9 update 1 100 100 300 400
xpaset -p ds9 update now
xpaset -p ds9 update now 1 100 100 300 400
xpaset -p ds9 update off
xpaset -p ds9 update on
testit $tt
fi

if [ "$1" = "version" -o -z "$1" ]; then
tt="version"
xpaget ds9 version >> /dev/null
testit $tt
fi

if [ "$1" = "view" -o -z "$1" ]; then
tt="view"
xpaset -p ds9 frame delete
xpaget ds9 view layout >> ${tt}.out
xpaget ds9 view info >> ${tt}.out
xpaget ds9 view panner >> ${tt}.out
xpaget ds9 view magnifier >> ${tt}.out
xpaget ds9 view buttons >> ${tt}.out
xpaget ds9 view colorbar >> ${tt}.out
xpaget ds9 view graph horizontal >> ${tt}.out
xpaget ds9 view graph vertical >> ${tt}.out
xpaget ds9 view filename >> ${tt}.out
xpaget ds9 view object >> ${tt}.out
xpaget ds9 view minmax >> ${tt}.out
xpaget ds9 view lowhigh >> ${tt}.out
xpaget ds9 view frame >> ${tt}.out
xpaget ds9 view wcs >> ${tt}.out
xpaget ds9 view detector >> ${tt}.out
xpaget ds9 view amplifier >> ${tt}.out
xpaget ds9 view physical >> ${tt}.out
xpaget ds9 view image >> ${tt}.out

xpaset -p ds9 view layout vertical
xpaset -p ds9 view layout horizontal
xpaset -p ds9 view info no
xpaset -p ds9 view info yes
xpaset -p ds9 view panner no
xpaset -p ds9 view panner yes
xpaset -p ds9 view magnifier no
xpaset -p ds9 view magnifier yes
xpaset -p ds9 view buttons no
xpaset -p ds9 view buttons yes
xpaset -p ds9 view colorbar no
xpaset -p ds9 view colorbar yes
xpaset -p ds9 view graph horizontal yes
xpaset -p ds9 view graph horizontal no
xpaset -p ds9 view graph vertical yes
xpaset -p ds9 view graph vertical no
xpaset -p ds9 view filename no
xpaset -p ds9 view filename yes
xpaset -p ds9 view object no
xpaset -p ds9 view object yes
xpaset -p ds9 view minmax yes
xpaset -p ds9 view minmax no
xpaset -p ds9 view lowhigh yes
xpaset -p ds9 view lowhigh no
xpaset -p ds9 view frame no
xpaset -p ds9 view frame yes
xpaset -p ds9 view wcs no
xpaset -p ds9 view wcs yes
xpaset -p ds9 view wcsa yes
xpaset -p ds9 view wcsa no
xpaset -p ds9 view detector yes
xpaset -p ds9 view detector no
xpaset -p ds9 view amplifier yes
xpaset -p ds9 view amplifier no
xpaset -p ds9 view physical no
xpaset -p ds9 view physical yes
xpaset -p ds9 view image no
xpaset -p ds9 view image yes

xpaset -p ds9 frame new rgb
xpaset -p ds9 view red no
xpaset -p ds9 view red yes
xpaset -p ds9 view green no
xpaset -p ds9 view green yes
xpaset -p ds9 view blue no
xpaset -p ds9 view blue yes
xpaset -p ds9 frame delete

xpaset -p ds9 file new img16.fits
xpaset -p ds9 rgb close
testit $tt
fi

if [ "$1" = "vo" -o -z "$1" ]; then
tt="vo"
xpaget ds9 vo method >> ${tt}.out
xpaget ds9 vo server >> ${tt}.out
xpaget ds9 vo internal >> ${tt}.out
xpaget ds9 vo delay >> ${tt}.out
xpaget ds9 vo connect >> ${tt}.out
xpaget ds9 vo >> ${tt}.out
xpaset -p ds9 vo open
xpaset -p ds9 vo method xpa
xpaset -p ds9 vo server "http://cxc.harvard.edu/chandraed/list.txt"
xpaset -p ds9 vo internal yes
xpaset -p ds9 vo delay 15
xpaset -p ds9 vo connect foo
xpaset -p ds9 vo chandra-ed
xpaset -p ds9 vo disconnect chandra-ed
xpaset -p ds9 vo close
xpaset -p ds9 web close
testit $tt
fi

if [ "$1" = "wcs" -o -z "$1" ]; then
tt="wcs"
xpaget ds9 wcs >> ${tt}.out
xpaget ds9 wcs system >> ${tt}.out
xpaget ds9 wcs sky >> ${tt}.out
xpaget ds9 wcs skyformat >> ${tt}.out
xpaget ds9 wcs align >> ${tt}.out
xpaset -p ds9 wcs open
xpaset -p ds9 wcs wcs
xpaset -p ds9 wcs align yes
xpaset -p ds9 wcs system wcs
xpaset -p ds9 wcs sky galactic
xpaset -p ds9 wcs skyformat sexagesimal
xpaset -p ds9 wcs align no
xpaset -p ds9 wcs sky fk5
xpaset -p ds9 wcs skyformat degrees
cat image.wcs | xpaset ds9 wcs append
cat image.wcs | xpaset ds9 wcs replace
xpaset -p ds9 wcs append image.wcs
xpaset -p ds9 wcs replace image.wcs
xpaset -p ds9 wcs reset
xpaset -p ds9 frame new
xpaset -p ds9 file mosaicimage wcs ds9_8amp_2x2.fits
cat linear.wcs | xpaset ds9 wcs append 2
cat linear.wcs | xpaset ds9 wcs replace 2
xpaset -p ds9 wcs append 2 linear.wcs
xpaset -p ds9 wcs replace 2 linear.wcs
xpaset -p ds9 wcs reset 2
xpaset -p ds9 frame delete
xpaset -p ds9 wcs skyformat sexagesimal
xpaset -p ds9 wcs close
testit $tt
fi

if [ "$1" = "web" -o -z "$1" ]; then
tt="web"
xpaset -p ds9 web hea-www.harvard.edu/RD/ds9/acknowledgment.html
sleep "$delay"
xpaget ds9 web >> ${tt}.out
xpaset -p ds9 web hea-www.harvard.edu/RD/ds9/helpdesk.html
sleep "$delay"
xpaset -p ds9 web hvweb click back
sleep "$delay"
xpaset -p ds9 web click forward
xpaset -p ds9 web clear
xpaset -p ds9 web close
testit $tt
fi

if [ "$1" = "width" -o -z "$1" ]; then
tt="width"
xpaget ds9 width >> /dev/null
xpaset -p ds9 width 600
testit $tt
fi

if [ "$1" = "zscale" -o -z "$1" ]; then
tt="zscale"
xpaget ds9 zscale contrast >> ${tt}.out
xpaget ds9 zscale sample >> ${tt}.out
xpaget ds9 zscale line >> ${tt}.out
xpaset -p ds9 zscale contrast .25
xpaset -p ds9 zscale sample 600
xpaset -p ds9 zscale line 120
testit $tt
fi

if [ "$1" = "zoom" -o -z "$1" ]; then
tt="zoom"
xpaset -p ds9 zoom open
xpaset -p ds9 zoom 2
xpaset -p ds9 zoom 2 4
xpaset -p ds9 zoom to 4
xpaset -p ds9 zoom to 2 4
xpaset -p ds9 zoom to fit
xpaset -p ds9 zoom close
xpaget ds9 zoom > /dev/null
xpaset -p ds9 frame reset
testit $tt
fi

if [ "$1" = "exit" -o -z "$1" ]; then
tt="exit"
xpaset -p ds9 quit
fi

echo "DONE"
