#! /bin/sh

echo "WCS2 Tests"

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]; then
    ds9 &

    i=1
    while [ "$i" -le 30 ]
	do
	sleep 2
	if [ `xpaaccess ds9` = yes ]; then
	    break
	fi

	i=`expr $i + 1`
    done
fi

testit () {
    echo "Testing $1"
    xpaset -p ds9 file $1
    xpaset -p ds9 wcs sky fk5
    xpaset -p ds9 align yes
    read
    xpaset -p ds9 wcs sky galactic
    read
    xpaset -p ds9 frame clear
}

# load default image
xpaset -p ds9 grid yes
xpaset -p ds9 wcs skyformat deg

echo "STScI DSS"
testit wcen.fits.gz

echo "Old SCAMP"
testit ngc6819.fits

echo "TAN+ PV"
testit paucam_0_0_t7_0_science.fits

echo "TAN PV2_1=0 PV2_2=0"
testit a68.fits

echo "ZPN+ PV"
testit UKIDDS_K_3219_606_17_67_3.fits

echo "TNX"
testit 30s_01.fits

echo "ZPX"
testit E5.3090.fits

echo "TAN-SIP"
testit sst.fits
testit mos8.fits

echo "SAO Plate"
testit ac.fits

echo "WCSDEP"
testit ngc6819.fits

echo "HPX"
testit wmap.fits

echo "GLON-ZEA"
testit South_galactic.fits

echo "RA-CAR"
testit CAR_model.fits
testit car_01.fits

echo "GLON-CAR"
testit GLM_00350+0115_mosaic_I4_cutout_14706.fits

echo "IRAF"
testit obj011.fits

xpaset -p ds9 quit


