// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __contour_h__
#define __contour_h__

#include "vector.h"
#include "vector3d.h"
#include "list.h"
#include "coord.h"

class FitsImage;
class Base;

class Contour {
 protected:
  Base* parent;
  List<Vertex> contours_;

  char* colorName;
  unsigned long color;
  int lineWidth;
  int dash;
  int dashlist[2];

  Contour* previous_;
  Contour* next_;

 public:
  Contour(Base*, const char*, int, int);
  Contour(Base*, const char*, int, int, const List<Vertex>&);
  virtual ~Contour();

  void render(Pixmap, Coord::InternalSystem, int, int);
  void ps(int);
#ifdef _MACOSX
  void macosx();
#endif
#ifdef _WIN32
  void win32();
#endif

  const List<Vertex>& contours() {return contours_;}
  void updateCoords(const Matrix&);

  const char* getColorName() {return colorName;}
  void setColor(const char*);

  int getDash() {return dash;}
  void setDash(int);

  void setLineWidth(int);
  int getLineWidth() {return lineWidth;}

  Contour* previous() {return previous_;}
  void setPrevious(Contour* m) {previous_ = m;}
  Contour* next() {return next_;}
  void setNext(Contour* m) {next_ = m;}
};

#endif
