// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscaletrue32.h"

ColorScaleTrueColor32::ColorScaleTrueColor32(int s, Visual* visual, int msb)
  : ColorScale(s), TrueColor24(visual)
{
  colors_ = new unsigned char[s*4];

  // we need to check to byteswap when we have cross platforms
  if ((!msb && lsb()) || (msb && !lsb())) {
    for (int i=0; i<s; i++) {
      unsigned int r = psColors_[i*3+2];
      unsigned int g = psColors_[i*3+1];
      unsigned int b = psColors_[i*3];
      unsigned int a = 0;
      a |= r << rs_;
      a |= g << gs_;
      a |= b << bs_;
      memcpy(colors_+i*4, &a, 4);
    }
  }
  else {
    for (int i=0; i<s; i++) {
      unsigned int r = psColors_[i*3+2];
      unsigned int g = psColors_[i*3+1];
      unsigned int b = psColors_[i*3];
      unsigned int a = 0;
      a |= r << rs_;
      a |= g << gs_;
      a |= b << bs_;

      unsigned char* rr = (unsigned char*)(&a);
      *(colors_+i*4) = *(rr+3);
      *(colors_+i*4+1) = *(rr+2);
      *(colors_+i*4+2) = *(rr+1);
      *(colors_+i*4+3) = *(rr);
    }
  }
}

ColorScaleTrueColor32::~ColorScaleTrueColor32()
{
  if (colors_)
    delete [] colors_;
}

LinearScaleTrueColor32::LinearScaleTrueColor32(int s, 
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count, 
					       Visual* visual, int msb)
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor32(s, visual, msb),
    ColorScale(s) {}

LogScaleTrueColor32::LogScaleTrueColor32(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells, 
					 int count, double exp,
					 Visual* visual, int msb)
  : LogScale(s, indexCells, colorCells, count, exp), 
    ColorScaleTrueColor32(s, visual, msb), 
    ColorScale(s) {}

PowScaleTrueColor32::PowScaleTrueColor32(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells, 
					 int count, double exp,
					 Visual* visual, int msb)
  : PowScale(s, indexCells, colorCells, count, exp), 
    ColorScaleTrueColor32(s, visual, msb), 
    ColorScale(s) {}

SqrtScaleTrueColor32::SqrtScaleTrueColor32(int s,
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count, 
					   Visual* visual, int msb)
  : SqrtScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor32(s, visual, msb), 
    ColorScale(s) {}

SquaredScaleTrueColor32::SquaredScaleTrueColor32(int s,
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, 
						 Visual* visual, int msb)
  : SquaredScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor32(s, visual, msb), 
    ColorScale(s) {}

AsinhScaleTrueColor32::AsinhScaleTrueColor32(int s,
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count, 
					     Visual* visual, int msb)
  : AsinhScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor32(s, visual, msb), 
    ColorScale(s) {}

SinhScaleTrueColor32::SinhScaleTrueColor32(int s,
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count, 
					     Visual* visual, int msb)
  : SinhScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor32(s, visual, msb), 
    ColorScale(s) {}

IISScaleTrueColor32::IISScaleTrueColor32(unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, 
					 Visual* visual, int msb)
  : IISScale(indexCells, colorCells, count), 
    ColorScaleTrueColor32(IISSIZE, visual, msb),
    ColorScale(IISSIZE) {}

HistEquScaleTrueColor32::HistEquScaleTrueColor32(int s, 
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, 
						 double* hist, int histsize,
						 Visual* visual, int msb)
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScaleTrueColor32(s, visual, msb),
    ColorScale(s) {}


