// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <stdlib.h>
#include <string.h>

#include "tcl.h"
#include <Xlib.h>
#include <Xutil.h>

#include "pannertrue.h"
#include "util.h"

// Tk Canvas Widget Function Declarations

int PannerTrueColorCreateProc(Tcl_Interp*, Tk_Canvas, Tk_Item*, int, 
			      Tcl_Obj *const []);

// PannerTrueColor Specs

static Tk_CustomOption tagsOption = {
  Tk_CanvasTagsParseProc, Tk_CanvasTagsPrintProc, NULL
};

static Tk_ConfigSpec pannerTrueColorSpecs[] = {

  {TK_CONFIG_STRING, "-command", NULL, NULL, "panner",
   Tk_Offset(WidgetOptions, cmdName), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-x", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, x), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-y", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, y), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-width", NULL, NULL, "256",
   Tk_Offset(WidgetOptions, width), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-height", NULL, NULL, "256",
   Tk_Offset(WidgetOptions, height), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_ANCHOR, "-anchor", NULL, NULL, "nw",
   Tk_Offset(WidgetOptions, anchor), 0, NULL},
  {TK_CONFIG_CUSTOM, "-tags", NULL, NULL, NULL,
   0, TK_CONFIG_NULL_OK, &tagsOption},

  {TK_CONFIG_END, NULL, NULL, NULL, NULL, 0, 0, NULL},
};

// Tk Static Structure

static Tk_ItemType pannerTrueColorType = {
  "pannertruecolor",            // name
  sizeof(WidgetOptions),        // size
  PannerTrueColorCreateProc,    // configProc
  pannerTrueColorSpecs,         // configSpecs
  WidgetConfigProc,             // configProc
  WidgetCoordProc,              // coordProc
  WidgetDeleteProc,             // deleteProc
  WidgetDisplayProc,            // displayProc
  0,                            // alwaysRedraw
  WidgetPointProc,              // pointProc
  WidgetAreaProc,               // areaProc
  WidgetPostscriptProc,         // postscriptProc
  WidgetScaleProc,              // scaleProc
  WidgetTranslateProc,          // translateProc
  (Tk_ItemIndexProc*)NULL,      // indexProc
  WidgetICursorProc,            // icursorProc
  (Tk_ItemSelectionProc*)NULL,  // selectionProc
  (Tk_ItemInsertProc*)NULL,     // insertProc
  (Tk_ItemDCharsProc*)NULL,     // dCharsProc
  (Tk_ItemType*)NULL            // nextPtr
};

// Non-Member Functions

int PannerTrueColor_Init(Tcl_Interp* interp)
{
  Tk_CreateItemType(&pannerTrueColorType);
  return TCL_OK;
}

int PannerTrueColorCreateProc(Tcl_Interp* interp, Tk_Canvas canvas, 
			      Tk_Item* item, int argc, Tcl_Obj *const argv[])
{
  PannerTrueColor* panner = new PannerTrueColor(interp, canvas, item);

  // and set default configuration

  if (panner->configure(argc, (const char**)argv, 0) != TCL_OK) {
    delete panner;
    Tcl_AppendResult(interp, " error occured while creating pannerTrueColor.",
		     NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}

PannerTrueColor::PannerTrueColor(Tcl_Interp* i, Tk_Canvas c, Tk_Item* item)
  : Panner(i, c, item)
{
  configSpecs = pannerTrueColorSpecs;  // panner configure options
}

void PannerTrueColor::clearPixmap()
{
  XImage* xmap = XGETIMAGE(display, pixmap, 0, 0,
			   options->width, options->height, 
			   AllPlanes, ZPixmap);
  if (!xmap) {
    cerr << "PannerTrueColor Internal Error: Unable to Create XImage" << endl;
    exit(1);
  }

  memset(xmap->data, 255, xmap->bytes_per_line * xmap->height);
  XPutImage(display, pixmap, gc, xmap, 0, 0, 0, 0, options->width, options->height);
  XDestroyImage(xmap);
}
