// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <stdlib.h>
#include <string.h>

#include "tcl.h"
#include <Xlib.h>
#include <Xutil.h>

#include "magnifiertrue.h"
#include "util.h"

// Tk Canvas Widget Function Declarations

int MagnifierTrueColorCreateProc(Tcl_Interp*, Tk_Canvas, Tk_Item*, int,
				 Tcl_Obj *const []);

// MagnifierTrueColor Specs

static Tk_CustomOption tagsOption = {
  Tk_CanvasTagsParseProc, Tk_CanvasTagsPrintProc, NULL
};

static Tk_ConfigSpec magnifierTrueColorSpecs[] = {

  {TK_CONFIG_STRING, "-command", NULL, NULL, "magnifier",
   Tk_Offset(WidgetOptions, cmdName), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-x", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, x), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-y", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, y), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-width", NULL, NULL, "256",
   Tk_Offset(WidgetOptions, width), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-height", NULL, NULL, "256",
   Tk_Offset(WidgetOptions, height), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_ANCHOR, "-anchor", NULL, NULL, "nw",
   Tk_Offset(WidgetOptions, anchor), 0, NULL},
  {TK_CONFIG_CUSTOM, "-tags", NULL, NULL, NULL,
   0, TK_CONFIG_NULL_OK, &tagsOption},

  {TK_CONFIG_END, NULL, NULL, NULL, NULL, 0, 0, NULL},
};

// Tk Static Structure

static Tk_ItemType magnifierTrueColorType = {
  "magnifiertruecolor",         // name
  sizeof(WidgetOptions),        // size
  MagnifierTrueColorCreateProc, // configProc
  magnifierTrueColorSpecs,      // configSpecs
  WidgetConfigProc,             // configProc
  WidgetCoordProc,              // coordProc
  WidgetDeleteProc,             // deleteProc
  WidgetDisplayProc,            // displayProc
  0,                            // alwaysRedraw
  WidgetPointProc,              // pointProc
  WidgetAreaProc,               // areaProc
  WidgetPostscriptProc,         // postscriptProc
  WidgetScaleProc,              // scaleProc
  WidgetTranslateProc,          // translateProc
  (Tk_ItemIndexProc*)NULL,      // indexProc
  (Tk_ItemCursorProc*)NULL,     // icursorProc
  (Tk_ItemSelectionProc*)NULL,  // selectionProc
  (Tk_ItemInsertProc*)NULL,     // insertProc
  (Tk_ItemDCharsProc*)NULL,     // dCharsProc
  (Tk_ItemType*)NULL            // nextPtr
};

// Non-Member Functions

int MagnifierTrueColor_Init(Tcl_Interp* interp)
{
  Tk_CreateItemType(&magnifierTrueColorType);
  return TCL_OK;
}

int MagnifierTrueColorCreateProc(Tcl_Interp* interp, Tk_Canvas canvas, 
				 Tk_Item* item, int argc, Tcl_Obj *const argv[])
{
  MagnifierTrueColor* magnifier = new MagnifierTrueColor(interp, canvas, item);

  // and set default configuration

  if (magnifier->configure(argc, (const char**)argv, 0) != TCL_OK) {
    delete magnifier;
    Tcl_AppendResult(interp, " error occured while creating magnifier.", NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}

MagnifierTrueColor::MagnifierTrueColor(Tcl_Interp* i, Tk_Canvas c, 
				       Tk_Item* item) : Magnifier(i, c, item)
{
  configSpecs = magnifierTrueColorSpecs;  // magnifier configure options
}

void MagnifierTrueColor::clearPixmap()
{
  XImage* xmap = XGETIMAGE(display, pixmap, 0, 0, options->width, 
			   options->height, AllPlanes, ZPixmap);
  if (!xmap) {
    cerr << "MagnifierTrueColor Internal Error: Unable to Create XImage" 
	 << endl;
    exit(1);
  }

  memset(xmap->data, 255, xmap->bytes_per_line * xmap->height);
  XPutImage(display, pixmap, gc, xmap, 0, 0, 0, 0, options->width, 
	    options->height);
  XDestroyImage(xmap);
}
