// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorscalepseudo8_h__
#define __colorscalepseudo8_h__

#include "colorscale.h"

class FrameBase;

class ColorScalePseudoColor8 : public virtual ColorScale {
public:
  ColorScalePseudoColor8(int);
  virtual ~ColorScalePseudoColor8();
};

class LinearScalePseudoColor8 : 
public virtual ColorScale, 
public LinearScale, 
public ColorScalePseudoColor8 {
public:
  LinearScalePseudoColor8(int, unsigned short*, unsigned char*, int);
};

class LogScalePseudoColor8 :
public virtual ColorScale, 
public LogScale, 
public ColorScalePseudoColor8 {
public:
  LogScalePseudoColor8(int, unsigned short*, unsigned char*, int);
};

class SquaredScalePseudoColor8 :
public virtual ColorScale, 
public SquaredScale, 
public ColorScalePseudoColor8 {
public:
  SquaredScalePseudoColor8(int, unsigned short*, unsigned char*, int);
};

class SqrtScalePseudoColor8 :
public virtual ColorScale, 
public SqrtScale, 
public ColorScalePseudoColor8 {
public:
  SqrtScalePseudoColor8(int, unsigned short*, unsigned char*, int);
};

class IISScalePseudoColor8 :
public virtual ColorScale, 
public IISScale, 
public ColorScalePseudoColor8 {
public:
  IISScalePseudoColor8(FrameBase*,unsigned short*, unsigned char*, int);
};

class HistEquScalePseudoColor8 : 
public virtual ColorScale, 
public HistEquScale, 
public ColorScalePseudoColor8 {
public:
  HistEquScalePseudoColor8(int, unsigned short*, unsigned char*, int, 
			   double*, int);
};

#endif
