// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __box_h__
#define __box_h__

#include "basebox.h"

class Box : public BaseBox {
public:
  Box(const Box&);
  Box(FrameBase* p, const Vector& ctr, 
      const Vector& seg,
      double ang,
      const char* clr, int wth, const char* fnt, const char* txt,
      unsigned short prop, const char* cmt, 
      const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Box(*this);}
  void editBegin(int);
  void edit(const Vector&, int);
  void editEnd();

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listCiao(ostream&, CoordSystem, int, int);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listSAOimage(ostream&, int);
};

#endif
