// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

%{

#define YYPARSE_PARAM ff
#define FF ((FitsFile*)ff)
#define YYDEBUG 1

#define GOTOFILT(x) {yyclearin; ffFilter(x);}
#define GOTOARR(x) {yyclearin; ffArray(x);}

#include "file.h"

char ff_filter[512];
extern int fflex(void);
extern void fferror(const char*);
extern void ffFilter(int);
extern void ffArray(int);

%}

%union {
  float real;
  int integer;
  char str[256];
  void* ptr;
}

%token <integer> INT
%token <str> STRING

%token ARCH_
%token ARRAY_
%token BIGENDIAN_
%token BIN_
%token BINKEY_
%token BINCOL_
%token BITPIX_
%token DIM_
%token DIMS_
%token KEY_
%token LITTLEENDIAN_
%token SKIP_
%token XDIM_
%token YDIM_
%token ZDIM_

%%

/*start	: {yydebug=1;} command*/

// assume any error is the start of a filter
command	: filename
	| filename extn
	| filename bin
	| filename extn bin
	| filename '[' extnb binb ']'
	| filename '[' arrs ']'
	| filename '[' ARRAY_ {GOTOARR(0)} '(' array ')' ']'
	| error {GOTOFILT(0)} STRING {FF->setpFilter(ff_filter);}
	;

filename : /* empty */
	|  STRING {FF->setpName($1);}
	;

extn	: '[' STRING ']' {FF->setpExt($2);}
	| '[' INT ']' {FF->setpIndex($2);}
	;

bin	: '[' binword '=' '(' STRING ',' STRING ')' ']' {FF->setpBinXY($5,$7);}
	| '[' binword '=' STRING ',' STRING ']' {FF->setpBinXY($4,$6);}
	| '[' binword '=' '(' STRING ',' STRING ',' STRING ')' ']'
	  {FF->setpBinXYZ($5,$7,$9);}
	| '[' binword '=' STRING ',' STRING ',' STRING ']'
	  {FF->setpBinXYZ($4,$6,$8);}
	| '[' binword '=' '(' STRING ')' ']' {FF->setpBinZ($5);}
	| '[' binword '=' STRING ']' {FF->setpBinZ($4);}
	;

extnb	: STRING ',' {FF->setpExt($1);}
	| INT ',' {FF->setpIndex($1);}
	;

binb	: binword '=' binkey
	| binword binkey
	;

binword	: BIN_
	| BINKEY_
	| BINCOL_
	| KEY_
	;

binkey	: '(' STRING ',' STRING ')' {FF->setpBinXY($2,$4);}
	| STRING ',' STRING {FF->setpBinXY($1,$3);}
	| '(' STRING ',' STRING ',' STRING ')' {FF->setpBinXYZ($2,$4,$6);}
	| STRING ',' STRING ',' STRING {FF->setpBinXYZ($1,$3,$5);}
	| '(' STRING ')' {FF->setpBinZ($2);}
	| STRING {FF->setpBinZ($1);}
	;

arrs	: arrs ',' arr
	| arr
	;

arr	: XDIM_ '=' INT {FF->setpXdim($3);}
	| YDIM_ '=' INT {FF->setpYdim($3);}
	| ZDIM_ '=' INT {FF->setpZdim($3);}
	| DIM_ '=' INT {FF->setpXdim($3);FF->setpYdim($3);}
	| DIMS_ '=' INT {FF->setpXdim($3);FF->setpYdim($3);}
	| BITPIX_ '=' INT {FF->setpBitpix($3);}
	| SKIP_ '=' INT {FF->setpSkip($3);}
	| ARCH_ '=' endian
	| endian
	;

endian	: BIGENDIAN_ {FF->setpArch(FitsFile::BIGENDIAN);}
	| LITTLEENDIAN_ {FF->setpArch(FitsFile::LITTLEENDIAN);}
	;

array	: atype adims askip aendian
	;

atype	: 'b' {FF->setpBitpix(8);}
	| 's' {FF->setpBitpix(16);}
	| 'u' {FF->setpBitpix(-16);}
	| 'i' {FF->setpBitpix(32);}
	| 'r' {FF->setpBitpix(-32);}
	| 'f' {FF->setpBitpix(-32);}
	| 'd' {FF->setpBitpix(-64);}
	;

adims	: INT {FF->setpXdim($1);FF->setpYdim($1);}
	| INT '.' INT {FF->setpXdim($1);FF->setpYdim($3);}
	| INT '.' INT '.' INT 
	  {FF->setpXdim($1);FF->setpYdim($3);FF->setpZdim($5);}
	;

askip	: /* empty */
	| ':' INT {FF->setpSkip($2);}
	;

aendian	: /* empty */
	| 'l' {FF->setpArch(FitsFile::LITTLEENDIAN);}
	| 'b' {FF->setpArch(FitsFile::BIGENDIAN);}
	;

%%
