// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __sao_h__
#define __sao_h__

#include "colormap.h"

// LIColor

class LIColor {
private:
  float x;
  float y;
  LIColor* next;

public:
  LIColor() : x(0), y(0), next(NULL) {}
  LIColor(float l, float i) : x(l), y(i), next(NULL) {}
  
  LIColor* getNext() {return next;}
  void setNext(LIColor* n) {next = n;}

  float getX() {return x;}
  float getY() {return y;}

  friend istream& operator>>(istream&, LIColor&);
  friend ostream& operator<<(ostream&, LIColor&);
};

// SAOColorMap

class SAOColorMap : public ColorMapInfo {
protected:
  LIColor* red;
  LIColor* green;
  LIColor* blue;

  void loadColor(char*, LIColor**);
  unsigned char getColorChar(int, int, LIColor*);
  unsigned short getColorShrt(int, int, LIColor*);

public:
  SAOColorMap();
  ~SAOColorMap();

  int load();
  int save(const char*);

  unsigned char getRedChar(int i, int c) {return getColorChar(i,c,red);}
  unsigned char getGreenChar(int i, int c) {return getColorChar(i,c,green);}
  unsigned char getBlueChar(int i, int c) {return getColorChar(i,c,blue);}

  unsigned short getRedShrt(int i, int c) {return getColorShrt(i,c,red);}
  unsigned short getGreenShrt(int i, int c) {return getColorShrt(i,c,green);}
  unsigned short getBlueShrt(int i, int c) {return getColorShrt(i,c,blue);}

  friend ostream& operator<<(ostream&, SAOColorMap&);
};

#endif

