/*
 *	Copyright (c) 1999-2003 Smithsonian Astrophysical Observatory
 */

/*
 *
 * gcat -- cat-like program using gio
 *
 */

#include <gio.h>

#define GBUFSIZE 8192

#ifdef ANSI_FUNC
int 
main (int argc, char **argv)
#else
main(argc, argv)
     int argc;
     char **argv;
#endif
{
  int got;
  char  buf[GBUFSIZE];
  char *iname;
  char *oname;
  GIO igio;
  GIO ogio;

  /* exit on gio errors */
  setgerror(2);

  /* process arguments */
  switch(argc){
  case 1:
    iname = "stdin";
    oname = "stdout";
    break;
  case 3:
    iname = argv[1];
    oname = argv[2];
    break;
  default:
    gerror(stderr, "%s [iname] [oname]\n", argv[0]);
    exit(1);
  }

  /* open the input and output files */
  if( !(igio = gopen(iname, "r")) )
    gerror(stderr, "can't gopen input file: %s\n", iname);
  if( !(ogio = gopen(oname, "w")) )
    gerror(stderr, "can't gopen output file: %s\n", iname);

  /* read/write all bytes */
  while( 1 ){
    got = gread(igio, buf, sizeof(char), GBUFSIZE);
    if( !got )
      break;
    else if( got < 0 ){
      gerror(stderr, "can't read input file\n");
      break;
    }
    else
      gwrite(ogio,  buf, sizeof(char), got);
  }

  /* close files */
  gclose(igio);
  gclose(ogio);
  return 0;
}
