#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc PointDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # base
    MarkerBaseCenterDialog $frame $id 275 150
}

# actions

proc PointClose {frame id} {
    MarkerBaseCenterClose $frame $id
}

proc PointApply {frame id} {
    MarkerBaseCenterApply $frame $id
}

# callbacks

proc PointCoordCB {frame id} {
    MarkerBaseCoordCB $frame $id
    MarkerBaseCenterMoveCB $frame $id
}




