/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Block.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/15
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_insert.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_Undo.h"
#define _LIST_BLOCK_
#include "List_Block.h"





int init_block(BLOCK *block)
{
	strcpy(block->name, "noname");
	block->layer = 0;

	block->cad_list_info.head = NULL;
	block->cad_list_info.tail = NULL;

	block->dimension_list_info.head = NULL;
	block->dimension_list_info.tail = NULL;

	block->polyline_list_info.head = NULL;
	block->polyline_list_info.tail = NULL;

	block->ellipse_list_info.head = NULL;
	block->ellipse_list_info.tail = NULL;

	block->insert_list_info.head = NULL;
	block->insert_list_info.tail = NULL;

	return 1;
}





/* -------------------------------------------------------------------
 * BLOCK Data をリストの最初に追加
 *	
 * データ (CAD DIMENSION TEXT POLYLINE) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
BLOCK_LIST *r_block_list_add_first(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	/* データ (LIST) を書き込むための領域を確保する */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* 確保した領域にデータ (block) を書き込む */
	p_block_list->block = add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_block_list_info->head;
		p_block_list_info->head = p_block_list;
		p_block_list->next = p;
	}

	return p_block_list_info->head;
}





/* -------------------------------------------------------------------
 * BLOCK Data をリストの最初に追加
 *	
 */
BLOCK_LIST *block_list_add_first(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	/* データ (LIST) を書き込むための領域を確保する */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* データ (block) を書き込むための領域を確保する */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* vertex の領域は、作成時に */
	/* データ (vertex) を書き込むための領域を確保する */
//	p_block_list->block->vertex = (VERTEX *)xmalloc(add_block->block->index * sizeof(VERTEX));

	/* 確保した領域にデータ (block) を書き込む */
	*p_block_list->block = *add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_block_list_info->head;
		p_block_list_info->head = p_block_list;
		p_block_list->next = p;
	}

	return p_block_list_info->head;
}



/* ---------------------------------------------------------
 * BLOCK Data をリストの最初に追加して、 Undo Baffer に書込む
 *	
 * データ (AssistLine) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
BLOCK_LIST *block_list_add_first_with_undo(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	BLOCK block = {"",0,{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データ (LIST) を書き込むための領域を確保する */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* データ (block) を書き込むための領域を確保する */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* データ (AssistLine) を書き込むための領域を確保する */
//	p_block_list->block->AssistLine = (ASSISTANCE *)xmalloc(add_block->index * sizeof(ASSISTANCE));

	/* 確保した領域にデータ (block) を書き込む */
	*p_block_list->block = *add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * データが１個以上ある
	 */
	else {
		p = p_block_list_info->head;
		p_block_list_info->head = p_block_list;
		p_block_list->next = p;
	}


	lpdiagram.block_point = p_block_list_info->head->block;
	diagram.block = block;

	/* Undo Buffa Write */
	undo_list_add_first(BLOCK_NEW, lpdiagram, diagram);
	return p_block_list_info->head;
}





/* -------------------------------------------------------------------
 * BLOCK Data をリストの最後に追加
 *	
 */
BLOCK_LIST *block_list_add_last(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	/* データ (LIST) を書き込むための領域を確保する */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* データ (block) を書き込むための領域を確保する */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* vertex の領域は、作成時に */
	/* データ (vertex) を書き込むための領域を確保する */
//	p_block_list->block->vertex = (VERTEX *)xmalloc(add_block->block->index * sizeof(VERTEX));

	/* 確保した領域にデータ (block) を書き込む */
	*p_block_list->block = *add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_block_list_info->head != NULL 
				&& p_block_list_info->tail != NULL 
					&& p_block_list_info->head == p_block_list_info->tail) {
		p_block_list_info->head->next = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_block_list_info->tail;
		p_block_list_info->tail = p_block_list;
		p->next = p_block_list_info->tail;
	}

	/* アンドゥバッファに書込む */
//	undo_list_add_first(11, p_block_list_info->tail, NULL);
	return p_block_list_info->tail;
}





/* ---------------------------------------------------------
 * BLOCK Data をリストの最後に追加、 Undo Baffer に書込む
 *	
 * データ (AssistLine) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
BLOCK_LIST *block_list_add_last_with_undo(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	BLOCK block = {"",0,{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* データ (LIST) を書き込むための領域を確保する */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* データ (block) を書き込むための領域を確保する */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* データ (AssistLine) を書き込むための領域を確保する */
//	p_block_list->block->AssistLine = (ASSISTANCE *)xmalloc(add_block->index * sizeof(ASSISTANCE));

	/* 確保した領域にデータ (block) を書き込む */
	*p_block_list->block = *add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail の両方が NULL のときは、１個もデータがない 
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * head = tail で NULL ではないときは、１個だけデータがある
	 */
	else if (p_block_list_info->head != NULL 
				&& p_block_list_info->tail != NULL 
					&& p_block_list_info->head == p_block_list_info->tail) {
		p_block_list_info->head->next = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * データが２個以上ある
	 */
	else {
		p = p_block_list_info->tail;
		p_block_list_info->tail = p_block_list;
		p->next = p_block_list_info->tail;
	}


	lpdiagram.block_point = p_block_list_info->tail->block;
	diagram.block = block;

	/* Undo Buffa Write */
	undo_list_add_first(BLOCK_NEW, lpdiagram, diagram);
	return p_block_list_info->tail;
}





/* -------------------------------------------------------------------
 * BLOCK Data の削除機能 (メモリの削除ではない)
 * 
 */
int block_list_delete(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p = NULL;
	BLOCK_LIST *pb = NULL;
	long i;

	/* -------------------------------------------
	 * 削除するポインタの前のデータを知りたいので、
	 * head (リストの先頭) から削除するポインタが
	 * 見つかるまで繰り返し、前のデータを探す。
	 */
	p = p_block_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL && p != del_List) {
		if (i == 0) i++;
		pb = p;			/* 前のデータのポインタとして保存しておく */
		p = p->next;	/* ポインタを次のデータに移す */
	}


	/* 見つかった場合 (p が NULL ではないとき) */
	if(p != NULL){
		/* 先頭のデータ (i = 0 のとき) */
		if (i == 0) {
			/* 先頭のデータ１個しかない場合(次のデータのポインタが NULL) */
			if (p->next == NULL) {
				p_block_list_info->head = NULL;
				p_block_list_info->tail = NULL;
			}
			/* ２個以上データがあるとき */
			else 
				p_block_list_info->head = p->next;
		}

		/* 最後のデータのとき (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* 中間のデータ (上の条件以外) */
		else pb->next = p->next;
		block_list_free(del_List, p_block_list_info);
		return 1;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * BLOCK Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す)
 * 
 */
int block_list_delete_Undo(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p = NULL;
	BLOCK_LIST *pb = NULL;
	long i;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* -------------------------------------------
	 * 削除するポインタの前のデータを知りたいので、
	 * head (リストの先頭) から削除するポインタが
	 * 見つかるまで繰り返し、前のデータを探す。
	 */
	p = p_block_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL && p != del_List) {
		i++;
		pb = p;			/* 前のデータのポインタとして保存しておく */
		p = p->next;	/* ポインタを次のデータに移す */
	}


	/* 見つかった場合 (p が NULL ではないとき) */
	if(p != NULL){
		/* 先頭のデータ (i = 0 のとき) */
		if (i == 0) {
			/* 先頭のデータ１個しかない場合(次のデータのポインタが NULL) */
			if (p->next == NULL) {
				p_block_list_info->head = NULL;
				p_block_list_info->tail = NULL;
			}
			/* ２個以上データがあるとき */
			else 
				p_block_list_info->head = p->next;
		}

		/* 最後のデータのとき (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* 中間のデータ (上の条件以外) */
		else pb->next = p->next;

		lpdiagram.block_point = del_List->block;
		diagram.block = *del_List->block;

		undo_list_add_first(BLOCK_DEL, lpdiagram, diagram);
		block_list_free(del_List, p_block_list_info);
		return 1;
	}
	return 0;
}





/* ---------------------------------------------------------
 * BLOCK のポインタのデータを Undo バッファ（編集）に入れて、
 * その場所に新しいデータを入れる。
 * 
 * 戻り値　元のデータのアドレス
 * 
 * データ (AssistLine) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
BLOCK_LIST *block_list_edit(BLOCK_LIST *point, BLOCK *change_block, BLOCK_LIST_INFO *p_block_list_info)
{
	/* データ (LIST) を書き込むための領域を確保する */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* データ (block) を書き込むための領域を確保する */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* データ (AssistLine) を書き込むための領域を確保する */
//	p_block_list->block->AssistLine = (ASSISTANCE *)xmalloc(change_block->index * sizeof(ASSISTANCE));

	/* 確保した領域に変更前のデータ (block) を書き込む */
	*p_block_list->block = *point->block;
//	p_block_list->next = point;

	/* 変更データを書き込む */
	*point->block = *change_block;

//	undo_list_add_first(13, p_block_list, NULL);
	return p_block_list;
}





/* ---------------------------------------------------------
 * BLOCK の変更前のデータ(point)を Undo バッファ（編集）に入れて、
 * その場所に新しいデータ(change_block)を入れ、Undo Baffer に書込む
 *	
 * 戻り値　元のデータのアドレス
 *	
 * データ (AssistLine) を書き込むための領域は、ここに来る前に
 * 確保されているので改めて確保する必要ない。
 */
BLOCK_LIST *block_list_edit_with_undo(BLOCK_LIST *point, BLOCK *change_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK block = {"",0,{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* 確保した領域に変更前のデータ (BLOCK) を書き込む */
	block = *point->block;

	/* 変更データを書き込む */
	*point->block = *change_block;


	lpdiagram.block_point = point->block;
	diagram.block = block;

	undo_list_add_first(BLOCK_EDIT, lpdiagram, diagram);
	return point;
}





/* -------------------------------------------------------------------
 * リストの総数を調べる
 */
long block_list_num(BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	long i;

	p = p_block_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * 最後まで見つからない場合、 p に NULL が 
	 * 入ってループを抜ける。
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ポインタを次のデータに移す */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n 番目のデータの検索
 *	
 */
BLOCK_LIST *block_search_num(long search_number, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	long i;

	p = p_block_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n 番目のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * BLOCK のデータの検索
 *	
 * 戻値  BLOCK_LIST
 */
BLOCK_LIST *block_search_block(BLOCK *p_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	p = p_block_list_info->head;
	/*	*/
	while( p != NULL && p->block != p_block) {
		p = p->next;
	}

	/* p_block のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * BLOCK のデータの検索 (name)
 *	
 * 戻値  BLOCK_LIST
 */
BLOCK_LIST *block_search_block_name(char *name, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	p = p_block_list_info->head;
	/*	*/
	while( p != NULL) {
		if (strstr(p->block->name, name) != NULL ) {
			break;
		}
		p = p->next;
	}

	/* p_block のデータのアドレスを返す */
	if (p != NULL) {
		return p;
	}
	/* そこまでデータがない */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * BLOCK のデータの検索
 *	
 * 戻値  long
 */
long block_search_block_to_num(BLOCK *p_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	long i;

	i = 1;
	p = p_block_list_info->head;
	/*	*/
	while( p != NULL && p->block != p_block) {
		p = p->next;
		i++;
	}

	/* p_block のデータのアドレスを返す */
	if (p != NULL) {
		return i;
	}
	/* そこまでデータがない */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 * BLOCK Data をリストから削除
 */
int block_list_free(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p = NULL;
	BLOCK_LIST *pb = NULL;


	/* データが先頭で１個だけ  */
	if (del_List == p_block_list_info->head && del_List->next == NULL) {
		p_block_list_info->head = NULL;
		p_block_list_info->tail = NULL;
		//g_print("データが先頭で１個だけ\n");
	}
	/* データが先頭で２個以上  */
	else if (del_List == p_block_list_info->head && del_List->next != NULL) {
		p_block_list_info->head = p_block_list_info->head->next;
		//g_print("データが先頭で２個以上\n");
	}
	else {
		/* -------------------------------------------
		 * 削除するポインタの前のデータを知りたいので、
		 * head (リストの先頭) から削除するポインタが
		 * 見つかるまで繰り返し、前のデータを探す。
		 */
		p = p_block_list_info->head;
		/* -------------------------------------------
		 * 最後まで見つからない場合、 p に NULL が 
		 * 入ってループを抜ける。
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* 前のデータのポインタとして保存しておく */
			p = p->next;	/* ポインタを次のデータに移す */
		}


		if(p != NULL){
			/* 最後のデータ */
			if (del_List == p_block_list_info->tail) {
				pb->next = NULL;
				p_block_list_info->tail = pb;
			}
			/* 中間のデータ */
			else if (del_List != p_block_list_info->head && del_List != p_block_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			//g_print("リストの BLOCK データではない\n");
			return 0;
		}
	}

	cad_list_all_free(&del_List->block->cad_list_info);
	dimension_list_all_free(&del_List->block->dimension_list_info);
	polyline_list_all_free(&del_List->block->polyline_list_info);
	insert_list_all_free(&del_List->block->insert_list_info);
	ellipse_list_all_free(&del_List->block->ellipse_list_info);

	xfree(del_List->block);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 * 全リストを削除
 */
void block_list_all_free(BLOCK_LIST_INFO *p_block_list_info)
{
	while (p_block_list_info->head != NULL) {
		block_list_free(p_block_list_info->head, p_block_list_info);
	}
}





/* ---------------------------------------------------------
 * BLOCK_LIST のデータ log
 *	
 */
void block_list_log(BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	long i = 0;


	g_print("----- BLOCK リストを表示 -----\n");
	p = p_block_list_info->head;
	while( p != NULL) {
		i++;
		g_print("%d : NAME [%s] : BLOCK adress = [%x] : Layer [%d]\n", (int)i, p->block->name, (int)p->block, p->block->layer);

		g_print("  CAD Data -> %d\n", (int)cad_list_num(&p->block->cad_list_info));
		cad_list_print(&p->block->cad_list_info);

		g_print("  DIMENSION Data -> %d\n", (int)dimension_list_num(&p->block->dimension_list_info));

		g_print("  POLYLINE Data -> %d\n", (int)polyline_list_num(&p->block->polyline_list_info));
		polyline_list_log(&p->block->polyline_list_info);

		g_print("  INSERT Data -> %d\n", (int)insert_list_num(&p->block->insert_list_info));
		g_print("  ELLIPSE Data -> %d\n", (int)ellipse_list_num(&p->block->ellipse_list_info));

		p = p->next;
	}
	g_print("-------------------------------\n");
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Block.c
 * ====================================================================
 */

