#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-06 
# _preinstall-mdk.sh

### P A R A M S

package="$1"

### I N C L U D E

. ./_include.sh

### H E L P E R S

function rpmdeps()
{
	rpm -q -p $1 -R | grep -v '^/' | sed 's/(.*)//g' | sed 's/[><].*$//g' 
}

### S T A R T
packages=`rpmdeps ${package}`

echo \
"WARNING \
You may have to configure your urpmi download sources to include \
a contrib source (besides a main source), for instance :"
echo "ftp://ftp.ciril.fr/pub/linux/mandrakelinux/official/2008.0/i586/media/contrib/release"
echo "ftp://ftp.ciril.fr/pub/linux/mandrakelinux/official/2008.0/i586/media/main/release"
echo "see package manager GUI program and /etc/urmpi/urmpi.cgf"

# I N S T A L L E R
if ! rpm -q urpmi > /dev/null ; then
	echo "install needs the urpmi rpm"
	exit 1
fi
echo "urpmi is installed"

# I N S T A L L   L O O P
echo "+INSTALL"
for p in ${packages}; do
	echo "+package ${p}"
	if ! rpm -q "${p}" > /dev/null ; then
		urpmi --auto "${p}"
	else
		echo "package ${p} is installed"
	fi
done

# U P D A T E
echo "+UPDATE"
urpmi --auto --update ${packages}
echo '+end of mdk preinstall'
