#!/bin/bash
# bbou@ac-toulouse.fr
# 2005-07-10 11:47:47  
# _purge.sh

### P A R A M S
MYPURGESECRET=
if [ "$1" == "-s" ];then
	MYPURGESECRET='True'
	shift
fi

MYPURGEPID=
if [ "$1" == "-p" ];then
	MYPURGEPID='True'
	shift
fi

### I N C L U D E

. ./_include.sh

### S T A R T

echo "--------------------------------------------------------------------------------"
echo "PURGING SAMBA DATA AND CACHE"
echo "--------------------------------------------------------------------------------"

if [ ! -z "${MYPURGESECRET}" ]; then
	echo "remove /etc/samba/secrets.tdb"
	[ -e /etc/samba/secrets.tdb ] && rm -f /etc/samba/secrets.tdb
fi

if [ ! -z "${MYPURGEPID}" ]; then
	echo "remove /var/run/smbd.pid"
	[ -e /var/run/smbd.pid ] && rm -f /var/run/smbd.pid
	echo "remove /var/run/nmbd.pid"
	[ -e /var/run/nmbd.pid ] && rm -f /var/run/nmbd.pid
	echo "remove /var/run/winbindd.pid"
	[ -e /var/run/winbindd.pid ] && rm -f /var/run/winbindd.pid

	echo "remove /var/lock/subsys/winbindd"
	[ -e /var/lock/subsys/winbindd ] && rm -f /var/lock/subsys/winbindd
	echo "remove /var/lock/subsys/smb"
	[ -e /var/lock/subsys/smb ] && rm -f /var/lock/subsys/smb
fi

echo "remove tdb files in /var/cache/samba/"
[ -d /var/cache/samba/ ] && find /var/cache/samba/ -name "*.tdb" -exec rm {} \;

echo "remove tdb files in /var/lib/samba/"
[ -d /var/lib/samba/ ] && find /var/lib/samba/ -name "*.tdb" -exec rm {} \;
