/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file PrefsPage.h
    \author Romain BONDUE
    \date 19/07/2006 */
#ifndef __PREFSPAGE_H__
#define __PREFSPAGE_H__

#include <string>
#include <vector>

extern "C"{
#include <gtk/gtk.h>
}



namespace nsGUI
{
    class CPrefsPage
    {
      public :
        CPrefsPage (bool) throw();
        operator ::GtkWidget* () throw();
        operator const ::GtkWidget* () const throw();
        bool StartMinimized () const throw();
        void StartMinimized (bool) throw();
            // CallBack : void (*) (void*)
        void AddChangeInterfaceCallBack (::GCallback, void*) throw();
            // CallBack : void (*) (void*)
        void AddRootModeChangedCallBack (::GCallback, void*) throw();
            // Don't forget that this function will call the previous handlers.
        void SetRootMode (bool) throw();
            // CallBack : void (*) (void*)
        void AddAutoLeaveRootModeCallBack (::GCallback, void*) throw();
            /** \return 0 if disabled. The delay in second otherwise. */
        unsigned GetAutoLeaveRootDelay () const throw();
            /** \param 0 to disable. Must be a valid delay in second. */
        void SetAutoLeaveRootDelay (unsigned) throw();
        void SetRates (const std::vector<int>&) throw();
        int GetSelectedRate () const throw();
        unsigned GetSelectedRateIndex () const throw();
        void SetRateIndex (unsigned) throw();
            // CallBack : void (*) (::GtkComboBox*, void*)
        void AddRateChangedCallBack (::GCallback, void*) throw();
        bool DisplayTrayIcon () const throw();
        void DisplayTrayIcon (bool) throw();
            // CallBack : void (*) (void*)
        void AddTrayIconButtonCallBack (::GCallback, void*) throw();
            // CallBack : void (*) (void*)
        void AddIfaceStatusChangeCallBack (::GCallback, void*) throw();
            // false : down
        void IfaceStatus (bool) throw();
        bool IfaceStatus () const throw();
        void IfaceLabel (const std::string&) throw();
        std::string IfaceLabel () const throw();


      protected :
        void BuildUI (bool) throw();


      private :
        ::GtkTable* const m_pTable;
        ::GtkCheckButton* const m_pStartMinimizedButton;
        ::GtkButton* const m_pAboutButton;
        ::GtkButton* const m_pChangeInterface;
        ::GtkToggleButton* const m_pRootModeButton;
        ::GtkComboBox* const m_pLeaveRootModeBox;
        ::GtkWidget* const m_pRatesLabel;
        unsigned m_NbRate;
        ::GtkComboBox* const m_pRatesBox;
        ::GtkCheckButton* const m_pTrayIconButton;
        ::GtkToggleButton* const m_pIfaceStatusButton;
        ::GtkLabel* m_pIfaceLabel;

        static void AboutButtonClicked (::GtkButton*, CPrefsPage*) throw();
        static void TrayIconButtonClicked (::GtkToggleButton*, CPrefsPage*)
                                                                    throw();

    }; // CPrefsPage

} // namespace nsGUI

#include "private/PrefsPage.hxx"

#endif // __PREFSPAGE_H__
