/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2005: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 31/May/2005                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

char * progname;

void use(void)
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s class mode filename(s)\n\n"), progname);  
    }

int main(int argc, char ** argv)
{
  int res = 0;
  int i,mode;
  rsbac_pm_object_class_id_t class;

  locale_init();
  progname = argv[0];
  if (argc > 3)
    {
      class = strtol(argv[1],0,10);
      mode  = strtol(argv[2],0,8);
      printf(gettext("%s: %i files of class %i, mode %o to be created\n\n"),
             argv[0], argc - 3, class, mode);
      for (i=1;i < (argc-2);i++)
        {
          printf(gettext("Processing %s (No. %i)\n"),
                 argv[i+2], i);
          res = rsbac_pm_create_file(argv[i+2],mode,class);
          error_exit(res);
        }
    }
  else
    {
      use();
      return 1;
    }
    
  return (res);
}

