.\" 
.\"/*************************************************
.\"*     rpld - an IBM style RIPL server            *
.\"*************************************************/
.\"
.\"Copyright (c) 1999,2000, James McKenzie.
.\"                     All rights reserved
.\"Copyright (c) 1998,2000, Christopher Lightfoot.
.\"                     All rights reserved
.\"
.\"By using this file, you agree to the terms and conditions set
.\"forth in the LICENSE file which can be found at the top level of
.\"the rpld distribution.
.\"
.\"IBM is a trademark of IBM Corp.
.\"
.\"
.\"
.\" $Id: rpld.man,v 1.12 2000/09/26 03:44:29 root Exp $;
.\"
.\" $Log: rpld.man,v $
.\" Revision 1.12  2000/09/26 03:44:29  root
.\" #
.\"
.\" Revision 1.11  2000/09/26 02:31:38  root
.\" #
.\"
.\" Revision 1.10  2000/07/17 10:43:34  root
.\" #
.\"
.\" Revision 1.9  2000/07/16 21:09:57  root
.\" #
.\"
.\" Revision 1.8  2000/07/16 14:22:06  root
.\" #
.\"
.\" Revision 1.7  2000/07/16 14:05:28  root
.\" #
.\"
.\" Revision 1.6  2000/07/16 13:18:10  root
.\" #
.\"
.\" Revision 1.1  2000/07/16 13:16:33  root
.\" #
.\"
.\" Revision 1.10  1999/09/15 01:22:18  root
.\" #
.\"
.\" Revision 1.9  1999/09/15 00:36:29  root
.\" #
.\"
.\" Revision 1.8  1999/09/15 00:25:57  root
.\" #
.\"
.\" Revision 1.7  1999/09/15 00:22:07  root
.\" #
.\"
.\" Revision 1.6  1999/09/15 00:14:29  root
.\" #
.\"
.\" Revision 1.5  1999/09/14 21:43:30  root
.\" #
.\"
.\" Revision 1.4  1999/09/14 21:37:08  root
.\" #
.\"
.\" Revision 1.3  1999/09/14 21:32:12  root
.\" #
.\"
.\" Revision 1.2  1999/09/14 21:25:59  root
.\" #
.\"
.\" Revision 1.1  1999/09/14 21:00:47  root
.\" #
.\"
.\" Revision 1.1  1999/09/14 17:19:37  root
.\" Initial revision
.\"
.\";
.Dd Jun 16, 2000
.Dt RPLD 8
.Os Linux
.Sh NAME
.Nm rpld
.Nd an RPL/RIPL remote boot server
.Sh SYNOPSIS
.Nm rpld 
[\fI-f\fR] [\fI-C\ configfile\fR] [\fI-i\ iface\fR] [\fI-s\ sap\fR] [\fI-h\fR] 
.Sh WARRANTY
.Nm rpld 
DOES NOT come with ANY WARRANTY, NOT even an IMPLIED WARRANTY.
.Sh OPTIONS
.Bl -tag -width Op
.It \fB\-f\fR
this flag causes \fBrpld\fR to run in the foreground, and not to fork and run as a daemon.
.It \fB\-C\fR\ \fIconfigfile\fR
causes \fBrpld\fR to read \fIconfigfile\fR rather than the default configuration file.
.It \fB\-i\fR\ \fIiface\fR
causes \fBrpld\fR to bind to network interface \fIiface\fR rather than the default. Because of the limitations of the LLC 802.2 protocol rpld can only bind to one interface.
.It \fB\-s\fR\ \fIsap\fR
changes the SAP number that \fBrpld\fR binds to. The IBM standard says this should be 0xf8 but most network cards seem to use 0xfc and some even use 0xf4. You can specify the sap as either a hex number with a leading 0x or a decimal one. Beware of specificing a SAP number which is used for system control packets on a machine with native llc support.
.It \fB\-h\fR
causes \fBrpld\fR to print a brief help message.
.El
.Sh DESCRIPTION
.Nm rpld 
will net-boot IBM style RPL boot ROMs. Communication between the client and the
server is done in LLC-1 ui/C frames with the source and destination SAP both 
being 0xfc. On booting the client transmits a FIND frame containing the client's
MAC address, adapter type and frame length. The server replies with a FOUND frame
containing the server's MAC address and a possibly smaller frame length. The
client issues a SEND.FILE.REQUEST frame requesting the first block of the boot
file. The server then issues a sequence of FILE.DATA.RESPONSE frames with 
increasing block numbers. The FILE.DATA.RESPONSE frames contain a load address
and an execute address and a flag. If the client fails to receive a  
FILE.DATA.RESPONSE frame within a certain period it sends another 
SEND.FILE.REQUEST frame requesting the block which follows the last block that
was successfully received. On the last FILE.DATA.RESPONSE frame the server
sets a special value of the flags which cause the client to transfer execution
to the execute address specified in the frame.
.Pp
The server starts by reading the configuration file in /etc/rpld.conf,
see 
.Pa rpld.conf(5),
After the configuration file has been read, it opens the system's
default network interface and listens for RPL frames.
The server recalculates the length of all the files to be downloaded every time
it receives a SEND.FILE.REQUEST frame. 
.Sh BUGS
.Bl -tag -width 0 -compact
.It
Solenopsis invicta Burens
.It
rpld doesn't support the new bzImage format correctly.
.It
rpld doesn't reload the first 512 octets of Linux kernels automatically.
.It
There is no way to make rpld re-read its configuration file.
.It
When concurrently serving multiple clients rpld will choose the pacing value of the slowest one.
.It
Partial ethernet addresses should be specified in bits not bytes.
.It
rpld needs to meet more network adapters.
.Sh NOTES
.Pp
IBM is a trademark of IBM Corp.
.Pp There are a number of drivers now provided with rpld read the README file
and the makefile in the distribution for more information.
.Sh FILES
.Bl -tag -width /etc/rpld.conf -compact
.Pp
.It Pa /usr/sbin/rpld
.It Pa /etc/rpld.conf
.It Pa /rplboot
.El
.Sh SEE ALSO
.Pp
.Bl -tag -width 0 -compact
.It Pa rpld\.conf(5),
.It Pa bootpd(1),
.It Pa dhcpd(1),
.It Pa http://gimel.esc.cam.ac.uk/james/rpld;
.El
.Sh AUTHORS AND COPYRIGHT
.Pp
(c) 1999,2000 James McKenzie, and Christopher Lightfoot. All rights reserved.
