/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 2000,2001 James McKenzie.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */

static char rcsid[] =
  "$Id: llc-linux.c,v 1.10 2001/11/01 15:24:26 root Exp $";

/*
 * $Log: llc-linux.c,v $
 * Revision 1.10  2001/11/01 15:24:26  root
 * #
 *
 * Revision 1.9  2000/09/26 04:06:07  root
 * #
 *
 * Revision 1.8  2000/09/26 03:48:23  root
 * #
 *
 * Revision 1.7  2000/09/26 03:45:52  root
 * #
 *
 * Revision 1.6  2000/09/26 02:32:46  root
 * #
 *
 * Revision 1.5  2000/09/26 01:42:24  root
 * #
 *
 * Revision 1.4  2000/09/26 01:41:22  root
 * #
 *
 * Revision 1.3  2000/09/26 01:41:08  root
 * #
 *
 * Revision 1.2  2000/09/26 01:39:17  root
 * #
 *
 * Revision 1.1  2000/09/26 01:03:19  root
 * #
 *
 *
 */


#include "project.h"
#include "llc.h"

#undef __GLIBC__
#include <linux/socket.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>
#include <linux/if_packet.h>
#include <linux/llc.h>
#define __GLIBC__


struct llcdrv_nat
{
  LLCDRV;
  int fd;
  unsigned char smac[ETH_ALEN];
  int sap;
  char *name;
};

#ifdef DEBUG
static void
hexdump (char *p, unsigned char *buf, int l)
{
  int i;

  for (i = 0; i < l; ++i)
    {
      if ((i % 16) == 0)
        {
          printf ("%s: ", p);
        }
      printf ("%02x ", buf[i]);
      if ((i % 16) == 15)
        {
          printf ("\n");
        }
    }

  printf ("\n");


}
#endif

static void
get_hwaddr (unsigned char *name, unsigned char *addr)
{
  struct ifreq ifr;
  int fd = socket (AF_INET, SOCK_DGRAM, 0);

  if (fd < 0)
    {
      syslog (LOG_ERR, "socket:%m");
      return;
    }
  bcopy (name, &ifr.ifr_name, sizeof (ifr.ifr_name));


  /* find my own hardware address */
  if (ioctl (fd, SIOCGIFHWADDR, &ifr) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "ioctl(SIOCGIFHWADDR):%m");
      exit (-1);
    }
  close (fd);

  bcopy (&ifr.ifr_hwaddr.sa_data, addr, ETH_ALEN);

}

static int
llc_nat_send (struct llcdrv *llc, unsigned char *dmac, unsigned char dsap,
              unsigned char *buf, int len)
{
  struct llcdrv_nat *llc_nat = (struct llcdrv_nat *) llc;
  struct sockaddr_llc sllc;

  sllc.sllc_family = AF_LLC;

  sllc.sllc_ssap = llc_nat->sap;
  bcopy (llc_nat->smac, sllc.sllc_smac, ETH_ALEN);

  sllc.sllc_dsap = dsap;
  bcopy (dmac, sllc.sllc_dmac, ETH_ALEN);

#ifdef DEBUG
  printf ("Sending %d bytes from %d (%s)",
          len, sllc.sllc_ssap, ethtoa (sllc.sllc_smac));
  printf ("	           to %d (%s)\n",
          sllc.sllc_dsap, ethtoa (sllc.sllc_dmac));

//  hexdump ("write", buf, len);
#endif

  return sendto (llc_nat->fd, buf, len, 0, &sllc, sizeof (sllc));


}


static int
llc_nat_recv (struct llcdrv *llc, unsigned char *buf, int len,
              unsigned char *smac, unsigned char *ssap, struct timeval *tv)
{
  struct llcdrv_nat *llc_nat = (struct llcdrv_nat *) llc;
  struct sockaddr_llc sllc;
  int fromlen = sizeof (sllc);
  fd_set rfds;
  int ret;

  FD_ZERO (&rfds);
  FD_SET (llc_nat->fd, &rfds);

  ret = select ((llc_nat->fd) + 1, &rfds, NULL, NULL, tv);

  if (ret < 0)
    return (ret);

  if (!FD_ISSET ((llc_nat->fd), &rfds))
    return 0;

  ret = recvfrom (llc_nat->fd, buf, len, 0, &sllc, &fromlen);


  if (smac)
    bcopy (sllc.sllc_smac, smac, ETH_ALEN);
  if (ssap)
    *ssap = sllc.sllc_ssap;

#ifdef DEBUG
  printf ("llc-nat-recv: source: %s ", ethtoa (sllc.sllc_smac));
  printf ("len: 0x%04x ", ret);
  printf ("dsap:%02x ssap:%02x \n", sllc.sllc_dsap, sllc.sllc_ssap);
#endif

  return ret;

}

static int
llc_nat_add_multicast (struct llcdrv *llc, unsigned char *mac)
{
  struct llcdrv_nat *llc_nat = (struct llcdrv_nat *) llc;
  struct ifreq ifr;
  int fd = socket (AF_INET, SOCK_DGRAM, 0);

  strncpy (ifr.ifr_name, llc_nat->name, sizeof (ifr.ifr_name));

  ifr.ifr_hwaddr.sa_family = AF_UNSPEC;

  bcopy (mac, ifr.ifr_hwaddr.sa_data, ETH_ALEN);

  if (ioctl (fd, SIOCADDMULTI, &ifr) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "ioctl(SIOCADDMULTI):%m");
      return -1;
    }

  return 0;
}

static unsigned char *
llc_nat_mac (struct llcdrv *llc)
{
  struct llcdrv_nat *llc_nat = (struct llcdrv_nat *) llc;
  return llc_nat->smac;
}

static void
llc_nat_close (struct llcdrv *llc)
{
  struct llcdrv_nat *llc_nat = (struct llcdrv_nat *) llc;
  close (llc_nat->fd);
  free (llc_nat);
}

struct llcdrv *
llc_open (unsigned char sap, char *name)
{
  struct llcdrv_nat *llc_nat;
  struct sockaddr_llc sllc;


  llc_nat = malloc (sizeof (struct llcdrv_nat));
  bzero (llc_nat, sizeof (struct llcdrv));

  llc_nat->fd = socket (PF_LLC, SOCK_DGRAM, 0);
  if (llc_nat->fd < 0)
    {
      syslog (LOG_ERR, "socket:%m");
      free (llc_nat);
      return NULL;
    }

  if (!name)
    name = "eth0";

  get_hwaddr (name, llc_nat->smac);

  llc_nat->sap = sap;

  bzero (&sllc, sizeof (sllc));
  sllc.sllc_family = AF_LLC;
  sllc.sllc_ssap = sap;
  sllc.sllc_dsap = sap;
  bcopy (llc_nat->smac, &sllc.sllc_smac, ETH_ALEN);

  if (bind (llc_nat->fd, &sllc, sizeof (sllc)) < 0)
    {
      close (llc_nat->fd);
      free (llc_nat);
      syslog (LOG_ERR, "bind:%m");
      return NULL;
    }

  llc_nat->recv = llc_nat_recv;
  llc_nat->send = llc_nat_send;
  llc_nat->mac = llc_nat_mac;
  llc_nat->add_multicast = llc_nat_add_multicast;
  llc_nat->close = llc_nat_close;
  llc_nat->name = strdup (name);


  return (struct llcdrv *) llc_nat;
}
